/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.adapter;

import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import net.babelsoft.negatron.controller.DeviceController;
import net.babelsoft.negatron.model.item.Software;
import net.babelsoft.negatron.model.item.SoftwarePart;

public class SoftwarePartAdapter {
    private final Software software;
    private final SoftwarePart softwarePart;
    private final List<DeviceController> devices;
    private ObjectProperty<DeviceController> assignment;

    public static String getName(Software software, SoftwarePart softwarePart) {
        return software.getName() + ":" + softwarePart.getName();
    }

    public SoftwarePartAdapter(Software software, SoftwarePart softwarePart, List<DeviceController> devices) {
        this.software = software;
        this.softwarePart = softwarePart;
        this.devices = devices;
        this.assignment = new SimpleObjectProperty();
    }

    public String getName() {
        return SoftwarePartAdapter.getName(this.software, this.softwarePart);
    }

    public String getDescription() {
        return this.softwarePart.getDescription();
    }

    public String getPartName() {
        return this.softwarePart.getName();
    }

    public List<DeviceController> getDevices() {
        return this.devices;
    }

    public ObjectProperty<DeviceController> assignmentProperty() {
        return this.assignment;
    }

    public void setAssignment(DeviceController device) {
        this.assignment.set((Object)device);
    }

    public DeviceController getAssignment() {
        return (DeviceController)this.assignment.get();
    }
}

