/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.adapter;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumnBase;
import net.babelsoft.negatron.io.configuration.TableColumnBaseConfiguration;

public class TableColumnsAdapter<C extends TableColumnBase, CC extends TableColumnBaseConfiguration> {
    private final ObservableList<C> columns;
    private final ObservableList<C> sortedColumns;
    private final BiConsumer<C, CC> setColumnSortType;
    private final BiConsumer<CC, C> setConfigurationSortType;
    private final Class<CC> configurationType;
    private final Consumer<Map<String, CC>> updateConfiguration;

    public TableColumnsAdapter(ObservableList<C> columns, ObservableList<C> sortedColumns, BiConsumer<C, CC> setColumnSortType, BiConsumer<CC, C> setConfigurationSortType, Class<CC> configurationType, Consumer<Map<String, CC>> updateConfiguration) {
        this.columns = columns;
        this.sortedColumns = sortedColumns;
        this.setColumnSortType = setColumnSortType;
        this.setConfigurationSortType = setConfigurationSortType;
        this.configurationType = configurationType;
        this.updateConfiguration = updateConfiguration;
    }

    public void loadLayout(Map<String, CC> confs) {
        if (confs.size() == this.columns.size()) {
            this.columns.sort((col1, col2) -> {
                TableColumnBaseConfiguration conf1 = (TableColumnBaseConfiguration)confs.get(col1.getId());
                TableColumnBaseConfiguration conf2 = (TableColumnBaseConfiguration)confs.get(col2.getId());
                if (conf1 != null && conf2 != null) {
                    return Integer.compare(conf1.getOrder(), conf2.getOrder());
                }
                return 0;
            });
            this.sortedColumns.clear();
            this.columns.forEach(col -> {
                TableColumnBaseConfiguration conf = (TableColumnBaseConfiguration)confs.get(col.getId());
                if (conf != null) {
                    if (conf.isSorted()) {
                        this.sortedColumns.add(col);
                        this.setColumnSortType.accept(col, conf);
                    }
                    col.setVisible(conf.isVisible());
                    col.setPrefWidth(conf.getWidth());
                }
            });
            this.sortedColumns.sort((col1, col2) -> {
                TableColumnBaseConfiguration conf1 = (TableColumnBaseConfiguration)confs.get(col1.getId());
                TableColumnBaseConfiguration conf2 = (TableColumnBaseConfiguration)confs.get(col2.getId());
                return Integer.compare(conf1.getSortRank(), conf2.getSortRank());
            });
        }
    }

    public void saveColumnsLayout(String id) {
        HashMap<String, TableColumnBaseConfiguration> confMap = new HashMap<String, TableColumnBaseConfiguration>();
        for (int i = 0; i < this.columns.size(); ++i) {
            try {
                TableColumnBase col = (TableColumnBase)this.columns.get(i);
                TableColumnBaseConfiguration conf = (TableColumnBaseConfiguration)this.configurationType.newInstance();
                conf.setName(col.getId());
                conf.setOrder(i);
                conf.setSorted(this.sortedColumns.contains((Object)col));
                conf.setSortRank(this.sortedColumns.indexOf((Object)col));
                this.setConfigurationSortType.accept(conf, col);
                conf.setVisible(col.isVisible());
                conf.setWidth(col.getWidth());
                confMap.put(col.getId(), conf);
                continue;
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        this.updateConfiguration.accept(confMap);
    }
}

