/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.form;

import java.io.File;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.util.Shell;
import net.babelsoft.negatron.view.control.form.SinglePathField;

public class ChdmanPathField
extends SinglePathField {
    public ChdmanPathField(GridPane grid, int row) {
        super(grid, row, "chdman", "CHDMAN", Language.Manager.getString("chdman.tooltip"));
        this.pathField.setText(Configuration.Manager.getChdmanExecutable());
        this.pathField.textProperty().addListener((o, oV, newValue) -> this.updateChdmanPath((String)newValue));
        this.browseButton.setOnAction(event -> {
            FileChooser fc = new FileChooser();
            if (!this.pathField.getText().isEmpty()) {
                fc.setInitialDirectory(new File(this.pathField.getText()).getParentFile());
            } else {
                fc.setInitialDirectory(new File("."));
            }
            if (Shell.isWindows()) {
                fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CHDMAN", new String[]{"chdman.exe"}));
            } else {
                fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CHDMAN", new String[]{"chdman"}));
            }
            fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(Language.Manager.getString("allFiles"), new String[]{"*"}));
            File f = fc.showOpenDialog(this.browseButton.getScene().getWindow());
            if (f != null) {
                this.pathField.setText(f.getAbsolutePath());
            }
        });
    }
}

