/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.form;

import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.RowConstraints;
import net.babelsoft.negatron.io.configuration.Domain;
import net.babelsoft.negatron.view.control.form.MultiPathField;

public class GridAdornment {
    private static final Image MACHINE_IMG = new Image(MultiPathField.class.getResourceAsStream("/net/babelsoft/negatron/resource/icon/machine.png"));
    private static final Image SOFTWARE_IMG = new Image(MultiPathField.class.getResourceAsStream("/net/babelsoft/negatron/resource/icon/software.png"));

    public static void insertSpacing(GridPane grid, int row, double spacing) {
        RowConstraints constraints = new RowConstraints();
        constraints.setMinHeight(spacing);
        grid.getRowConstraints().add((Object)constraints);
    }

    public static void insertTitle(GridPane grid, int row, double height, String text) {
        RowConstraints constraints = new RowConstraints();
        constraints.setMinHeight(height);
        grid.getRowConstraints().add((Object)constraints);
        Label label = new Label(text);
        grid.add((Node)label, 0, row, 3, 1);
        GridPane.setHalignment((Node)label, (HPos)HPos.CENTER);
    }

    public static void insertHeader(GridPane grid, int row, double minHeight, Domain style) {
        HBox box = new HBox(10.0);
        box.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
        box.setAlignment(Pos.CENTER_RIGHT);
        RowConstraints constraints = new RowConstraints();
        constraints.setMinHeight(minHeight);
        grid.getRowConstraints().add((Object)constraints);
        grid.add((Node)box, 0, row, 3, 1);
        switch (style) {
            case EXTRAS_MACHINE_SOFTWARE: 
            case MULTIMEDIA_MACHINE_SOFTWARE: {
                box.getChildren().add((Object)new ImageView(MACHINE_IMG));
                box.getChildren().add((Object)new ImageView(SOFTWARE_IMG));
                break;
            }
            case EXTRAS_MACHINE_ONLY: 
            case MULTIMEDIA_MACHINE_ONLY: {
                box.getChildren().add((Object)new ImageView(MACHINE_IMG));
                break;
            }
            case EXTRAS_SOFTWARE_ONLY: {
                box.getChildren().add((Object)new ImageView(SOFTWARE_IMG));
            }
        }
    }
}

