/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.form;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.layout.GridPane;
import javafx.util.StringConverter;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.util.Strings;
import net.babelsoft.negatron.util.function.Delegate;
import net.babelsoft.negatron.view.control.form.ChoiceField;

public class LanguageChoiceField
extends ChoiceField<Locale> {
    Delegate onRestart;

    public LanguageChoiceField(GridPane grid, int row) {
        super(grid, row, Language.Manager.getString("language"), Language.Manager.getString("language.tooltip"));
        Locale locale;
        this.choiceBox.getItems().add((Object)Locale.UK);
        Path path = Paths.get(Language.Manager.ROOT_PATH, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        int i;
                        String filename = file.getFileName().toString();
                        if (filename.matches(Language.Manager.MASK) && (i = filename.indexOf(95)) >= 0) {
                            String locale = filename.substring(i + 1, filename.length() - 11).replace('_', '-');
                            LanguageChoiceField.this.choiceBox.getItems().add((Object)Locale.forLanguageTag(locale));
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                        if (e == null) {
                            return FileVisitResult.CONTINUE;
                        }
                        throw e;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.choiceBox.setConverter((StringConverter)new StringConverter<Locale>(){

            public String toString(Locale locale) {
                return locale.getDisplayName(locale);
            }

            public Locale fromString(String string) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        String language = Configuration.Manager.getLanguage();
        if (Strings.isEmpty(language)) {
            locale = Locale.getDefault();
            if (!this.choiceBox.getItems().contains((Object)locale)) {
                locale = Locale.UK;
            }
        } else {
            locale = Locale.forLanguageTag(language);
        }
        this.choiceBox.getSelectionModel().select((Object)locale);
        this.choiceBox.getSelectionModel().selectedItemProperty().addListener((o, oV, newValue) -> {
            try {
                Configuration.Manager.updateLanguage(newValue.toLanguageTag());
            }
            catch (IOException ex) {
                Logger.getLogger(LanguageChoiceField.class.getName()).log(Level.SEVERE, "Couldn't save requested language configuration", ex);
            }
            Locale.setDefault(newValue);
            this.onRestart.fire();
        });
    }

    public void setOnRestart(Delegate delegate) {
        this.onRestart = delegate;
    }
}

