/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.form;

import java.io.File;
import javafx.css.PseudoClass;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.util.Strings;
import net.babelsoft.negatron.view.control.form.SinglePathField;

public class MameIniField
extends SinglePathField {
    private static final PseudoClass ERROR_CLASS = PseudoClass.getPseudoClass((String)"error");

    public MameIniField(GridPane grid, int row, boolean isMess) {
        super(grid, row, "mameIni", isMess ? Language.Manager.getString("mameIni").replaceFirst("MAME", "MESS") : Language.Manager.getString("mameIni"), isMess ? Language.Manager.getString("mameIni.tooltip").replaceFirst("MAME", "MESS") : Language.Manager.getString("mameIni.tooltip"));
        String mameIni = Configuration.Manager.getMameIni();
        if (Strings.isValid(mameIni)) {
            this.pathField.setText(mameIni);
            this.pathField.pseudoClassStateChanged(ERROR_CLASS, false);
        } else {
            this.pathField.pseudoClassStateChanged(ERROR_CLASS, true);
        }
        this.pathField.textProperty().addListener((o, oV, newValue) -> {
            if (newValue.isEmpty()) {
                this.pathField.pseudoClassStateChanged(ERROR_CLASS, true);
            } else {
                this.pathField.pseudoClassStateChanged(ERROR_CLASS, false);
            }
            this.updateMameIni((String)newValue);
        });
        this.browseButton.setOnAction(event -> {
            FileChooser fc = new FileChooser();
            if (!this.pathField.getText().isEmpty()) {
                fc.setInitialDirectory(new File(this.pathField.getText()).getParentFile());
            } else {
                fc.setInitialDirectory(new File("."));
            }
            fc.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{isMess ? new FileChooser.ExtensionFilter("mess.ini", new String[]{"*mess*.ini"}) : new FileChooser.ExtensionFilter("mame.ini", new String[]{"*mame*.ini"}), new FileChooser.ExtensionFilter(Language.Manager.getString("allFiles"), new String[]{"*"})});
            File f = fc.showOpenDialog(this.browseButton.getScene().getWindow());
            if (f != null) {
                this.pathField.setText(f.getAbsolutePath());
            }
        });
    }
}

