/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.form;

import java.io.File;
import javafx.css.PseudoClass;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.util.Shell;
import net.babelsoft.negatron.util.Strings;
import net.babelsoft.negatron.view.control.form.SinglePathField;

public class MamePathField
extends SinglePathField {
    private static final PseudoClass ERROR_CLASS = PseudoClass.getPseudoClass((String)"error");

    public MamePathField(GridPane grid, int row, boolean isMess) {
        super(grid, row, "mameExe", isMess ? Language.Manager.getString("mameExe").replaceFirst("MAME", "MESS") : Language.Manager.getString("mameExe"), isMess ? Language.Manager.getString("mameExe.tooltip").replaceFirst("MAME", "MESS") : Language.Manager.getString("mameExe.tooltip"));
        String mamePath = Configuration.Manager.getMameExecutable();
        if (Strings.isValid(mamePath)) {
            this.pathField.setText(mamePath);
            this.pathField.pseudoClassStateChanged(ERROR_CLASS, false);
        } else {
            this.pathField.pseudoClassStateChanged(ERROR_CLASS, true);
        }
        this.pathField.textProperty().addListener((o, oV, newValue) -> {
            if (newValue.isEmpty()) {
                this.pathField.pseudoClassStateChanged(ERROR_CLASS, true);
            } else {
                this.pathField.pseudoClassStateChanged(ERROR_CLASS, false);
            }
            this.updateMamePath((String)newValue);
        });
        this.browseButton.setOnAction(event -> {
            FileChooser fc = new FileChooser();
            if (!this.pathField.getText().isEmpty()) {
                fc.setInitialDirectory(new File(this.pathField.getText()).getParentFile());
            } else {
                fc.setInitialDirectory(new File("."));
            }
            if (Shell.isWindows()) {
                fc.getExtensionFilters().add((Object)(isMess ? new FileChooser.ExtensionFilter("MESS", new String[]{"*mess*.exe"}) : new FileChooser.ExtensionFilter("MAME", new String[]{"*mame*.exe"})));
            } else {
                fc.getExtensionFilters().add((Object)(isMess ? new FileChooser.ExtensionFilter("MESS", new String[]{"*mess*"}) : new FileChooser.ExtensionFilter("MAME", new String[]{"*mame*"})));
            }
            fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(Language.Manager.getString("allFiles"), new String[]{"*"}));
            File f = fc.showOpenDialog(this.browseButton.getScene().getWindow());
            if (f != null) {
                this.pathField.setText(f.getAbsolutePath());
            }
        });
    }
}

