/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.form;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.stage.DirectoryChooser;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.configuration.Domain;
import net.babelsoft.negatron.util.Strings;
import net.babelsoft.negatron.view.control.form.MultiPathField;
import net.babelsoft.negatron.view.control.form.SinglePathField;

public class MasterConfigPathField
extends SinglePathField {
    private List<TextField> dependentSingleFields;
    private List<MultiPathField> dependentMultiFields;
    private Domain domain;

    public MasterConfigPathField(GridPane grid, int row, Domain domain, String styleClass, String label, String text, String prompt) {
        super(grid, row, styleClass, label, prompt);
        this.domain = domain;
        this.pathField.setText(text);
        this.pathField.focusedProperty().addListener((o, oV, newValue) -> {
            if (newValue.booleanValue()) {
                Configuration.Manager.beginMasterConfigTransaction();
                this.setDependentPathFields(this.pathField.getText(), "");
            } else {
                this.resetDependentPathFields();
                this.commitMasterConfigTransaction(this.domain);
            }
        });
        this.pathField.textProperty().addListener((o, oldValue, newValue) -> {
            if (this.dependentMultiFields == null) {
                Configuration.Manager.setMasterConfigPoint();
                this.setDependentPathFields((String)oldValue, (String)newValue);
            }
            this.dependentMultiFields.forEach(multiField -> this.dependentSingleFields.addAll(multiField.addDefaultPaths((String)newValue)));
            if (this.dependentMultiFields.size() > 0) {
                this.dependentMultiFields.clear();
            }
            this.dependentSingleFields.forEach(field -> field.setText(field.getText().replaceFirst(Matcher.quoteReplacement(oldValue), Matcher.quoteReplacement(newValue))));
            if (this.updateMasterConfigPath(this.domain, (String)newValue)) {
                this.resetDependentPathFields();
            }
        });
        this.browseButton.setOnAction(event -> {
            DirectoryChooser dc = new DirectoryChooser();
            if (!this.pathField.getText().isEmpty()) {
                dc.setInitialDirectory(new File(this.pathField.getText()));
            } else {
                dc.setInitialDirectory(new File("."));
            }
            File f = dc.showDialog(this.browseButton.getScene().getWindow());
            if (f != null) {
                this.pathField.setText(f.getAbsolutePath());
            }
        });
    }

    private void resetDependentPathFields() {
        this.dependentMultiFields = null;
        this.dependentSingleFields = null;
    }

    private void setDependentPathFields(String reference, String newReference) {
        this.dependentMultiFields = new ArrayList<MultiPathField>();
        if (reference.isEmpty()) {
            this.dependentSingleFields = new ArrayList<TextField>();
            MultiPathField.getList().forEach(multiField -> {
                List<TextField> fields = multiField.getPathFields();
                if ((this.domain == Domain.MULTIMEDIA_MACHINE_SOFTWARE && multiField.isMultimediaPath() || this.domain == Domain.EXTRAS_MACHINE_SOFTWARE && !multiField.isMultimediaPath()) && (Strings.isEmpty(newReference) || !multiField.isMamePath() || fields.stream().allMatch(field -> !field.getText().startsWith(newReference)))) {
                    this.dependentSingleFields.addAll(multiField.addDefaultPaths(reference));
                }
            });
        } else {
            this.dependentSingleFields = MultiPathField.getList().stream().flatMap(multiField -> {
                List<TextField> fields = multiField.getPathFields();
                if (this.domain == Domain.EXTRAS_MACHINE_SOFTWARE && multiField.isExtrasPath() && fields.stream().allMatch(field -> field.getText().isEmpty()) || this.domain == Domain.EXTRAS_MACHINE_SOFTWARE && multiField.isMamePath() && fields.stream().allMatch(field -> !field.getText().startsWith(reference)) || this.domain == Domain.MULTIMEDIA_MACHINE_SOFTWARE && multiField.isMultimediaPath() && fields.stream().allMatch(field -> field.getText().isEmpty())) {
                    this.dependentMultiFields.add((MultiPathField)multiField);
                    return null;
                }
                return fields.stream();
            }).filter(field -> field.getText().startsWith(reference)).collect(Collectors.toList());
        }
    }
}

