/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.form;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.configuration.Domain;
import net.babelsoft.negatron.io.configuration.PathCharset;
import net.babelsoft.negatron.io.configuration.PathPrimary;
import net.babelsoft.negatron.io.configuration.Property;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.util.Strings;
import net.babelsoft.negatron.view.control.form.Field;

public class MultiPathField
extends Field {
    private static final List<MultiPathField> list = new ArrayList<MultiPathField>();
    private final GridPane internalGrid;
    private final ToggleGroup machineToggleGroup;
    private final ToggleGroup softwareToggleGroup;
    private final String promptText;
    private final Property property;
    private final String[] fileFilters;
    private int internalCount;
    private final List<TextField> pathFields;
    private final List<ChoiceBox<String>> choices;
    private final List<RadioButton> machineRadios;
    private final List<RadioButton> softwareRadios;

    public static List<MultiPathField> getList() {
        return list;
    }

    public MultiPathField(GridPane grid, int row, Property property, String text, String promptText, String ... fileFilters) {
        list.add(this);
        this.promptText = promptText;
        this.property = property;
        this.fileFilters = fileFilters;
        this.pathFields = new ArrayList<TextField>();
        this.internalCount = 0;
        this.choices = property.getDomain() == Domain.EXTRAS_INFORMATION ? new ArrayList<ChoiceBox<String>>() : null;
        switch (property.getDomain()) {
            case EXTRAS_MACHINE_ONLY: 
            case MULTIMEDIA_MACHINE_ONLY: {
                this.machineToggleGroup = new ToggleGroup();
                this.softwareToggleGroup = null;
                this.machineRadios = new ArrayList<RadioButton>();
                this.softwareRadios = null;
                break;
            }
            case EXTRAS_SOFTWARE_ONLY: {
                this.machineToggleGroup = null;
                this.softwareToggleGroup = new ToggleGroup();
                this.machineRadios = null;
                this.softwareRadios = new ArrayList<RadioButton>();
                break;
            }
            case EXTRAS_MACHINE_SOFTWARE: 
            case MULTIMEDIA_MACHINE_SOFTWARE: {
                this.machineToggleGroup = new ToggleGroup();
                this.softwareToggleGroup = new ToggleGroup();
                this.machineRadios = new ArrayList<RadioButton>();
                this.softwareRadios = new ArrayList<RadioButton>();
                break;
            }
            default: {
                this.machineToggleGroup = null;
                this.softwareToggleGroup = null;
                this.machineRadios = null;
                this.softwareRadios = null;
            }
        }
        if (property.getDomain() == Domain.EXTRAS_MACHINE_ONLY || property.getDomain() == Domain.EXTRAS_MACHINE_SOFTWARE || property.getDomain() == Domain.MULTIMEDIA_MACHINE_ONLY || property.getDomain() == Domain.MULTIMEDIA_MACHINE_SOFTWARE) {
            this.machineToggleGroup.selectedToggleProperty().addListener((o, oV, newValue) -> {
                int index = this.machineRadios.indexOf(newValue);
                this.updateMachinePrimaryPath(property, this.pathFields.get(index).getText());
            });
        }
        if (property.getDomain() == Domain.EXTRAS_SOFTWARE_ONLY || property.getDomain() == Domain.EXTRAS_MACHINE_SOFTWARE || property.getDomain() == Domain.MULTIMEDIA_MACHINE_SOFTWARE) {
            this.softwareToggleGroup.selectedToggleProperty().addListener((o, oV, newValue) -> {
                int index = this.softwareRadios.indexOf(newValue);
                this.updateSoftwarePrimaryPath(property, this.pathFields.get(index).getText());
            });
        }
        RowConstraints constraints = new RowConstraints();
        grid.getRowConstraints().add((Object)constraints);
        Label label = new Label(text);
        label.setWrapText(true);
        grid.add((Node)label, 0, row);
        this.internalGrid = new GridPane();
        this.internalGrid.setHgap(5.0);
        this.internalGrid.setVgap(2.0);
        this.internalGrid.getStyleClass().add((Object)"multi-path-field");
        grid.add((Node)this.internalGrid, 1, row);
        GridPane.setHgrow((Node)this.internalGrid, (Priority)Priority.SOMETIMES);
        GridPane.setColumnSpan((Node)this.internalGrid, (Integer)2);
        Configuration.Manager.beginMasterConfigTransaction();
        if (property.getDomain() == Domain.EXTRAS_INFORMATION) {
            List<PathCharset> files = Configuration.Manager.getFilePaths(property);
            if (files.size() > 0) {
                for (int i = 0; i < files.size(); ++i) {
                    Button button = this.newField(fileFilters, files.get(i).getPath().toString(), files.get(i).getCharSet());
                    if (i != 0) continue;
                    button.setText("+");
                    button.setOnAction(event -> this.newField(fileFilters, new String[0]));
                }
            } else {
                Button addButton = this.newField(fileFilters, new String[0]);
                addButton.setText("+");
                addButton.setOnAction(event -> this.newField(fileFilters, new String[0]));
            }
        } else {
            List<String> folders = Configuration.Manager.getFolderPaths(property);
            if (folders.size() > 0) {
                for (int i = 0; i < folders.size(); ++i) {
                    Button button = this.newField(fileFilters, folders.get(i));
                    if (i == 0) {
                        button.setText("+");
                        button.setOnAction(event -> this.newField(fileFilters, new String[0]));
                    }
                    if (folders.get(i).equals(Configuration.Manager.getPrimaryMachineFolder(property))) {
                        this.machineRadios.get(i).setSelected(true);
                    }
                    if (!folders.get(i).equals(Configuration.Manager.getPrimarySoftwareFolder(property))) continue;
                    this.softwareRadios.get(i).setSelected(true);
                }
            } else {
                Button addButton = this.newField(fileFilters, new String[0]);
                addButton.setText("+");
                addButton.setOnAction(event -> this.newField(fileFilters, new String[0]));
                if (property.hasMachinePrimaryPath()) {
                    this.machineRadios.get(0).setSelected(true);
                }
                if (property.hasSoftwarePrimaryPath()) {
                    this.softwareRadios.get(0).setSelected(true);
                }
            }
        }
        Configuration.Manager.rollbackMasterConfigTransaction();
    }

    private Button newField(String[] fileFilters, String ... initialisingValues) {
        RadioButton softwareRadio;
        RadioButton machineRadio;
        Button fileButton;
        ChoiceBox choice;
        int column = 0;
        TextField pathField = new TextField();
        pathField.setPromptText(this.promptText);
        pathField.setTooltip(new Tooltip(this.promptText));
        this.internalGrid.add((Node)pathField, column++, this.internalCount);
        GridPane.setHgrow((Node)pathField, (Priority)Priority.SOMETIMES);
        this.pathFields.add(pathField);
        if (initialisingValues.length > 0 && initialisingValues[0] != null) {
            pathField.setText(initialisingValues[0]);
        }
        pathField.textProperty().addListener((o, oV, newValue) -> {
            int index = this.pathFields.indexOf(pathField);
            if (index == -1) {
                return;
            }
            if (this.property.getDomain() != Domain.EXTRAS_INFORMATION) {
                this.updateFolderPath(this.property, index, (String)newValue);
                if (this.property.hasMachinePrimaryPath() && this.machineRadios.get(index).isSelected()) {
                    this.updateMachinePrimaryPath(this.property, (String)newValue);
                }
                if (this.property.hasSoftwarePrimaryPath() && this.softwareRadios.get(index).isSelected()) {
                    this.updateSoftwarePrimaryPath(this.property, (String)newValue);
                }
            } else {
                this.updateFilePath(this.property, index, (String)newValue, (String)this.choices.get(index).getValue());
            }
        });
        if (this.property.getDomain() == Domain.EXTRAS_INFORMATION) {
            choice = new ChoiceBox(FXCollections.observableArrayList((Object[])new String[]{StandardCharsets.UTF_8.name(), StandardCharsets.UTF_16.name(), StandardCharsets.ISO_8859_1.name(), StandardCharsets.US_ASCII.name()}));
            this.internalGrid.add((Node)choice, column++, this.internalCount);
            this.choices.add((ChoiceBox<String>)choice);
            if (initialisingValues.length > 1 && initialisingValues[1] != null) {
                choice.getSelectionModel().select((Object)initialisingValues[1]);
            } else {
                choice.getSelectionModel().selectFirst();
            }
            choice.getSelectionModel().selectedItemProperty().addListener((o, oV, newValue) -> {
                int index = this.choices.indexOf(choice);
                if (index != -1) {
                    this.updateFilePath(this.property, index, this.pathFields.get(index).getText(), (String)newValue);
                }
            });
            fileButton = null;
        } else if (this.property.getDomain() != Domain.MAME_FOLDER_ONLY && fileFilters.length > 0) {
            choice = null;
            fileButton = new Button(Language.Manager.getString("file..."));
            this.internalGrid.add((Node)fileButton, column++, this.internalCount);
            fileButton.setOnAction(event -> {
                File f = this.handleOnFileAction(pathField, fileFilters);
                if (f != null) {
                    int i = f.getAbsolutePath().lastIndexOf(".");
                    pathField.setText(f.getAbsolutePath().substring(0, i));
                }
            });
        } else {
            choice = null;
            fileButton = null;
        }
        String browseLabel = Language.Manager.getString("folder...");
        if (this.property.getDomain() == Domain.MAME_FOLDER_ONLY || this.property.getDomain() == Domain.EXTRAS_INFORMATION || fileFilters.length == 0) {
            browseLabel = Language.Manager.getString("browse...");
        }
        Button browseButton = new Button(browseLabel);
        this.internalGrid.add((Node)browseButton, column++, this.internalCount);
        browseButton.setOnAction(event -> {
            File f = this.handleOnBrowseAction(pathField, fileFilters);
            if (f != null) {
                pathField.setText(f.getAbsolutePath());
            }
        });
        int subtractColumn = column++;
        switch (this.property.getDomain()) {
            case EXTRAS_MACHINE_SOFTWARE: 
            case MULTIMEDIA_MACHINE_SOFTWARE: {
                machineRadio = this.addRadio(this.machineToggleGroup, column++);
                softwareRadio = this.addRadio(this.softwareToggleGroup, column);
                this.machineRadios.add(machineRadio);
                this.softwareRadios.add(softwareRadio);
                break;
            }
            case EXTRAS_MACHINE_ONLY: 
            case MULTIMEDIA_MACHINE_ONLY: {
                machineRadio = this.addRadio(this.machineToggleGroup, column);
                this.machineRadios.add(machineRadio);
                softwareRadio = null;
                break;
            }
            case EXTRAS_SOFTWARE_ONLY: {
                machineRadio = null;
                softwareRadio = this.addRadio(this.softwareToggleGroup, column);
                this.softwareRadios.add(softwareRadio);
                break;
            }
            default: {
                machineRadio = null;
                softwareRadio = null;
            }
        }
        Button subtractButton = new Button();
        this.internalGrid.add((Node)subtractButton, subtractColumn, this.internalCount);
        subtractButton.setText("-");
        subtractButton.setOnAction(event -> this.handleOnSubtractButton(pathField, fileButton, browseButton, subtractButton, (ChoiceBox<String>)choice, machineRadio, softwareRadio));
        ++this.internalCount;
        return subtractButton;
    }

    private RadioButton addRadio(ToggleGroup toggleGroup, int column) {
        RadioButton radio = new RadioButton();
        radio.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        radio.setToggleGroup(toggleGroup);
        this.internalGrid.add((Node)radio, column, this.internalCount);
        return radio;
    }

    public List<TextField> addDefaultPaths(String rootFolder) {
        ArrayList<TextField> newFields;
        block8: {
            block7: {
                newFields = new ArrayList<TextField>();
                if (this.property.getDomain() != Domain.EXTRAS_INFORMATION) break block7;
                List<PathCharset> files = Configuration.Manager.getDefaultFilePaths(this.property, rootFolder);
                if (files == null || files.size() <= 0) break block8;
                BiConsumer<Integer, Integer> handleFile = (i, j) -> {
                    this.pathFields.get((int)i).setText(((PathCharset)files.get((int)j)).getPathString());
                    this.choices.get((int)i).getSelectionModel().select((Object)((PathCharset)files.get((int)j)).getCharSet());
                    newFields.add(this.pathFields.get((int)i));
                };
                int i2 = this.pathFields.size();
                int j2 = 0;
                if (i2 == 1 && this.pathFields.get(0).getText().isEmpty()) {
                    handleFile.accept(0, j2++);
                }
                while (j2 < files.size()) {
                    if (this.pathFields.size() <= i2) {
                        this.newField(this.fileFilters, new String[0]);
                    }
                    handleFile.accept(i2, j2);
                    ++i2;
                    ++j2;
                }
                break block8;
            }
            List<PathPrimary> folders = Configuration.Manager.getDefaultFolderPaths(this.property, rootFolder);
            if (folders != null && folders.size() > 0) {
                BiConsumer<Integer, Integer> handleFolder = (i, j) -> {
                    this.pathFields.get((int)i).setText(((PathPrimary)folders.get((int)j)).getPath());
                    if (((PathPrimary)folders.get((int)j)).isMachinePrimaryPath()) {
                        this.machineRadios.get((int)i).setSelected(true);
                    }
                    if (((PathPrimary)folders.get((int)j)).isSoftwarePrimaryPath()) {
                        this.softwareRadios.get((int)i).setSelected(true);
                    }
                    newFields.add(this.pathFields.get((int)i));
                };
                int i3 = this.pathFields.size();
                int j3 = 0;
                if (i3 == 1 && this.pathFields.get(0).getText().isEmpty()) {
                    handleFolder.accept(0, j3++);
                }
                while (j3 < folders.size()) {
                    if (this.pathFields.size() <= i3) {
                        this.newField(this.fileFilters, new String[0]);
                    }
                    handleFolder.accept(i3, j3);
                    ++i3;
                    ++j3;
                }
            }
        }
        return newFields;
    }

    boolean isMamePath() {
        return this.property.isMamePath();
    }

    boolean isExtrasPath() {
        return this.property.isExtrasPath();
    }

    boolean isMultimediaPath() {
        return this.property.isMultimediaPath();
    }

    public List<TextField> getPathFields() {
        return this.pathFields;
    }

    private File getInitialDirectory(TextField pathField) {
        File initialFile;
        String initialPath = pathField.getText();
        if (Strings.isEmpty(initialPath)) {
            initialPath = ".";
        }
        if ((initialFile = new File(initialPath)).getParent() != null) {
            initialFile = initialFile.getParentFile();
        }
        return initialFile;
    }

    private File handleOnFileAction(TextField pathField, String[] fileFilters) {
        File f;
        FileChooser fc = new FileChooser();
        fc.setInitialDirectory(this.getInitialDirectory(pathField));
        fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(fileFilters[0], new String[]{fileFilters[1]}));
        fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(Language.Manager.getString("allFiles"), new String[]{"*"}));
        try {
            f = fc.showOpenDialog(this.internalGrid.getScene().getWindow());
        }
        catch (IllegalArgumentException ex) {
            fc.setInitialDirectory(new File("."));
            f = fc.showOpenDialog(this.internalGrid.getScene().getWindow());
        }
        return f;
    }

    private File handleOnBrowseAction(TextField pathField, String[] fileFilters) {
        if (this.property.getDomain() != Domain.EXTRAS_INFORMATION) {
            File f;
            DirectoryChooser dc = new DirectoryChooser();
            dc.setInitialDirectory(this.getInitialDirectory(pathField));
            try {
                f = dc.showDialog(this.internalGrid.getScene().getWindow());
            }
            catch (IllegalArgumentException ex) {
                dc.setInitialDirectory(new File("."));
                f = dc.showDialog(this.internalGrid.getScene().getWindow());
            }
            return f;
        }
        return this.handleOnFileAction(pathField, fileFilters);
    }

    private void handleOnSubtractButton(TextField pathField, Button fileButton, Button browseButton, Button subtractButton, ChoiceBox<String> choice, RadioButton machineRadio, RadioButton softwareRadio) {
        int index = this.pathFields.indexOf(pathField);
        ObservableList nodes = this.internalGrid.getChildren();
        nodes.remove((Object)pathField);
        nodes.remove((Object)fileButton);
        nodes.remove((Object)browseButton);
        nodes.remove((Object)subtractButton);
        this.pathFields.remove(pathField);
        if (choice != null) {
            nodes.remove(choice);
            this.choices.remove(choice);
        }
        if (machineRadio != null) {
            nodes.remove((Object)machineRadio);
            this.machineRadios.remove(machineRadio);
            if (machineRadio.isSelected()) {
                this.machineRadios.get(0).setSelected(true);
            }
        }
        if (softwareRadio != null) {
            nodes.remove((Object)softwareRadio);
            this.softwareRadios.remove(softwareRadio);
            if (softwareRadio.isSelected()) {
                this.softwareRadios.get(0).setSelected(true);
            }
        }
        this.removePath(this.property, index);
    }
}

