/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.form;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import javafx.scene.layout.GridPane;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.theme.Skin;
import net.babelsoft.negatron.util.Strings;
import net.babelsoft.negatron.view.control.form.ChoiceField;

public class SkinChoiceField
extends ChoiceField<Skin> {
    private static final Skin DEFAULT_SKIN = new Skin("modena", "Modena (default)", "");

    public SkinChoiceField(GridPane grid, int row) {
        super(grid, row, Language.Manager.getString("skin"), Language.Manager.getString("skin.tooltip"));
        this.choiceBox.getItems().add((Object)DEFAULT_SKIN);
        Path path = Paths.get("theme/skin", new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path skinFile;
                        if (file.endsWith("manifest.mf") && Files.exists(skinFile = file.getParent().resolve(Paths.get("skin.css", new String[0])), new LinkOption[0])) {
                            String name = Files.lines(file).filter(line -> line.startsWith("Specification-Title:")).findAny().map(line -> line.substring(20).trim()).orElse(null);
                            String description = Files.lines(file).filter(line -> line.startsWith("Implementation-Title:")).findAny().map(line -> line.substring(21).trim()).orElse(null);
                            if (name != null && description != null) {
                                SkinChoiceField.this.choiceBox.getItems().add((Object)new Skin(name, description, skinFile));
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                        if (e == null) {
                            return FileVisitResult.CONTINUE;
                        }
                        throw e;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.choiceBox.sceneProperty().addListener((o, oV, newValue) -> {
            if (newValue == null) {
                return;
            }
            String skinName = Configuration.Manager.getSkin();
            if (Strings.isValid(skinName)) {
                this.choiceBox.getSelectionModel().select((Object)this.choiceBox.getItems().stream().filter(skin -> skinName.equals(skin.getName())).findAny().orElse(DEFAULT_SKIN));
            } else {
                this.choiceBox.getSelectionModel().selectFirst();
            }
            this.onAction();
            this.choiceBox.setOnAction(event -> {
                Skin skin = this.onAction();
                if (skin != null) {
                    this.updateSkin(skin.getName());
                }
                event.consume();
            });
        });
    }

    private Skin onAction() {
        Skin skin = (Skin)this.choiceBox.getSelectionModel().getSelectedItem();
        if (skin != null) {
            if (Strings.isValid(skin.getCss())) {
                this.choiceBox.getScene().getStylesheets().setAll((Object[])new String[]{skin.getCss()});
            } else {
                this.choiceBox.getScene().getStylesheets().clear();
            }
        }
        return skin;
    }
}

