/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.model3d;

import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;

public class KeepCase
extends Group {
    public KeepCase(float caseHeight, float caseWidth, float caseDepth, Color caseColour, float frontCoverLength, float frontCoverWidth, float spineWidth, Image coverTexture) {
        Group keepCase = this.buildCase(caseHeight, caseWidth, caseDepth, caseColour, frontCoverLength, frontCoverWidth);
        MeshView wraparoundCover = this.buildCover(frontCoverLength, frontCoverWidth, spineWidth, coverTexture);
        float gap = (spineWidth - caseDepth) / 2.0f;
        float coverTranslateX = (frontCoverWidth - caseWidth) / 2.0f - gap / 2.0f;
        wraparoundCover.setTranslateX((double)coverTranslateX);
        this.getChildren().addAll((Object[])new Node[]{wraparoundCover, keepCase});
        this.setTranslateX(gap / 2.0f);
    }

    private Group buildCaseElement(float height, float width, float depth, PhongMaterial material) {
        Box b1 = new Box((double)(width - 2.0f), (double)height, (double)depth);
        b1.setTranslateX(-1.0);
        Box b2 = new Box(2.0, (double)(height - 4.0f), (double)depth);
        b2.setTranslateX((double)(width / 2.0f - 1.0f));
        Cylinder c1 = new Cylinder(2.0, (double)depth);
        c1.getTransforms().addAll((Object[])new Transform[]{new Translate((double)(width / 2.0f - 2.0f), (double)(height / 2.0f - 2.0f), 0.0), new Rotate(90.0, Rotate.X_AXIS)});
        Cylinder c2 = new Cylinder(2.0, (double)depth);
        c2.getTransforms().addAll((Object[])new Transform[]{new Translate((double)(width / 2.0f - 2.0f), (double)((height / 2.0f - 2.0f) * -1.0f), 0.0), new Rotate(90.0, Rotate.X_AXIS)});
        b1.setMaterial((Material)material);
        b2.setMaterial((Material)material);
        c1.setMaterial((Material)material);
        c2.setMaterial((Material)material);
        Group element = new Group();
        element.getChildren().addAll((Object[])new Node[]{b1, b2, c1, c2});
        return element;
    }

    private Group buildCase(float caseHeight, float caseWidth, float caseDepth, Color caseColour, float frontCoverLength, float frontCoverWidth) {
        PhongMaterial material = new PhongMaterial(caseColour.brighter().brighter());
        material.setSpecularColor(caseColour.brighter().brighter());
        float elementDepth = 1.0f;
        Group ex1 = this.buildCaseElement(caseHeight, caseWidth, elementDepth, material);
        ex1.setTranslateZ((double)((caseDepth - elementDepth) / 2.0f));
        Group ex2 = this.buildCaseElement(caseHeight, caseWidth, elementDepth, material);
        ex2.setTranslateZ((double)((caseDepth - elementDepth) / -2.0f));
        Box ex3 = new Box((double)elementDepth, (double)caseHeight, (double)caseDepth);
        ex3.setMaterial((Material)material);
        ex3.setTranslateX((double)((caseWidth - elementDepth) / -2.0f));
        Group in1 = this.buildCaseElement(frontCoverLength, frontCoverWidth, (caseDepth - elementDepth) / 2.0f, material);
        in1.setTranslateZ((double)(caseDepth / 4.0f));
        Group in2 = this.buildCaseElement(frontCoverLength, frontCoverWidth, (caseDepth - elementDepth) / 2.0f, material);
        in2.setTranslateZ((double)(caseDepth / -4.0f));
        PhongMaterial coreMaterial = new PhongMaterial(caseColour);
        coreMaterial.setSpecularColor(caseColour);
        Group core = this.buildCaseElement(frontCoverLength - elementDepth * 2.0f, frontCoverWidth - elementDepth * 2.0f, elementDepth * 2.0f, coreMaterial);
        Group g = new Group();
        g.getChildren().addAll((Object[])new Node[]{ex1, ex2, ex3, in1, in2, core});
        return g;
    }

    private MeshView buildCover(float frontCoverLength, float frontCoverWidth, float spineWidth, Image coverTexture) {
        float hw = frontCoverWidth / 2.0f;
        float hh = frontCoverLength / 2.0f;
        float hd = spineWidth / 2.0f;
        float t = 1.0f;
        float[] points = new float[]{-hw, -hh, -hd, hw, -hh, -hd, hw, hh, -hd, -hw, hh, -hd, -hw + t, -hh, -hd + t, hw, -hh, -hd + t, hw, hh, -hd + t, -hw + t, hh, -hd + t, -hw + t, -hh, hd - t, hw, -hh, hd - t, hw, hh, hd - t, -hw + t, hh, hd - t, -hw, -hh, hd, hw, -hh, hd, hw, hh, hd, -hw, hh, hd};
        float coverTotalLength = frontCoverWidth * 2.0f + spineWidth;
        float x1 = frontCoverWidth / coverTotalLength;
        float x2 = 1.0f - x1;
        float[] texCoords = new float[]{0.0f, 0.0f, x1, 0.0f, x2, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, x2, 1.0f, x1, 1.0f, 0.0f, 1.0f};
        int[] faces = new int[]{0, 2, 2, 4, 1, 3, 2, 4, 0, 2, 3, 5, 1, 0, 6, 0, 5, 0, 6, 0, 1, 0, 2, 0, 5, 0, 7, 0, 4, 0, 7, 0, 5, 0, 6, 0, 4, 0, 11, 0, 8, 0, 11, 0, 4, 0, 7, 0, 8, 0, 10, 0, 9, 0, 10, 0, 8, 0, 11, 0, 9, 0, 14, 0, 13, 0, 14, 0, 9, 0, 10, 0, 13, 0, 15, 6, 12, 1, 15, 6, 13, 0, 14, 7, 12, 1, 3, 5, 0, 2, 3, 5, 12, 1, 15, 6, 3, 0, 6, 0, 2, 0, 6, 0, 3, 0, 7, 0, 3, 0, 11, 0, 7, 0, 11, 0, 3, 0, 15, 0, 11, 0, 14, 0, 10, 0, 14, 0, 11, 0, 15, 0, 4, 0, 1, 0, 5, 0, 1, 0, 4, 0, 0, 0, 12, 0, 4, 0, 8, 0, 4, 0, 12, 0, 0, 0, 12, 0, 9, 0, 13, 0, 9, 0, 12, 0, 8, 0};
        int[] faceSmoothingGroups = new int[28];
        TriangleMesh coverMesh = new TriangleMesh();
        coverMesh.getPoints().setAll(points);
        coverMesh.getTexCoords().setAll(texCoords);
        coverMesh.getFaces().setAll(faces);
        coverMesh.getFaceSmoothingGroups().setAll(faceSmoothingGroups);
        MeshView coverMeshView = new MeshView((Mesh)coverMesh);
        PhongMaterial material = new PhongMaterial();
        material.setDiffuseMap(coverTexture);
        coverMeshView.setMaterial((Material)material);
        return coverMeshView;
    }
}

