/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.model3d;

import javafx.scene.image.Image;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;

public abstract class PressboardBox
extends MeshView {
    protected PressboardBox(float boxHeight, float boxWidth, float boxDepth, float[] texCoords, int[] faces, Image boxTexture) {
        this(PressboardBox.buildPoints(boxHeight, boxWidth, boxDepth), texCoords, faces, boxTexture);
    }

    protected PressboardBox(float[] points, float[] texCoords, int[] faces, Image boxTexture) {
        int[] faceSmoothingGroups = new int[points.length / 2];
        TriangleMesh caseMesh = new TriangleMesh();
        caseMesh.getPoints().setAll(points);
        caseMesh.getTexCoords().setAll(texCoords);
        caseMesh.getFaces().setAll(faces);
        caseMesh.getFaceSmoothingGroups().setAll(faceSmoothingGroups);
        this.setMesh((Mesh)caseMesh);
        PhongMaterial material = new PhongMaterial();
        material.setDiffuseMap(boxTexture);
        this.setMaterial((Material)material);
    }

    private static float[] buildPoints(float boxHeight, float boxWidth, float boxDepth) {
        float hw = boxWidth / 2.0f;
        float hh = boxHeight / 2.0f;
        float hd = boxDepth / 2.0f;
        return new float[]{-hw, -hh, -hd, hw, -hh, -hd, hw, hh, -hd, -hw, hh, -hd, -hw, -hh, hd, hw, -hh, hd, hw, hh, hd, -hw, hh, hd};
    }
}

