/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.model3d;

import javafx.scene.image.Image;
import javafx.scene.transform.Rotate;
import net.babelsoft.negatron.view.control.model3d.PressboardBox;

public class StraightTuckEndBox
extends PressboardBox {
    public StraightTuckEndBox(float boxHeight, float boxWidth, float boxDepth, float glueFlapWidth, float tuckFlapWidth, boolean lieDown, Image boxTexture) {
        super(boxHeight, boxWidth, boxDepth, StraightTuckEndBox.buildTexCoords(boxHeight, boxWidth, boxDepth, glueFlapWidth, tuckFlapWidth), StraightTuckEndBox.buildFaces(), boxTexture);
        if (lieDown) {
            this.getTransforms().add((Object)new Rotate(-90.0, Rotate.Z_AXIS));
        }
    }

    private static float[] buildTexCoords(float boxHeight, float boxWidth, float boxDepth, float glueFlapWidth, float tuckFlapWidth) {
        float foldingCartonWidth = boxHeight + boxDepth * 2.0f + tuckFlapWidth * 2.0f;
        float foldingCartonLength = boxWidth * 2.0f + boxDepth * 2.0f + glueFlapWidth;
        float y1 = tuckFlapWidth / foldingCartonWidth;
        float y2 = (tuckFlapWidth + boxDepth) / foldingCartonWidth;
        float y3 = 1.0f - y2;
        float y4 = 1.0f - y1;
        float x1 = boxDepth / foldingCartonLength;
        float x2 = (boxDepth + boxWidth) / foldingCartonLength;
        float x3 = (boxDepth * 2.0f + boxWidth) / foldingCartonLength;
        float x4 = 1.0f - glueFlapWidth / foldingCartonLength;
        return new float[]{0.0f, y2, x1, y2, x1, y1, x2, y1, x2, y2, x3, y2, x4, y2, x4, y3, x3, y3, x2, y3, x2, y4, x1, y4, x1, y3, 0.0f, y3};
    }

    private static int[] buildFaces() {
        return new int[]{0, 5, 2, 7, 1, 6, 2, 7, 0, 5, 3, 8, 1, 0, 6, 12, 5, 1, 6, 12, 1, 0, 2, 13, 5, 1, 7, 9, 4, 4, 7, 9, 5, 1, 6, 12, 4, 4, 3, 8, 0, 5, 3, 8, 4, 4, 7, 9, 3, 10, 6, 12, 2, 11, 6, 12, 3, 10, 7, 9, 4, 4, 1, 2, 5, 1, 1, 2, 4, 4, 0, 3};
    }
}

