/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.tree;

import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;

class CellUtils {
    CellUtils() {
    }

    static void requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(Control c) {
        Node focusOwner;
        Scene scene = c.getScene();
        Node node = focusOwner = scene == null ? null : scene.getFocusOwner();
        if (focusOwner == null) {
            c.requestFocus();
        } else if (!c.equals(focusOwner)) {
            for (Parent p = focusOwner.getParent(); p != null; p = p.getParent()) {
                if (!c.equals(p)) continue;
                c.requestFocus();
                break;
            }
        }
    }

    static <T> String getItemText(Cell<T> cell) {
        return cell.getItem() == null ? "" : cell.getItem().toString();
    }

    private static <T> String getItemText(Cell<T> cell, StringConverter<T> converter) {
        return converter == null ? (cell.getItem() == null ? "" : cell.getItem().toString()) : converter.toString(cell.getItem());
    }

    static <T> void updateItem(Cell<T> cell, Node graphic) {
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setGraphic(null);
        } else if (cell.isEditing()) {
            cell.setText(null);
            cell.setGraphic(graphic);
        } else {
            cell.setText(CellUtils.getItemText(cell));
            cell.setGraphic(graphic);
        }
    }

    static <T> void startEdit(Cell<T> cell, Node graphic) {
        cell.setText(null);
        cell.setGraphic(graphic);
    }

    static <T> void cancelEdit(Cell<T> cell, Node graphic) {
        cell.setText(CellUtils.getItemText(cell));
        cell.setGraphic(graphic);
    }

    static <T> void updateItem(Cell<T> cell, StringConverter<T> converter, TextField textField) {
        CellUtils.updateItem(cell, converter, null, null, textField);
    }

    static <T> void updateItem(Cell<T> cell, StringConverter<T> converter, HBox hbox, Node graphic, TextField textField) {
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setGraphic(null);
        } else if (cell.isEditing()) {
            if (textField != null) {
                textField.setText(CellUtils.getItemText(cell, converter));
            }
            cell.setText(null);
            if (graphic != null) {
                hbox.getChildren().setAll((Object[])new Node[]{graphic, textField});
                cell.setGraphic((Node)hbox);
            } else {
                cell.setGraphic((Node)textField);
            }
        } else {
            cell.setText(CellUtils.getItemText(cell, converter));
            cell.setGraphic(graphic);
        }
    }

    static <T> void startEdit(Cell<T> cell, StringConverter<T> converter, HBox hbox, Node graphic, TextField textField) {
        if (textField != null) {
            textField.setText(CellUtils.getItemText(cell, converter));
        }
        cell.setText(null);
        if (graphic != null) {
            hbox.getChildren().setAll((Object[])new Node[]{graphic, textField});
            cell.setGraphic((Node)hbox);
        } else {
            cell.setGraphic((Node)textField);
        }
        textField.selectAll();
        Platform.runLater(() -> textField.requestFocus());
    }

    static <T> void cancelEdit(Cell<T> cell, StringConverter<T> converter, Node graphic) {
        cell.setText(CellUtils.getItemText(cell, converter));
        cell.setGraphic(graphic);
    }

    static <T> TextField createTextField(Cell<T> cell, StringConverter<T> converter) {
        TextField textField = new TextField(CellUtils.getItemText(cell, converter));
        textField.setOnAction(event -> {
            if (converter == null) {
                throw new IllegalStateException("Attempting to convert text input into Object, but provided StringConverter is null. Be sure to set a StringConverter in your cell factory.");
            }
            cell.commitEdit(converter.fromString(textField.getText()));
            event.consume();
        });
        textField.setOnKeyReleased(t -> {
            if (t.getCode() == KeyCode.ESCAPE) {
                cell.cancelEdit();
                t.consume();
            }
        });
        return textField;
    }
}

