/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.tree;

import java.util.function.Function;
import javafx.beans.value.ChangeListener;
import javafx.css.PseudoClass;
import net.babelsoft.negatron.controller.FavouriteTreePaneController;
import net.babelsoft.negatron.model.Describable;
import net.babelsoft.negatron.model.favourites.Favourite;
import net.babelsoft.negatron.view.control.tree.InteractiveTreeTableCell;

public abstract class DescribableTreeTableCell<T extends Describable>
extends InteractiveTreeTableCell<T> {
    private static final PseudoClass CSS_INVALID = PseudoClass.getPseudoClass((String)"invalid");

    public DescribableTreeTableCell(FavouriteTreePaneController controller, Function<Favourite, Boolean> isCellInvalid) {
        super(controller);
        ChangeListener invalidatedListener = (o, oV, invalidated) -> {
            if (invalidated.booleanValue() && ((Boolean)isCellInvalid.apply((Favourite)this.getTreeTableRow().getItem())).booleanValue()) {
                this.pseudoClassStateChanged(CSS_INVALID, true);
            } else {
                this.pseudoClassStateChanged(CSS_INVALID, false);
            }
        };
        ChangeListener favouriteListener = (o, oldFav, newFav) -> {
            if (newFav != null && newFav.invalidatedProperty() != null) {
                newFav.invalidatedProperty().addListener(invalidatedListener);
                invalidatedListener.changed(null, (Object)Boolean.FALSE, (Object)newFav.isInvalidated());
            }
            if (oldFav != null && oldFav.invalidatedProperty() != null) {
                oldFav.invalidatedProperty().removeListener(invalidatedListener);
            }
        };
        this.tableRowProperty().addListener((o, oldRow, newRow) -> {
            if (newRow != null) {
                newRow.itemProperty().addListener(favouriteListener);
                favouriteListener.changed(null, null, newRow.getItem());
            }
            if (oldRow != null) {
                oldRow.itemProperty().removeListener(favouriteListener);
            }
        });
    }

    @Override
    protected String initEdit() {
        super.initEdit();
        return this.toString();
    }

    @Override
    public void cancelEdit() {
        super.cancelEdit();
        this.setText(this.toString());
        this.setGraphic(null);
    }

    public String toString() {
        Describable item = (Describable)this.getItem();
        if (item != null) {
            return item.getDescription();
        }
        return null;
    }
}

