/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.tree;

import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TreeTableView;
import net.babelsoft.negatron.controller.FavouriteTreePaneController;
import net.babelsoft.negatron.model.favourites.Favourite;
import net.babelsoft.negatron.model.favourites.Separator;
import net.babelsoft.negatron.view.control.tree.CellUtils;
import net.babelsoft.negatron.view.control.tree.NegatronTreeTableCell;

public class FavouriteTreeTableCell<I>
extends NegatronTreeTableCell<Favourite, I> {
    public static final PseudoClass EDITABLE_CLASS = PseudoClass.getPseudoClass((String)"editable");
    protected FavouriteTreePaneController controller;

    public FavouriteTreeTableCell(FavouriteTreePaneController controller) {
        this.setAlignment(Pos.CENTER_LEFT);
        this.controller = controller;
        this.setOnMouseEntered(e -> controller.setHoveredCell(this));
        this.setOnMouseMoved(e -> {
            if (!e.isAltDown() && this.getTreeTableRow().isSelected() && !this.isEditing() && this.canEdit()) {
                this.pseudoClassStateChanged(EDITABLE_CLASS, true);
            } else {
                this.pseudoClassStateChanged(EDITABLE_CLASS, false);
            }
        });
    }

    private boolean isSeparator() {
        return this.getTreeTableRow().getItem() instanceof Separator;
    }

    protected Node getSeparator() {
        javafx.scene.control.Separator separator = null;
        if (this.isSeparator()) {
            separator = new javafx.scene.control.Separator();
            separator.setMouseTransparent(true);
        }
        return separator;
    }

    public boolean canEdit() {
        return this.getItem() != null;
    }

    public void startEdit() {
        if (this.canEdit()) {
            super.startEdit();
            this.controller.setEditingCell(this);
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.controller.setEditingCell(null);
    }

    public void commitEdit(I newValue) {
        TreeTableView table = this.getTreeTableView();
        if (table != null) {
            CellUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild((Control)table);
        }
        super.commitEdit(newValue);
        this.controller.setEditingCell(null);
        this.controller.saveConfiguration();
        Favourite favourite = (Favourite)this.getTreeTableRow().getItem();
        if (favourite.isInvalidated()) {
            favourite.checkValidity();
        }
    }
}

