/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.tree;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.util.StringConverter;
import net.babelsoft.negatron.controller.FavouriteTreePaneController;
import net.babelsoft.negatron.model.IconDescription;
import net.babelsoft.negatron.view.control.adapter.IconDescriptionStringConverter;
import net.babelsoft.negatron.view.control.tree.CellUtils;
import net.babelsoft.negatron.view.control.tree.FavouriteTreeTableCell;

public class IconNameTreeTableCell
extends FavouriteTreeTableCell<IconDescription> {
    private TextField textField;
    private ImageView imageView;
    private final ObjectProperty<StringConverter<IconDescription>> converter = new SimpleObjectProperty((Object)this, "converter");

    public IconNameTreeTableCell(FavouriteTreePaneController controller) {
        this(controller, new IconDescriptionStringConverter());
    }

    public IconNameTreeTableCell(FavouriteTreePaneController controller, StringConverter<IconDescription> converter) {
        super(controller);
        this.getStyleClass().add((Object)"text-field-tree-table-cell");
        this.setConverter(converter);
        this.itemProperty().addListener((o, oV, newItem) -> {
            this.imageView = newItem != null ? new ImageView(newItem.getIcon()) : null;
        });
    }

    public final ObjectProperty<StringConverter<IconDescription>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<IconDescription> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<IconDescription> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    @Override
    public void startEdit() {
        super.startEdit();
        if (this.isEditing()) {
            if (this.textField == null) {
                this.textField = CellUtils.createTextField(this, this.getConverter());
            }
            CellUtils.startEdit(this, this.getConverter(), null, null, this.textField);
        }
    }

    @Override
    public void cancelEdit() {
        super.cancelEdit();
        CellUtils.cancelEdit(this, this.getConverter(), (Node)this.imageView);
    }

    protected void updateItem(IconDescription item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            CellUtils.updateItem(this, this.getConverter(), null, this.getSeparator(), this.textField);
        } else {
            CellUtils.updateItem(this, this.getConverter(), null, (Node)(!this.isEditing() ? this.imageView : null), this.textField);
        }
    }
}

