/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.tree;

import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.VBox;
import net.babelsoft.negatron.controller.FavouriteTreePaneController;
import net.babelsoft.negatron.model.favourites.Favourite;
import net.babelsoft.negatron.model.favourites.MachineConfiguration;
import net.babelsoft.negatron.model.favourites.SoftwareConfiguration;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.view.control.tree.CellUtils;
import net.babelsoft.negatron.view.control.tree.FavouriteTreeTableCell;

public abstract class InteractiveTreeTableCell<I>
extends FavouriteTreeTableCell<I> {
    private static final String OK = ButtonType.OK.getText();
    public static final PseudoClass ERROR_CLASS = PseudoClass.getPseudoClass((String)"error");
    protected I editField;
    protected VBox editPane;
    protected Label label;
    protected Button button;

    public InteractiveTreeTableCell(FavouriteTreePaneController controller) {
        super(controller);
    }

    protected void createButton() {
        this.button = new Button(OK);
        this.button.setOnAction(event -> this.commitRowEdit());
    }

    protected boolean createEditPane() {
        if (this.editPane == null) {
            this.label = new Label();
            this.createButton();
            this.editPane = new VBox(new Node[]{this.label, this.button});
            this.editPane.setAlignment(Pos.CENTER);
            this.editPane.setOnKeyReleased(t -> {
                if (t.getCode() == KeyCode.ESCAPE) {
                    this.cancelEdit();
                    t.consume();
                }
            });
            return true;
        }
        return false;
    }

    protected abstract void showInteractivePane();

    protected abstract void hideInteractivePane();

    protected String initEdit() {
        this.editField = this.getItem();
        return null;
    }

    private void initRowEdit() {
        this.getTreeTableRow().getChildrenUnmodifiable().stream().filter(cell -> cell != this && cell instanceof InteractiveTreeTableCell).map(cell -> (InteractiveTreeTableCell)((Object)cell)).forEach(cell -> cell.initEdit());
        this.controller.show((TreeItem<Favourite>)this.getTreeTableRow().getTreeItem());
    }

    public abstract void setEdit(Machine var1, SoftwareConfiguration var2, MachineConfiguration var3);

    @Override
    public void startEdit() {
        super.startEdit();
        if (this.isEditing()) {
            this.createEditPane();
            this.label.setText(this.initEdit());
            this.initRowEdit();
            CellUtils.startEdit(this, (Node)this.editPane);
            this.showInteractivePane();
        }
    }

    @Override
    public void cancelEdit() {
        if (this.isEditing()) {
            super.cancelEdit();
            this.hideInteractivePane();
            this.cancelRowEdit();
            this.controller.show((TreeItem<Favourite>)this.getTreeTableRow().getTreeItem());
        } else {
            super.cancelEdit();
        }
    }

    private void cancelRowEdit() {
        this.getTreeTableRow().getChildrenUnmodifiable().stream().filter(cell -> cell != this && cell instanceof InteractiveTreeTableCell).map(cell -> (InteractiveTreeTableCell)((Object)cell)).forEach(cell -> cell.cancelEdit());
    }

    public void commitEdit() {
        if (this.isEditing()) {
            this.commitEdit(this.editField);
        } else {
            this.updateItem((Favourite)this.getTreeTableRow().getItem());
        }
        this.editField = null;
    }

    @Override
    public void commitEdit(I newValue) {
        this.controller.setCommitting(true);
        this.hideInteractivePane();
        super.commitEdit(newValue);
        this.controller.setCommitting(false);
    }

    private void commitRowEdit() {
        Favourite fav = (Favourite)this.getTreeTableRow().getItem();
        if (fav.mustMigrate()) {
            fav.setMustMigrate(false);
            this.getTreeTableRow().requestLayout();
        }
        this.getTreeTableRow().getChildrenUnmodifiable().stream().filter(cell -> cell != this && cell instanceof InteractiveTreeTableCell).map(cell -> (InteractiveTreeTableCell)((Object)cell)).forEach(cell -> {
            cell.pseudoClassStateChanged(ERROR_CLASS, false);
            cell.commitEdit();
        });
        this.commitEdit();
        this.controller.fireOnCommitted();
    }

    protected void updateItem(I item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
            this.pseudoClassStateChanged(ERROR_CLASS, false);
        } else {
            Node separator = this.getSeparator();
            if (separator == null) {
                this.setText(this.toString());
                Favourite fav = (Favourite)this.getTreeTableRow().getItem();
                if (fav != null && fav.mustMigrate()) {
                    this.pseudoClassStateChanged(ERROR_CLASS, true);
                } else {
                    this.pseudoClassStateChanged(ERROR_CLASS, false);
                }
            } else {
                this.setText(null);
                this.pseudoClassStateChanged(ERROR_CLASS, false);
            }
            this.setGraphic(separator);
        }
    }

    protected abstract void updateItem(Favourite var1);
}

