/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.tree;

import java.util.Optional;
import javafx.scene.control.Button;
import net.babelsoft.negatron.controller.FavouriteTreePaneController;
import net.babelsoft.negatron.model.favourites.Favourite;
import net.babelsoft.negatron.model.favourites.MachineConfiguration;
import net.babelsoft.negatron.model.favourites.SoftwareConfiguration;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.view.control.AdvancedParametrisationDialog;
import net.babelsoft.negatron.view.control.tree.CellUtils;
import net.babelsoft.negatron.view.control.tree.InteractiveTreeTableCell;

public class MachineConfigurationTreeTableCell
extends InteractiveTreeTableCell<MachineConfiguration> {
    private boolean previousIsCommandLine;

    public MachineConfigurationTreeTableCell(FavouriteTreePaneController controller) {
        super(controller);
    }

    @Override
    protected void createButton() {
        if (((MachineConfiguration)this.getItem()).isCommandLine()) {
            this.button = new Button(Language.Manager.getString("advanced..."));
            this.button.setOnAction(event -> {
                AdvancedParametrisationDialog dialog = new AdvancedParametrisationDialog(this.getTreeTableView().getScene().getWindow(), CellUtils.getItemText(this));
                Optional res = dialog.showAndWait();
                if (res.isPresent()) {
                    this.commitEdit(new MachineConfiguration((String)res.get()));
                } else {
                    this.cancelEdit();
                }
                event.consume();
            });
        } else {
            super.createButton();
        }
    }

    @Override
    protected boolean createEditPane() {
        if (!super.createEditPane() && this.previousIsCommandLine != ((MachineConfiguration)this.getItem()).isCommandLine()) {
            this.editPane.getChildren().remove((Object)this.button);
            this.createButton();
            this.editPane.getChildren().add((Object)this.button);
        }
        this.previousIsCommandLine = ((MachineConfiguration)this.getItem()).isCommandLine();
        return true;
    }

    @Override
    protected void showInteractivePane() {
        this.controller.showConfigurationPane();
    }

    @Override
    protected void hideInteractivePane() {
        this.controller.hideConfigurationPane();
    }

    @Override
    protected String initEdit() {
        super.initEdit();
        return this.toString();
    }

    @Override
    public void setEdit(Machine machine, SoftwareConfiguration softwareConfiguration, MachineConfiguration machineConfiguration) {
        if (this.isEditing()) {
            this.label.setText(this.toString(machineConfiguration));
        } else {
            this.setText(this.toString(machineConfiguration));
        }
        this.editField = machineConfiguration;
    }

    @Override
    public boolean canEdit() {
        return super.canEdit() && ((MachineConfiguration)this.getItem()).isConfigurable();
    }

    @Override
    public void cancelEdit() {
        super.cancelEdit();
        this.setText(this.toString());
        this.setGraphic(null);
    }

    @Override
    protected void updateItem(Favourite item) {
        item.setMachineConfiguration((MachineConfiguration)this.editField);
    }

    public String toString(MachineConfiguration conf) {
        if (conf == null) {
            return null;
        }
        if (conf.isCommandLine()) {
            return conf.getCommandLine();
        }
        return conf.getParameters().toString();
    }

    public String toString() {
        return this.toString((MachineConfiguration)this.getItem());
    }
}

