/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.tree;

import net.babelsoft.negatron.controller.FavouriteTreePaneController;
import net.babelsoft.negatron.model.favourites.Favourite;
import net.babelsoft.negatron.model.favourites.MachineConfiguration;
import net.babelsoft.negatron.model.favourites.SoftwareConfiguration;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.view.control.tree.DescribableTreeTableCell;

public class MachineTreeTableCell
extends DescribableTreeTableCell<Machine> {
    public MachineTreeTableCell(FavouriteTreePaneController controller) {
        super(controller, favourite -> favourite.isMachineInvalid());
    }

    @Override
    protected void showInteractivePane() {
        this.controller.showMachineList();
    }

    @Override
    protected void hideInteractivePane() {
        this.controller.hideMachineList();
    }

    @Override
    public boolean canEdit() {
        return super.canEdit() || ((Favourite)this.getTreeTableRow().getItem()).isMachineEditable();
    }

    @Override
    public void setEdit(Machine machine, SoftwareConfiguration softwareConfiguration, MachineConfiguration machineConfiguration) {
        if (this.isEditing()) {
            this.label.setText(machine.getDescription());
        } else {
            this.setText(machine.getDescription());
        }
        this.editField = machine;
    }

    @Override
    protected void updateItem(Favourite item) {
        item.setMachine((Machine)this.editField);
    }
}

