/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.tree;

import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.TextArea;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.input.KeyCode;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;

public class TextAreaTreeTableCell<S, T>
extends TreeTableCell<S, T> {
    private TextArea textArea;
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty((Object)this, "converter");

    public static <S> Callback<TreeTableColumn<S, String>, TreeTableCell<S, String>> forTableColumn() {
        return TextAreaTreeTableCell.forTableColumn(new DefaultStringConverter());
    }

    public static <S, T> Callback<TreeTableColumn<S, T>, TreeTableCell<S, T>> forTableColumn(StringConverter<T> converter) {
        return list -> new TextAreaTreeTableCell(converter);
    }

    private static <T> String getItemText(Cell<T> cell, StringConverter<T> converter) {
        return converter == null ? (cell.getItem() == null ? "" : cell.getItem().toString()) : converter.toString(cell.getItem());
    }

    private static <T> TextArea createTextArea(Cell<T> cell, StringConverter<T> converter) {
        TextArea textArea = new TextArea(TextAreaTreeTableCell.getItemText(cell, converter));
        textArea.setOnKeyReleased(t -> {
            if (t.getCode() == KeyCode.ESCAPE) {
                cell.cancelEdit();
                t.consume();
            } else if (t.getCode() == KeyCode.ENTER && t.isShiftDown()) {
                t.consume();
                textArea.appendText("\n");
            } else if (t.getCode() == KeyCode.ENTER) {
                if (converter == null) {
                    throw new IllegalStateException("Attempting to convert text input into Object, but provided StringConverter is null. Be sure to set a StringConverter in your cell factory.");
                }
                cell.commitEdit(converter.fromString(textArea.getText()));
                t.consume();
            }
        });
        textArea.prefRowCountProperty().bind((ObservableValue)Bindings.size((ObservableList)textArea.getParagraphs()));
        return textArea;
    }

    private void startEdit(Cell<T> cell, StringConverter<T> converter) {
        this.textArea.setText(TextAreaTreeTableCell.getItemText(cell, converter));
        cell.setText(null);
        cell.setGraphic((Node)this.textArea);
        this.textArea.selectAll();
        this.textArea.requestFocus();
    }

    private static <T> void cancelEdit(Cell<T> cell, StringConverter<T> converter) {
        cell.setText(TextAreaTreeTableCell.getItemText(cell, converter));
        cell.setGraphic(null);
    }

    private void updateItem(Cell<T> cell, StringConverter<T> converter) {
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setGraphic(null);
        } else if (cell.isEditing()) {
            if (this.textArea != null) {
                this.textArea.setText(TextAreaTreeTableCell.getItemText(cell, converter));
            }
            cell.setText(null);
            cell.setGraphic((Node)this.textArea);
        } else {
            cell.setText(TextAreaTreeTableCell.getItemText(cell, converter));
            cell.setGraphic(null);
        }
    }

    public TextAreaTreeTableCell() {
        this(null);
    }

    public TextAreaTreeTableCell(StringConverter<T> converter) {
        this.getStyleClass().add((Object)"text-area-table-cell");
        this.setConverter(converter);
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public void startEdit() {
        if (!(this.isEditable() && this.getTreeTableView().isEditable() && this.getTableColumn().isEditable())) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            if (this.textArea == null) {
                this.textArea = TextAreaTreeTableCell.createTextArea(this, this.getConverter());
            }
            this.startEdit((Cell<T>)this, this.getConverter());
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        TextAreaTreeTableCell.cancelEdit(this, this.getConverter());
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        this.updateItem((Cell<T>)this, this.getConverter());
    }
}

