/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.skin;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import net.babelsoft.negatron.util.function.Delegate;
import net.babelsoft.negatron.view.control.HiddenSidePane;
import net.babelsoft.negatron.view.control.TitledWindowPane;

public class HiddenSidePaneSkin
extends SkinBase<HiddenSidePane> {
    private final StackPane stackPane;
    private final InvalidationListener displayModeListener;
    private Delegate onceOnAnimationEnded;
    private final DoubleProperty[] visibility = new SimpleDoubleProperty[Side.values().length];
    private Timeline timeline;

    public HiddenSidePaneSkin(HiddenSidePane pane) {
        super((Control)pane);
        this.displayModeListener = observable -> this.animate();
        this.stackPane = new StackPane();
        this.getChildren().add((Object)this.stackPane);
        this.updateStackPane();
        InvalidationListener rebuildListener = observable -> this.updateStackPane();
        pane.contentProperty().addListener(rebuildListener);
        pane.topProperty().addListener(rebuildListener);
        pane.rightProperty().addListener(rebuildListener);
        pane.bottomProperty().addListener(rebuildListener);
        pane.leftProperty().addListener(rebuildListener);
        for (Side side : Side.values()) {
            this.visibility[side.ordinal()] = new SimpleDoubleProperty(0.0);
            this.visibility[side.ordinal()].addListener(observable -> ((HiddenSidePane)this.getSkinnable()).requestLayout());
        }
        Rectangle clip = new Rectangle();
        clip.setX(0.0);
        clip.setY(0.0);
        clip.widthProperty().bind((ObservableValue)((HiddenSidePane)this.getSkinnable()).widthProperty());
        clip.heightProperty().bind((ObservableValue)((HiddenSidePane)this.getSkinnable()).heightProperty());
        ((HiddenSidePane)this.getSkinnable()).setClip((Node)clip);
    }

    private void animate() {
        if (this.timeline != null) {
            this.timeline.stop();
        }
        KeyValue[] keyValues = new KeyValue[Side.values().length];
        for (Side side : Side.values()) {
            TitledWindowPane window = null;
            switch (side) {
                case TOP: {
                    window = ((HiddenSidePane)this.getSkinnable()).getTop();
                    break;
                }
                case RIGHT: {
                    window = ((HiddenSidePane)this.getSkinnable()).getRight();
                    break;
                }
                case BOTTOM: {
                    window = ((HiddenSidePane)this.getSkinnable()).getBottom();
                    break;
                }
                case LEFT: {
                    window = ((HiddenSidePane)this.getSkinnable()).getLeft();
                }
            }
            double value = 0.0;
            if (window != null) {
                switch (window.getDisplayMode()) {
                    case INTERMEDIATE: {
                        value = 0.5;
                        break;
                    }
                    case MAXIMISED: {
                        value = 1.0;
                    }
                }
                if (window.getOnceOnAnimationEnded() != null) {
                    this.onceOnAnimationEnded = window.getOnceOnAnimationEnded();
                    window.setOnceOnAnimationEnded(null);
                }
            }
            keyValues[side.ordinal()] = new KeyValue((WritableValue)this.visibility[side.ordinal()], (Object)value);
        }
        Duration duration = ((HiddenSidePane)this.getSkinnable()).getAnimationDuration() != null ? ((HiddenSidePane)this.getSkinnable()).getAnimationDuration() : Duration.millis((double)200.0);
        KeyFrame keyFrame = new KeyFrame(duration, e -> {
            if (this.onceOnAnimationEnded != null) {
                this.onceOnAnimationEnded.fire();
                this.onceOnAnimationEnded = null;
            }
        }, keyValues);
        this.timeline = new Timeline(new KeyFrame[]{keyFrame});
        this.timeline.play();
    }

    private void updateStackPane() {
        this.stackPane.getChildren().clear();
        TitledWindowPane top = ((HiddenSidePane)this.getSkinnable()).getTop();
        TitledWindowPane right = ((HiddenSidePane)this.getSkinnable()).getRight();
        TitledWindowPane bottom = ((HiddenSidePane)this.getSkinnable()).getBottom();
        TitledWindowPane left = ((HiddenSidePane)this.getSkinnable()).getLeft();
        if (((HiddenSidePane)this.getSkinnable()).getContent() != null) {
            this.stackPane.getChildren().add((Object)((HiddenSidePane)this.getSkinnable()).getContent());
        }
        if (top != null) {
            this.stackPane.getChildren().add((Object)top);
            top.setManaged(false);
            top.displayModeProperty().removeListener(this.displayModeListener);
            top.displayModeProperty().addListener(this.displayModeListener);
        }
        if (right != null) {
            this.stackPane.getChildren().add((Object)right);
            right.setManaged(false);
            right.displayModeProperty().removeListener(this.displayModeListener);
            right.displayModeProperty().addListener(this.displayModeListener);
        }
        if (bottom != null) {
            this.stackPane.getChildren().add((Object)bottom);
            bottom.setManaged(false);
            bottom.displayModeProperty().removeListener(this.displayModeListener);
            bottom.displayModeProperty().addListener(this.displayModeListener);
        }
        if (left != null) {
            this.stackPane.getChildren().add((Object)left);
            left.setManaged(false);
            left.displayModeProperty().removeListener(this.displayModeListener);
            left.displayModeProperty().addListener(this.displayModeListener);
        }
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        TitledWindowPane top;
        TitledWindowPane right;
        TitledWindowPane left;
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        TitledWindowPane bottom = ((HiddenSidePane)this.getSkinnable()).getBottom();
        if (bottom != null) {
            TitledWindowPane.DisplayMode displayMode = bottom.getDisplayMode();
            TitledWindowPane.DisplayMode previousDisplayMode = bottom.getPreviousDisplayMode();
            double visibilityValue = this.visibility[Side.BOTTOM.ordinal()].get();
            double prefHeight = contentHeight;
            double offset = visibilityValue;
            if (displayMode == TitledWindowPane.DisplayMode.MAXIMISED || displayMode == TitledWindowPane.DisplayMode.INTERMEDIATE && previousDisplayMode == TitledWindowPane.DisplayMode.MAXIMISED && visibilityValue != 0.5 || displayMode == TitledWindowPane.DisplayMode.HIDDEN && (previousDisplayMode == TitledWindowPane.DisplayMode.INTERMEDIATE || previousDisplayMode == TitledWindowPane.DisplayMode.MAXIMISED) && visibilityValue != 0.0) {
                offset *= prefHeight;
            } else {
                prefHeight *= 0.5;
                offset *= contentHeight;
            }
            bottom.resizeRelocate(contentX, contentY + (contentHeight - offset), contentWidth, prefHeight);
            bottom.setVisible(visibilityValue > 0.0);
        }
        if ((left = ((HiddenSidePane)this.getSkinnable()).getLeft()) != null) {
            double prefWidth = contentWidth;
            double offset = prefWidth * this.visibility[Side.LEFT.ordinal()].get();
            left.resizeRelocate(contentX - (prefWidth - offset), contentY, prefWidth, contentHeight);
            left.setVisible(this.visibility[Side.LEFT.ordinal()].get() > 0.0);
        }
        if ((right = ((HiddenSidePane)this.getSkinnable()).getRight()) != null) {
            double prefWidth = contentWidth;
            double offset = prefWidth * this.visibility[Side.RIGHT.ordinal()].get();
            right.resizeRelocate(contentX + contentWidth - offset, contentY, prefWidth, contentHeight);
            right.setVisible(this.visibility[Side.RIGHT.ordinal()].get() > 0.0);
        }
        if ((top = ((HiddenSidePane)this.getSkinnable()).getTop()) != null) {
            TitledWindowPane.DisplayMode displayMode = top.getDisplayMode();
            TitledWindowPane.DisplayMode previousDisplayMode = top.getPreviousDisplayMode();
            double visibilityValue = this.visibility[Side.TOP.ordinal()].get();
            double prefHeight = contentHeight;
            double offset = visibilityValue * contentHeight;
            if (displayMode == TitledWindowPane.DisplayMode.MAXIMISED && previousDisplayMode == TitledWindowPane.DisplayMode.HIDDEN || displayMode == TitledWindowPane.DisplayMode.HIDDEN && previousDisplayMode == TitledWindowPane.DisplayMode.MAXIMISED) {
                top.resizeRelocate(contentX, contentY - (prefHeight - offset), contentWidth, prefHeight);
            } else if (displayMode == TitledWindowPane.DisplayMode.INTERMEDIATE && previousDisplayMode == TitledWindowPane.DisplayMode.HIDDEN || displayMode == TitledWindowPane.DisplayMode.HIDDEN && previousDisplayMode == TitledWindowPane.DisplayMode.INTERMEDIATE) {
                top.resizeRelocate(contentX, contentY - ((prefHeight *= 0.5) - offset), contentWidth, prefHeight);
            } else if (displayMode == TitledWindowPane.DisplayMode.MAXIMISED && previousDisplayMode == TitledWindowPane.DisplayMode.INTERMEDIATE || displayMode == TitledWindowPane.DisplayMode.INTERMEDIATE && previousDisplayMode == TitledWindowPane.DisplayMode.MAXIMISED) {
                top.resizeRelocate(contentX, contentY, contentWidth, prefHeight *= visibilityValue);
            }
            top.setVisible(visibilityValue > 0.0);
        }
    }
}

