/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import java.util.Locale;
import java.util.ResourceBundle;
import javafx.scene.Parent;
import org.jpedal.PdfDecoderFX;
import org.jpedal.examples.viewer.JavaFXCommands;
import org.jpedal.examples.viewer.OpenViewerFX;
import org.jpedal.examples.viewer.PdfViewerGui;
import org.jpedal.examples.viewer.gui.javafx.JavaFXSearchWindow;
import org.jpedal.examples.viewer.gui.javafx.JavaFXThumbnailPanel;
import org.jpedal.examples.viewer.objects.ClientExternalHandler;
import org.jpedal.objects.acroforms.actions.JavaFXDefaultActionHandler;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class PdfViewer
extends OpenViewerFX {
    public PdfViewer(Parent parentPane, String preferencesPath) {
        super(parentPane, preferencesPath);
    }

    @Override
    void init() {
        try {
            Messages.setBundle(ResourceBundle.getBundle("org.jpedal.international.messages"));
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " loading resource bundle.\nAlso check you have a file in org.jpedal.international.messages to support Locale=" + Locale.getDefault());
        }
        this.decode_pdf = new PdfDecoderFX();
        this.thumbnails = new JavaFXThumbnailPanel(this.decode_pdf);
        this.currentGUI = new PdfViewerGui(this.stage, this.decode_pdf, this.commonValues, this.thumbnails, this.properties);
        this.decode_pdf.addExternalHandler(new JavaFXDefaultActionHandler(this.currentGUI), 5);
        this.decode_pdf.addExternalHandler(new ClientExternalHandler(), 39);
        this.searchFrame = new JavaFXSearchWindow(this.currentGUI);
        this.currentCommands = new JavaFXCommands(this.commonValues, this.currentGUI, this.decode_pdf, this.thumbnails, this.properties, this.searchFrame, this.currentPrinter);
        DecoderOptions.showErrorMessages = true;
        String prefFile = System.getProperty("org.jpedal.Viewer.Prefs");
        if (prefFile != null) {
            this.properties.loadProperties(prefFile);
        } else {
            this.properties.loadProperties();
        }
    }
}

