/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

public final class MQDecoder {
    public static final int[] QE = new int[]{22017, 13313, 6145, 2753, 1313, 545, 22017, 21505, 18433, 14337, 12289, 9217, 7169, 5633, 22017, 21505, 20737, 18433, 14337, 13313, 12289, 10241, 9217, 8705, 7169, 6145, 5633, 5121, 4609, 4353, 2753, 2497, 2209, 1313, 1089, 673, 545, 321, 273, 133, 73, 37, 21, 9, 5, 1, 22017};
    public static final byte[] NMPS = new byte[]{1, 2, 3, 4, 5, 38, 7, 8, 9, 10, 11, 12, 13, 29, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 45, 46};
    public static final byte[] NLPS = new byte[]{1, 6, 9, 12, 29, 33, 6, 14, 14, 14, 17, 18, 20, 21, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 46};
    public static final byte[] SWITCHML = new byte[]{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int bpst;
    int bp;
    int c;
    int b;
    int ct;
    int a;
    int[] i;
    int[] mps;
    int d;
    byte[] data;

    public MQDecoder(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.bp = n;
        this.b = byArray[this.bp] & 0xFF;
        this.c = this.b << 16;
        this.byteIn();
        this.c <<= 7;
        this.ct -= 7;
        this.a = 32768;
    }

    public void byteIn() {
        int n = this.data[this.bp + 1] & 0xFF;
        if (this.b == 255) {
            if (n > 143) {
                this.c += 65280;
                this.ct = 8;
            } else {
                ++this.bp;
                this.b = n;
                this.c += this.b << 9;
                this.ct = 7;
            }
        } else {
            ++this.bp;
            this.b = n;
            this.c += this.b << 8;
            this.ct = 8;
        }
    }

    public int decode(int n) {
        int n2 = QE[this.i[n]];
        this.a -= n2;
        int n3 = this.c >>> 16;
        int n4 = this.c & 0xFFFF;
        if (n3 < n2) {
            this.d = this.lpsExchange(n);
            this.renormalize();
        } else {
            this.c = (n3 -= n2) << 16 | n4;
            if ((this.a & 0x8000) == 0) {
                this.d = this.mpsExchange(n);
                this.renormalize();
            } else {
                this.d = this.mps[n];
            }
        }
        return this.d;
    }

    public int mpsExchange(int n) {
        if (this.a < QE[this.i[n]]) {
            this.d = 1 - this.mps[n];
            if (SWITCHML[this.i[n]] == 1) {
                this.mps[n] = 1 - this.mps[n];
            }
            this.i[n] = NLPS[this.i[n]];
        } else {
            this.d = this.mps[n];
            this.i[n] = NMPS[this.i[n]];
        }
        return this.d;
    }

    public int lpsExchange(int n) {
        if (this.a < QE[this.i[n]]) {
            this.a = QE[this.i[n]];
            this.d = this.mps[n];
            this.i[n] = NMPS[this.i[n]];
        } else {
            this.a = QE[this.i[n]];
            this.d = 1 - this.mps[n];
            if (SWITCHML[this.i[n]] == 1) {
                this.mps[n] = 1 - this.mps[n];
            }
            this.i[n] = NLPS[this.i[n]];
        }
        return this.d;
    }

    public void renormalize() {
        do {
            if (this.ct == 0) {
                this.byteIn();
            }
            this.a <<= 1;
            this.c <<= 1;
            --this.ct;
        } while ((this.a & 0x8000) == 0);
    }
}

