/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.jpeg2000.TreeNode;

public class QuadTree {
    private final TreeNode[] nodeMap;
    private int value;
    private int currentLevel;

    public QuadTree(int n, int n2) {
        int n3 = Math.max(n, n2);
        int n4 = 1;
        int n5 = 0;
        while (n3 > n4) {
            n4 <<= 1;
            ++n5;
        }
        int n6 = n5 + 1;
        this.nodeMap = new TreeNode[n6];
        for (int i = 0; i < n6; ++i) {
            TreeNode treeNode = new TreeNode();
            treeNode.width = n;
            treeNode.height = n2;
            this.nodeMap[i] = treeNode;
            n = n % 2 == 0 ? n / 2 : (n + 1) / 2;
            n2 = n2 % 2 == 0 ? n2 / 2 : (n2 + 1) / 2;
        }
    }

    public void reset(int n, int n2) {
        TreeNode treeNode;
        int n3;
        int n4 = 0;
        int n5 = this.nodeMap.length;
        for (n3 = 0; n3 < n5; ++n3) {
            treeNode = this.nodeMap[n3];
            int n6 = n + n2 * treeNode.width;
            Integer n7 = treeNode.items.get(n6);
            if (n7 != null) {
                n4 = n7;
                break;
            }
            treeNode.index = n6;
            n >>= 1;
            n2 >>= 1;
        }
        treeNode = this.nodeMap[--n3];
        treeNode.items.put(treeNode.index, n4);
        this.currentLevel = n3;
        this.value = 0;
    }

    public void incrementValue() {
        TreeNode treeNode = this.nodeMap[this.currentLevel];
        treeNode.items.put(treeNode.index, treeNode.items.get(treeNode.index) + 1);
    }

    public boolean nextNode() {
        int n = this.currentLevel;
        TreeNode treeNode = this.nodeMap[n];
        int n2 = treeNode.items.get(treeNode.index);
        if (--n < 0) {
            this.value = n2;
            return false;
        }
        this.currentLevel = n;
        treeNode = this.nodeMap[n];
        treeNode.items.put(treeNode.index, n2);
        return true;
    }

    public int getValue() {
        return this.value;
    }
}

