/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.jpeg2000.CodeBlock;
import com.idrsolutions.image.jpeg2000.Info;
import com.idrsolutions.image.jpeg2000.Packet;
import com.idrsolutions.image.jpeg2000.Progression;
import com.idrsolutions.image.jpeg2000.SIZ;
import com.idrsolutions.image.jpeg2000.Tile;
import com.idrsolutions.image.jpeg2000.TileBand;
import com.idrsolutions.image.jpeg2000.TileComponent;
import com.idrsolutions.image.jpeg2000.TileResolution;

public class RLCP
implements Progression {
    private final int layersCount;
    private final int componentsCount;
    private final int maxNL;
    private final Tile tile;
    private int res = 0;
    private int layer = 0;
    private int c = 0;
    private int p = 0;

    public RLCP(Info info, Tile tile) {
        SIZ sIZ = info.siz;
        this.tile = tile;
        this.layersCount = tile.cod.nLayers;
        this.componentsCount = sIZ.nComp;
        this.maxNL = tile.cod.nDecompLevel;
    }

    @Override
    public Packet getNextPacket() {
        while (this.res <= this.maxNL) {
            while (this.layer < this.layersCount) {
                while (this.c < this.componentsCount) {
                    TileComponent tileComponent = this.tile.components.get(this.c);
                    if (this.res > this.tile.cod.nDecompLevel) continue;
                    TileResolution tileResolution = tileComponent.resolutions.get(this.res);
                    int n = tileResolution.precinctInfo.numPrecincts;
                    if (this.p < n) {
                        Packet packet = this.createPacket(tileResolution, this.p, this.layer);
                        ++this.p;
                        return packet;
                    }
                    this.p = 0;
                    ++this.c;
                }
                this.c = 0;
                ++this.layer;
            }
            this.layer = 0;
            ++this.res;
        }
        return null;
    }

    @Override
    public Packet createPacket(TileResolution tileResolution, int n, int n2) {
        Packet packet = new Packet();
        packet.layerNumber = n2;
        for (TileBand tileBand : tileResolution.tileBands) {
            for (CodeBlock codeBlock : tileBand.codeBlocks) {
                if (codeBlock.precinctNumber != n) continue;
                packet.codeBlocks.add(codeBlock);
            }
        }
        return packet;
    }
}

