/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.jpeg2000.EntropyDecoder;
import com.idrsolutions.image.jpeg2000.LUT;
import com.idrsolutions.image.jpeg2000.TileBand;

public class Tier1Decoder {
    public static final byte BYTEMB = 0;
    public static final byte SHORTMB = 1;
    public static final byte INTMB = 2;
    private static final byte UNIFORM = 17;
    private static final byte RUNLENGTH = 18;
    private final int width;
    private final int height;
    private EntropyDecoder decoder;
    private final byte[] contextLableTable;
    public byte[] neighborSigns;
    public byte[] coefficientsSign;
    public Object magnitude;
    public byte[] currentFlag;
    public byte[] bitsDecoded;
    public byte[] cx;
    public final int mbType;

    public Tier1Decoder(int n, int n2, TileBand tileBand, int n3, int n4) {
        this.width = n;
        this.height = n2;
        this.contextLableTable = tileBand.type == 3 ? LUT.ContextHH : (tileBand.type == 2 ? LUT.ContextHL : LUT.ContextLL);
        int n5 = n * n2;
        this.neighborSigns = new byte[n5];
        this.coefficientsSign = new byte[n5];
        int n6 = n4 > 14 ? 2 : (this.mbType = n4 > 6 ? 1 : 0);
        this.magnitude = n4 > 14 ? new int[n5] : (n4 > 6 ? (Object[])new short[n5] : (Object[])new byte[n5]);
        this.currentFlag = new byte[n5];
        this.bitsDecoded = new byte[n5];
        if (n3 != 0) {
            for (int i = 0; i < n5; ++i) {
                this.bitsDecoded[i] = (byte)n3;
            }
        }
        this.cx = new byte[19];
        this.cx[0] = 8;
        this.cx[17] = 92;
        this.cx[18] = 6;
    }

    public void setDecoder(EntropyDecoder entropyDecoder) {
        this.decoder = entropyDecoder;
    }

    public void setNeighborSigns(int n, int n2, int n3) {
        int n4;
        boolean bl;
        boolean bl2 = n2 > 0;
        boolean bl3 = bl = n2 + 1 < this.width;
        if (n > 0) {
            n4 = n3 - this.width;
            if (bl2) {
                this.neighborSigns[n4 - 1] = (byte)((this.neighborSigns[n4 - 1] & 0xFF) + 16);
            }
            if (bl) {
                this.neighborSigns[n4 + 1] = (byte)((this.neighborSigns[n4 + 1] & 0xFF) + 16);
            }
            this.neighborSigns[n4] = (byte)((this.neighborSigns[n4] & 0xFF) + 4);
        }
        if (n + 1 < this.height) {
            n4 = n3 + this.width;
            if (bl2) {
                this.neighborSigns[n4 - 1] = (byte)((this.neighborSigns[n4 - 1] & 0xFF) + 16);
            }
            if (bl) {
                this.neighborSigns[n4 + 1] = (byte)((this.neighborSigns[n4 + 1] & 0xFF) + 16);
            }
            this.neighborSigns[n4] = (byte)((this.neighborSigns[n4] & 0xFF) + 4);
        }
        if (bl2) {
            this.neighborSigns[n3 - 1] = (byte)((this.neighborSigns[n3 - 1] & 0xFF) + 1);
        }
        if (bl) {
            this.neighborSigns[n3 + 1] = (byte)((this.neighborSigns[n3 + 1] & 0xFF) + 1);
        }
        this.neighborSigns[n3] = (byte)(this.neighborSigns[n3] & 0xFF | 0x80);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void runSPP() {
        int n = -2;
        int n2 = 1;
        int n3 = 2;
        int n4 = 0;
        block10: while (n4 < this.height) {
            int n5 = 0;
            while (true) {
                int n6;
                int n7;
                if (n5 < this.width) {
                    n7 = n4 * this.width + n5;
                } else {
                    n4 += 4;
                    continue block10;
                }
                block12: for (int i = 0; i < 4 && (n6 = n4 + i) < this.height; ++i, n7 += this.width) {
                    this.currentFlag[n7] = (byte)(this.currentFlag[n7] & 0xFF & n);
                    switch (this.mbType) {
                        case 0: {
                            if (((byte[])this.magnitude)[n7] == 0 && this.neighborSigns[n7] != 0) break;
                            continue block12;
                        }
                        case 1: {
                            if (((short[])this.magnitude)[n7] == 0 && this.neighborSigns[n7] != 0) break;
                            continue block12;
                        }
                        case 2: {
                            if (((int[])this.magnitude)[n7] != 0 || this.neighborSigns[n7] == 0) continue block12;
                        }
                    }
                    byte by = this.contextLableTable[this.neighborSigns[n7] & 0xFF];
                    int n8 = this.decoder.decodeBit(this.cx, by);
                    if (n8 != 0) {
                        int n9 = this.decodeSignBit(n6, n5, n7);
                        this.coefficientsSign[n7] = (byte)n9;
                        switch (this.mbType) {
                            case 0: {
                                ((byte[])this.magnitude)[n7] = 1;
                                break;
                            }
                            case 1: {
                                ((short[])this.magnitude)[n7] = 1;
                                break;
                            }
                            case 2: {
                                ((int[])this.magnitude)[n7] = 1;
                                break;
                            }
                        }
                        this.setNeighborSigns(n6, n5, n7);
                        this.currentFlag[n7] = (byte)(this.currentFlag[n7] & 0xFF | n3);
                    }
                    int n10 = n7;
                    this.bitsDecoded[n10] = (byte)(this.bitsDecoded[n10] + 1);
                    this.currentFlag[n7] = (byte)(this.currentFlag[n7] & 0xFF | n2);
                }
                ++n5;
            }
            break;
        }
        return;
    }

    private long getCoMag(int n) {
        switch (this.mbType) {
            case 0: {
                return ((byte[])this.magnitude)[n] & 0xFF;
            }
            case 1: {
                return ((short[])this.magnitude)[n] & 0xFFFF;
            }
            case 2: {
                return ((int[])this.magnitude)[n];
            }
        }
        return 0L;
    }

    public int decodeSignBit(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        boolean bl;
        boolean bl2 = bl = n2 > 0 && this.getCoMag(n3 - 1) != 0L;
        if (n2 + 1 < this.width && this.getCoMag(n3 + 1) != 0L) {
            n7 = this.coefficientsSign[n3 + 1] & 0xFF;
            if (bl) {
                n6 = this.coefficientsSign[n3 - 1] & 0xFF;
                n5 = 1 - n7 - n6;
            } else {
                n5 = 1 - n7 - n7;
            }
        } else if (bl) {
            n6 = this.coefficientsSign[n3 - 1] & 0xFF;
            n5 = 1 - n6 - n6;
        } else {
            n5 = 0;
        }
        int n8 = 3 * n5;
        boolean bl3 = bl = n > 0 && this.getCoMag(n3 - this.width) != 0L;
        if (n + 1 < this.height && this.getCoMag(n3 + this.width) != 0L) {
            n7 = this.coefficientsSign[n3 + this.width] & 0xFF;
            if (bl) {
                n6 = this.coefficientsSign[n3 - this.width] & 0xFF;
                n5 = 1 - n7 - n6 + n8;
            } else {
                n5 = 1 - n7 - n7 + n8;
            }
        } else if (bl) {
            n6 = this.coefficientsSign[n3 - this.width] & 0xFF;
            n5 = 1 - n6 - n6 + n8;
        } else {
            n5 = n8;
        }
        if (n5 >= 0) {
            int n9 = 9 + n5;
            n4 = this.decoder.decodeBit(this.cx, n9);
        } else {
            int n10 = 9 - n5;
            n4 = this.decoder.decodeBit(this.cx, n10) ^ 1;
        }
        return n4;
    }

    public void runMRP() {
        int n = 1;
        int n2 = 2;
        int n3 = this.width * this.height;
        int n4 = this.width * 4;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = Math.min(n3, n5 + n4);
            for (int i = 0; i < this.width; ++i) {
                for (int j = n5 + i; j < n6; j += this.width) {
                    int n7;
                    long l = 0L;
                    switch (this.mbType) {
                        case 0: {
                            l = ((byte[])this.magnitude)[j] & 0xFF;
                            break;
                        }
                        case 1: {
                            l = ((short[])this.magnitude)[j] & 0xFFFF;
                            break;
                        }
                        case 2: {
                            l = ((int[])this.magnitude)[j];
                        }
                    }
                    if (l == 0L || (this.currentFlag[j] & 0xFF & n) != 0) continue;
                    int n8 = 16;
                    if ((this.currentFlag[j] & 0xFF & n2) != 0) {
                        this.currentFlag[j] = (byte)(this.currentFlag[j] & 0xFF ^ n2);
                        n7 = this.neighborSigns[j] & 0xFF & 0x7F;
                        n8 = n7 == 0 ? 15 : 14;
                    }
                    n7 = this.decoder.decodeBit(this.cx, n8);
                    switch (this.mbType) {
                        case 0: {
                            ((byte[])this.magnitude)[j] = (byte)(l << 1 | (long)n7);
                            break;
                        }
                        case 1: {
                            ((short[])this.magnitude)[j] = (short)(l << 1 | (long)n7);
                            break;
                        }
                        case 2: {
                            ((int[])this.magnitude)[j] = (int)(l << 1 | (long)n7);
                        }
                    }
                    int n9 = j;
                    this.bitsDecoded[n9] = (byte)(this.bitsDecoded[n9] + 1);
                    this.currentFlag[j] = (byte)(this.currentFlag[j] & 0xFF | n);
                }
            }
            n5 = n6;
        }
    }

    public void runCP() {
        int n = 1;
        int n2 = 2;
        int n3 = this.width;
        int n4 = this.width * 2;
        int n5 = this.width * 3;
        int n6 = 0;
        int n7 = 0;
        while (n7 < this.height) {
            n6 = Math.min(n7 + 4, this.height);
            int n8 = n7 * this.width;
            boolean bl = n7 + 3 < this.height;
            for (int i = 0; i < this.width; ++i) {
                int n9;
                int n10 = n8 + i;
                boolean bl2 = bl && this.currentFlag[n10] == 0 && this.currentFlag[n10 + n3] == 0 && this.currentFlag[n10 + n4] == 0 && this.currentFlag[n10 + n5] == 0 && this.neighborSigns[n10] == 0 && this.neighborSigns[n10 + n3] == 0 && this.neighborSigns[n10 + n4] == 0 && this.neighborSigns[n10 + n5] == 0;
                int n11 = 0;
                int n12 = n10;
                int n13 = n7;
                if (bl2) {
                    int n14 = this.decoder.decodeBit(this.cx, 18);
                    if (n14 == 0) {
                        int n15 = n10;
                        this.bitsDecoded[n15] = (byte)(this.bitsDecoded[n15] + 1);
                        int n16 = n10 + n3;
                        this.bitsDecoded[n16] = (byte)(this.bitsDecoded[n16] + 1);
                        int n17 = n10 + n4;
                        this.bitsDecoded[n17] = (byte)(this.bitsDecoded[n17] + 1);
                        int n18 = n10 + n5;
                        this.bitsDecoded[n18] = (byte)(this.bitsDecoded[n18] + 1);
                        continue;
                    }
                    n11 = this.decoder.decodeBit(this.cx, 17) << 1 | this.decoder.decodeBit(this.cx, 17);
                    if (n11 != 0) {
                        n13 = n7 + n11;
                        n12 += n11 * this.width;
                    }
                    n9 = this.decodeSignBit(n13, i, n12);
                    this.coefficientsSign[n12] = (byte)n9;
                    switch (this.mbType) {
                        case 0: {
                            ((byte[])this.magnitude)[n12] = 1;
                            break;
                        }
                        case 1: {
                            ((short[])this.magnitude)[n12] = 1;
                            break;
                        }
                        case 2: {
                            ((int[])this.magnitude)[n12] = 1;
                        }
                    }
                    this.setNeighborSigns(n13, i, n12);
                    this.currentFlag[n12] = (byte)(this.currentFlag[n12] & 0xFF | n2);
                    n12 = n10;
                    for (int j = n7; j <= n13; ++j) {
                        int n19 = n12;
                        this.bitsDecoded[n19] = (byte)(this.bitsDecoded[n19] + 1);
                        n12 += this.width;
                    }
                    ++n11;
                }
                n13 = n7 + n11;
                while (n13 < n6) {
                    long l = 0L;
                    switch (this.mbType) {
                        case 0: {
                            l = ((byte[])this.magnitude)[n12];
                            break;
                        }
                        case 1: {
                            l = ((short[])this.magnitude)[n12];
                            break;
                        }
                        case 2: {
                            l = ((int[])this.magnitude)[n12];
                        }
                    }
                    if (l == 0L && (this.currentFlag[n12] & 0xFF & n) == 0) {
                        byte by = this.contextLableTable[this.neighborSigns[n12] & 0xFF];
                        int n20 = this.decoder.decodeBit(this.cx, by);
                        if (n20 == 1) {
                            n9 = this.decodeSignBit(n13, i, n12);
                            this.coefficientsSign[n12] = (byte)n9;
                            switch (this.mbType) {
                                case 0: {
                                    ((byte[])this.magnitude)[n12] = 1;
                                    break;
                                }
                                case 1: {
                                    ((short[])this.magnitude)[n12] = 1;
                                    break;
                                }
                                case 2: {
                                    ((int[])this.magnitude)[n12] = 1;
                                }
                            }
                            this.setNeighborSigns(n13, i, n12);
                            this.currentFlag[n12] = (byte)(this.currentFlag[n12] & 0xFF | n2);
                        }
                        int n21 = n12;
                        this.bitsDecoded[n21] = (byte)(this.bitsDecoded[n21] + 1);
                    }
                    ++n13;
                    n12 += this.width;
                }
            }
            n7 = n6;
        }
    }
}

