/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.jpeg2000.BlockData;
import com.idrsolutions.image.jpeg2000.CodeBlock;
import com.idrsolutions.image.jpeg2000.IncQuadTree;
import com.idrsolutions.image.jpeg2000.Packet;
import com.idrsolutions.image.jpeg2000.PacketItem;
import com.idrsolutions.image.jpeg2000.Precinct;
import com.idrsolutions.image.jpeg2000.Progression;
import com.idrsolutions.image.jpeg2000.QuadTree;
import com.idrsolutions.image.jpeg2000.Tile;
import java.util.LinkedList;

public class TileParser {
    private final int offset;
    private final int dataLength;
    private final byte[] data;
    private final Tile tile;
    private int pos = 0;
    private boolean skipNextBit = false;
    private int bufferSize = 0;
    private int buffer = 0;

    public TileParser(byte[] byArray, Tile tile) {
        this.data = byArray;
        this.offset = 0;
        this.dataLength = byArray.length;
        this.tile = tile;
    }

    private int readBits(int n) {
        while (this.bufferSize < n) {
            int n2 = this.data[this.offset + this.pos] & 0xFF;
            ++this.pos;
            if (this.skipNextBit) {
                this.buffer = this.buffer << 7 | n2;
                this.bufferSize += 7;
                this.skipNextBit = false;
            } else {
                this.buffer = this.buffer << 8 | n2;
                this.bufferSize += 8;
            }
            if (n2 != 255) continue;
            this.skipNextBit = true;
        }
        this.bufferSize -= n;
        return this.buffer >>> this.bufferSize & (1 << n) - 1;
    }

    private boolean skipPacketMarker(int n) {
        if ((this.data[this.offset + this.pos - 1] & 0xFF) == 255 && (this.data[this.offset + this.pos] & 0xFF) == n) {
            ++this.pos;
            return true;
        }
        if ((this.data[this.offset + this.pos] & 0xFF) == 255 && (this.data[this.offset + this.pos + 1] & 0xFF) == n) {
            this.pos += 2;
            return true;
        }
        return false;
    }

    private void doPadding() {
        this.bufferSize = 0;
        if (this.skipNextBit) {
            ++this.pos;
            this.skipNextBit = false;
        }
    }

    private int readCodingpasses() {
        if (this.readBits(1) == 0) {
            return 1;
        }
        if (this.readBits(1) == 0) {
            return 2;
        }
        int n = this.readBits(2);
        if (n < 3) {
            return n + 3;
        }
        n = this.readBits(5);
        if (n < 31) {
            return n + 6;
        }
        n = this.readBits(7);
        return n + 37;
    }

    public void parseTile() {
        boolean bl = this.tile.cod.hasSOP;
        boolean bl2 = this.tile.cod.hasEPH;
        Progression progression = this.tile.progress;
        while (this.pos < this.dataLength) {
            Object object;
            this.doPadding();
            if (bl && this.skipPacketMarker(145)) {
                this.pos += 4;
            }
            Packet packet = progression.getNextPacket();
            if (this.readBits(1) == 0) continue;
            int n = packet.layerNumber;
            LinkedList<PacketItem> linkedList = new LinkedList<PacketItem>();
            for (CodeBlock codeBlock : packet.codeBlocks) {
                int n2;
                int n3;
                Object object2;
                boolean bl3;
                boolean bl4;
                int n4;
                int n5;
                block15: {
                    object = codeBlock.precinct;
                    n5 = codeBlock.x - ((Precinct)object).cbx0;
                    n4 = codeBlock.y - ((Precinct)object).cby0;
                    bl4 = false;
                    bl3 = false;
                    if (codeBlock.included != null) {
                        bl4 = this.readBits(1) != 0;
                    } else {
                        object = codeBlock.precinct;
                        if (((Precinct)object).incQuadTree != null) {
                            object2 = ((Precinct)object).incQuadTree;
                        } else {
                            n3 = ((Precinct)object).cbx1 - ((Precinct)object).cbx0 + 1;
                            n2 = ((Precinct)object).cby1 - ((Precinct)object).cby0 + 1;
                            object2 = new IncQuadTree(n3, n2, n);
                            QuadTree quadTree = new QuadTree(n3, n2);
                            ((Precinct)object).incQuadTree = object2;
                            ((Precinct)object).zeroBitTree = quadTree;
                        }
                        if (((IncQuadTree)object2).reset(n5, n4, n)) {
                            while (this.readBits(1) != 0) {
                                if (((IncQuadTree)object2).nextNode()) continue;
                                codeBlock.included = true;
                                bl4 = true;
                                bl3 = true;
                                break block15;
                            }
                            ((IncQuadTree)object2).incrementValue(n);
                        }
                    }
                }
                if (!bl4) continue;
                if (bl3) {
                    object2 = ((Precinct)object).zeroBitTree;
                    ((QuadTree)object2).reset(n5, n4);
                    while (true) {
                        if (this.readBits(1) != 0) {
                            if (((QuadTree)object2).nextNode()) continue;
                            break;
                        }
                        ((QuadTree)object2).incrementValue();
                    }
                    codeBlock.zeroBitPlanes = ((QuadTree)object2).getValue();
                }
                int n6 = this.readCodingpasses();
                while (this.readBits(1) != 0) {
                    ++codeBlock.Lblock;
                }
                int n7 = TileParser.log2(n6);
                n3 = (n6 < 1 << n7 ? n7 - 1 : n7) + codeBlock.Lblock;
                n2 = this.readBits(n3);
                PacketItem packetItem = new PacketItem();
                packetItem.codeBlock = codeBlock;
                packetItem.nCodingPass = (byte)n6;
                packetItem.dataLength = n2;
                linkedList.add(packetItem);
            }
            this.doPadding();
            if (bl2) {
                this.skipPacketMarker(146);
            }
            while (!linkedList.isEmpty()) {
                CodeBlock codeBlock;
                PacketItem packetItem = (PacketItem)linkedList.poll();
                codeBlock = packetItem.codeBlock;
                object = new BlockData();
                ((BlockData)object).data = this.data;
                ((BlockData)object).start = this.offset + this.pos;
                ((BlockData)object).end = this.offset + this.pos + packetItem.dataLength;
                ((BlockData)object).nCodingPass = packetItem.nCodingPass;
                codeBlock.dataList.add((BlockData)object);
                this.pos += packetItem.dataLength;
            }
        }
    }

    private static int log2(int n) {
        int n2 = 1;
        int n3 = 0;
        while (n > n2) {
            n2 <<= 1;
            ++n3;
        }
        return n3;
    }
}

