/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.blends;

import java.awt.CompositeContext;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class BlendContext
implements CompositeContext {
    private final int blendMode;

    public BlendContext(int n, float f) {
        this.blendMode = n;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
        int n = Math.min(raster.getWidth(), raster2.getWidth());
        int n2 = Math.min(raster.getHeight(), raster2.getHeight());
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        for (int i = 0; i < n2; ++i) {
            raster.getDataElements(0, i, n, 1, nArray);
            raster2.getDataElements(0, i, n, 1, nArray2);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int j = 0; j < n; ++j) {
                int n6 = nArray[j];
                int n7 = nArray2[j];
                if (n6 == n3 && n7 == n4) {
                    nArray3[j] = n5;
                    continue;
                }
                n3 = n6;
                n4 = n7;
                int[] nArray4 = BlendContext.getRGBA(n6);
                int[] nArray5 = BlendContext.getRGBA(n7);
                int[] nArray6 = new int[4];
                switch (this.blendMode) {
                    case 1111314299: {
                        break;
                    }
                    case 1451587725: {
                        nArray6 = BlendContext.doMultiply(nArray4, nArray5);
                        break;
                    }
                    case 1110792305: {
                        nArray6 = BlendContext.doScreen(nArray4, nArray5);
                        break;
                    }
                    case 1113290622: {
                        nArray6 = BlendContext.doOverlay(nArray4, nArray5);
                        break;
                    }
                    case 1111181679: {
                        nArray6 = BlendContext.doDarken(nArray4, nArray5);
                        break;
                    }
                    case 945843829: {
                        nArray6 = BlendContext.doLighten(nArray4, nArray5);
                        break;
                    }
                    case 2071170184: {
                        nArray6 = BlendContext.doColorDodge(nArray4, nArray5);
                        break;
                    }
                    case 1367441811: {
                        nArray6 = BlendContext.doColorBurn(nArray4, nArray5);
                        break;
                    }
                    case 1786342520: {
                        nArray6 = BlendContext.doHardLight(nArray4, nArray5);
                        break;
                    }
                    case 2020441219: {
                        nArray6 = BlendContext.doSoftLight(nArray4, nArray5);
                        break;
                    }
                    case 1802796208: {
                        nArray6 = BlendContext.doDifference(nArray4, nArray5);
                        break;
                    }
                    case -1955824744: {
                        nArray6 = BlendContext.doExclusion(nArray4, nArray5);
                        break;
                    }
                    case 1590581: {
                        nArray6 = BlendContext.doHue(nArray4, nArray5);
                        break;
                    }
                    case -2004966240: {
                        nArray6 = BlendContext.doSaturation(nArray4, nArray5);
                        break;
                    }
                    case 1060912981: {
                        nArray6 = BlendContext.doColor(nArray4, nArray5);
                        break;
                    }
                    case -2139971891: {
                        nArray6 = BlendContext.doLuminosity(nArray4, nArray5);
                        break;
                    }
                }
                if (nArray4[3] != 255) {
                    double d = (double)nArray6[0] / 255.0;
                    double d2 = (double)nArray6[1] / 255.0;
                    double d3 = (double)nArray6[2] / 255.0;
                    double d4 = (double)nArray4[3] / 255.0;
                    double d5 = (double)nArray5[0] / 255.0;
                    double d6 = (double)nArray5[1] / 255.0;
                    double d7 = (double)nArray5[2] / 255.0;
                    d = (1.0 - d4) * d5 + d4 * d;
                    d2 = (1.0 - d4) * d6 + d4 * d2;
                    d3 = (1.0 - d4) * d7 + d4 * d3;
                    nArray6[0] = (int)(d * 255.0);
                    nArray6[1] = (int)(d2 * 255.0);
                    nArray6[2] = (int)(d3 * 255.0);
                }
                nArray3[j] = n5 = Math.min(255, nArray4[3] + nArray5[3]) << 24 | nArray6[0] << 16 | nArray6[1] << 8 | nArray6[2];
            }
            writableRaster.setDataElements(0, i, n, 1, nArray3);
        }
    }

    private static int[] getRGBA(int n) {
        return new int[]{n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, n >> 24 & 0xFF};
    }

    private static int[] doMultiply(int[] nArray, int[] nArray2) {
        return new int[]{nArray[0] * nArray2[0] >> 8, nArray[1] * nArray2[1] >> 8, nArray[2] * nArray2[2] >> 8};
    }

    private static int[] doScreen(int[] nArray, int[] nArray2) {
        if (nArray2[0] == 255 && nArray2[1] == 255 && nArray2[2] == 255) {
            return new int[]{nArray[0], nArray[1], nArray[2]};
        }
        return new int[]{255 - ((255 - nArray[0]) * (255 - nArray2[0]) >> 8), 255 - ((255 - nArray[1]) * (255 - nArray2[1]) >> 8), 255 - ((255 - nArray[2]) * (255 - nArray2[2]) >> 8)};
    }

    private static int[] doOverlay(int[] nArray, int[] nArray2) {
        if (nArray2[0] == 255 && nArray2[1] == 255 && nArray2[2] == 255) {
            return new int[]{nArray[0], nArray[1], nArray[2]};
        }
        int[] nArray3 = new int[3];
        for (int i = 0; i < 3; ++i) {
            double d = (double)nArray2[i] / 255.0;
            double d2 = (double)nArray[i] / 255.0;
            if (d > 0.5) {
                d = 2.0 * d - 1.0;
                nArray3[i] = (int)(255.0 * (d + d2 - d * d2));
                continue;
            }
            d = 2.0 * d;
            nArray3[i] = (int)(255.0 * (d * d2));
        }
        return nArray3;
    }

    private static int[] doHardLight(int[] nArray, int[] nArray2) {
        if (nArray2[0] == 255 && nArray2[1] == 255 && nArray2[2] == 255) {
            return new int[]{nArray[0], nArray[1], nArray[2]};
        }
        int[] nArray3 = new int[3];
        for (int i = 0; i < 3; ++i) {
            double d = (double)nArray[i] / 255.0;
            double d2 = (double)nArray2[i] / 255.0;
            if (d <= 0.5) {
                d = 2.0 * d;
                nArray3[i] = (int)(255.0 * (d * d2));
                continue;
            }
            d = 2.0 * d - 1.0;
            nArray3[i] = (int)(255.0 * (d + d2 - d * d2));
        }
        return nArray3;
    }

    private static int[] doDarken(int[] nArray, int[] nArray2) {
        return new int[]{Math.min(nArray[0], nArray2[0]), Math.min(nArray[1], nArray2[1]), Math.min(nArray[2], nArray2[2])};
    }

    private static int[] doLighten(int[] nArray, int[] nArray2) {
        if (nArray2[0] == 255 && nArray2[1] == 255 && nArray2[2] == 255) {
            return new int[]{nArray[0], nArray[1], nArray[2]};
        }
        return new int[]{Math.max(nArray[0], nArray2[0]), Math.max(nArray[1], nArray2[1]), Math.max(nArray[2], nArray2[2])};
    }

    private static int[] doColorDodge(int[] nArray, int[] nArray2) {
        if (nArray2[0] == 255 && nArray2[1] == 255 && nArray2[2] == 255) {
            return new int[]{nArray[0], nArray[1], nArray[2]};
        }
        return new int[]{nArray[0] == 255 ? 255 : Math.min((nArray2[0] << 8) / (255 - nArray[0]), 255), nArray[1] == 255 ? 255 : Math.min((nArray2[1] << 8) / (255 - nArray[1]), 255), nArray[2] == 255 ? 255 : Math.min((nArray2[2] << 8) / (255 - nArray[2]), 255)};
    }

    private static int[] doColorBurn(int[] nArray, int[] nArray2) {
        if (nArray2[0] == 255 && nArray2[1] == 255 && nArray2[2] == 255) {
            return new int[]{nArray[0], nArray[1], nArray[2]};
        }
        return new int[]{nArray[0] == 0 ? 0 : Math.max(0, 255 - (255 - nArray2[0] << 8) / nArray[0]), nArray[1] == 0 ? 0 : Math.max(0, 255 - (255 - nArray2[1] << 8) / nArray[1]), nArray[2] == 0 ? 0 : Math.max(0, 255 - (255 - nArray2[2] << 8) / nArray[2])};
    }

    private static int[] doSoftLight(int[] nArray, int[] nArray2) {
        if (nArray2[0] == 255 && nArray2[1] == 255 && nArray2[2] == 255) {
            return new int[]{nArray[0], nArray[1], nArray[2]};
        }
        int[] nArray3 = new int[3];
        for (int i = 0; i < 3; ++i) {
            double d = (double)nArray[i] / 255.0;
            double d2 = (double)nArray2[i] / 255.0;
            nArray3[i] = d <= 0.5 ? (int)(255.0 * (d2 - (1.0 - 2.0 * d) * d2 * (1.0 - d2))) : (d2 > 0.25 ? (int)(255.0 * (d2 + (2.0 * d - 1.0) * (Math.sqrt(d2) - d2))) : (int)(255.0 * (d2 + (2.0 * d - 1.0) * (((16.0 * d2 - 12.0) * d2 + 4.0) * d2 - d2))));
        }
        return nArray3;
    }

    private static int[] doDifference(int[] nArray, int[] nArray2) {
        if (nArray2[0] == 255 && nArray2[1] == 255 && nArray2[2] == 255) {
            return new int[]{nArray[0], nArray[1], nArray[2]};
        }
        return new int[]{Math.abs(nArray2[0] - nArray[0]), Math.abs(nArray2[1] - nArray[1]), Math.abs(nArray2[2] - nArray[2])};
    }

    private static int[] doExclusion(int[] nArray, int[] nArray2) {
        if (nArray2[0] == 255 && nArray2[1] == 255 && nArray2[2] == 255) {
            return new int[]{nArray[0], nArray[1], nArray[2]};
        }
        return new int[]{nArray2[0] + nArray[0] - (nArray2[0] * nArray[0] >> 7), nArray2[1] + nArray[1] - (nArray2[1] * nArray[1] >> 7), nArray2[2] + nArray[2] - (nArray2[2] * nArray[2] >> 7)};
    }

    private static int[] doColor(int[] nArray, int[] nArray2) {
        if (nArray2[0] == 255 && nArray2[1] == 255 && nArray2[2] == 255) {
            return new int[]{nArray[0], nArray[1], nArray[2]};
        }
        int[] nArray3 = new int[3];
        double d = (double)nArray[0] / 255.0;
        double d2 = (double)nArray[1] / 255.0;
        double d3 = (double)nArray[2] / 255.0;
        double d4 = (double)nArray2[0] / 255.0;
        double d5 = (double)nArray2[1] / 255.0;
        double d6 = (double)nArray2[2] / 255.0;
        double[] dArray = BlendContext.setLum(d, d2, d3, BlendContext.lum(d4, d5, d6));
        nArray3[0] = (int)(255.0 * dArray[0]);
        nArray3[1] = (int)(255.0 * dArray[1]);
        nArray3[2] = (int)(255.0 * dArray[2]);
        return nArray3;
    }

    private static int[] doLuminosity(int[] nArray, int[] nArray2) {
        if (nArray2[0] == 255 && nArray2[1] == 255 && nArray2[2] == 255) {
            return new int[]{nArray[0], nArray[1], nArray[2]};
        }
        int[] nArray3 = new int[3];
        double d = (double)nArray[0] / 255.0;
        double d2 = (double)nArray[1] / 255.0;
        double d3 = (double)nArray[2] / 255.0;
        double d4 = (double)nArray2[0] / 255.0;
        double d5 = (double)nArray2[1] / 255.0;
        double d6 = (double)nArray2[2] / 255.0;
        double[] dArray = BlendContext.setLum(d4, d5, d6, BlendContext.lum(d, d2, d3));
        nArray3[0] = (int)(255.0 * dArray[0]);
        nArray3[1] = (int)(255.0 * dArray[1]);
        nArray3[2] = (int)(255.0 * dArray[2]);
        return nArray3;
    }

    private static int[] doHue(int[] nArray, int[] nArray2) {
        if (nArray2[0] == 255 && nArray2[1] == 255 && nArray2[2] == 255) {
            return new int[]{nArray[0], nArray[1], nArray[2]};
        }
        double[] dArray = new double[3];
        BlendContext.rgbToHSL(nArray[0], nArray[1], nArray[2], dArray);
        double[] dArray2 = new double[3];
        BlendContext.rgbToHSL(nArray2[0], nArray2[1], nArray2[2], dArray2);
        int[] nArray3 = new int[4];
        BlendContext.hslToRGB(dArray[0], dArray2[1], dArray2[2], nArray3);
        return nArray3;
    }

    private static int[] doSaturation(int[] nArray, int[] nArray2) {
        if (nArray2[0] == 255 && nArray2[1] == 255 && nArray2[2] == 255) {
            return new int[]{nArray[0], nArray[1], nArray[2]};
        }
        double[] dArray = new double[3];
        BlendContext.rgbToHSL(nArray[0], nArray[1], nArray[2], dArray);
        double[] dArray2 = new double[3];
        BlendContext.rgbToHSL(nArray2[0], nArray2[1], nArray2[2], dArray2);
        int[] nArray3 = new int[4];
        BlendContext.hslToRGB(dArray2[0], dArray[1], dArray2[2], nArray3);
        return nArray3;
    }

    private static double lum(double d, double d2, double d3) {
        return 0.3 * d + 0.59 * d2 + 0.11 * d3;
    }

    private static double[] setLum(double d, double d2, double d3, double d4) {
        double d5 = d4 - BlendContext.lum(d, d2, d3);
        return BlendContext.clipColor(d += d5, d2 += d5, d3 += d5);
    }

    private static double[] clipColor(double d, double d2, double d3) {
        double d4 = BlendContext.lum(d, d2, d3);
        double d5 = Math.min(Math.min(d, d2), d3);
        double d6 = Math.max(Math.max(d, d2), d3);
        if (d5 < 0.0) {
            d = d4 + (d - d4) * d4 / (d4 - d5);
            d2 = d4 + (d2 - d4) * d4 / (d4 - d5);
            d3 = d4 + (d3 - d4) * d4 / (d4 - d5);
        }
        if (d6 > 1.0) {
            d = d4 + (d - d4) * (1.0 - d4) / (d6 - d4);
            d2 = d4 + (d2 - d4) * (1.0 - d4) / (d6 - d4);
            d3 = d4 + (d3 - d4) * (1.0 - d4) / (d6 - d4);
        }
        return new double[]{d, d2, d3};
    }

    private static void rgbToHSL(int n, int n2, int n3, double[] dArray) {
        double d;
        double d2;
        double d3 = (double)n / 255.0;
        double d4 = (double)n2 / 255.0;
        double d5 = (double)n3 / 255.0;
        double d6 = Math.min(Math.min(d3, d4), d5);
        double d7 = Math.max(Math.max(d3, d4), d5);
        double d8 = d7 - d6;
        double d9 = (d7 + d6) / 2.0;
        if (d8 - 0.01 <= 0.0) {
            d2 = 0.0;
            d = 0.0;
        } else {
            d = d9 < 0.5 ? d8 / (d7 + d6) : d8 / (2.0 - d7 - d6);
            double d10 = ((d7 - d3) / 6.0 + d8 / 2.0) / d8;
            double d11 = ((d7 - d4) / 6.0 + d8 / 2.0) / d8;
            double d12 = ((d7 - d5) / 6.0 + d8 / 2.0) / d8;
            d2 = d3 == d7 ? d12 - d11 : (d4 == d7 ? 0.3333333432674408 + d10 - d12 : 0.6666666865348816 + d11 - d10);
            if (d2 < 0.0) {
                d2 += 1.0;
            }
            if (d2 > 1.0) {
                d2 -= 1.0;
            }
        }
        dArray[0] = d2;
        dArray[1] = d;
        dArray[2] = d9;
    }

    private static void hslToRGB(double d, double d2, double d3, int[] nArray) {
        int n;
        int n2;
        int n3;
        if (d2 - 0.01 <= 0.0) {
            n3 = (int)(d3 * 255.0);
            n2 = (int)(d3 * 255.0);
            n = (int)(d3 * 255.0);
        } else {
            double d4 = d3 < 0.5 ? d3 * (1.0 + d2) : d3 + d2 - d2 * d3;
            double d5 = 2.0 * d3 - d4;
            n3 = (int)(255.0 * BlendContext.hueToRGB(d5, d4, d + 0.3333333333333333));
            n2 = (int)(255.0 * BlendContext.hueToRGB(d5, d4, d));
            n = (int)(255.0 * BlendContext.hueToRGB(d5, d4, d - 0.3333333333333333));
        }
        nArray[0] = n3;
        nArray[1] = n2;
        nArray[2] = n;
    }

    private static double hueToRGB(double d, double d2, double d3) {
        if (d3 < 0.0) {
            d3 += 1.0;
        }
        if (d3 > 1.0) {
            d3 -= 1.0;
        }
        if (6.0 * d3 < 1.0) {
            return d + (d2 - d) * 6.0 * d3;
        }
        if (2.0 * d3 < 1.0) {
            return d2;
        }
        if (3.0 * d3 < 2.0) {
            return d + (d2 - d) * (0.6666666666666666 - d3) * 6.0;
        }
        return d;
    }
}

