/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.BitReader;
import com.idrsolutions.pdf.color.shading.ShadingFactory;
import com.idrsolutions.pdf.color.shading.Shape67;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.objects.raw.PdfObject;

public class CoonsContext
implements PaintContext {
    private GenericColorSpace shadingColorSpace;
    private final float[] background;
    private int bitsPerCoordinate;
    private int bitsPerComponent;
    private int bitsPerFlag;
    private int colCompCount;
    private float[] decodeArr;
    private float[][] matrix;
    private ArrayList<Point2D> pp;
    private ArrayList<Color> pc;
    private final ArrayList<Shape67> shapes;
    private BitReader reader;
    private PDFFunction[] function;
    private final Shape67[] duplicates;
    private final boolean isRecursive;

    CoonsContext(AffineTransform affineTransform, ArrayList<Shape67> arrayList, float[] fArray, int n, float f, int n2, int n3) {
        this.shapes = arrayList;
        this.background = fArray;
        this.duplicates = new Shape67[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            Shape67 shape67 = arrayList.get(i).cloneShape();
            shape67.applyTransformation(affineTransform);
            this.duplicates[i] = shape67;
        }
        this.isRecursive = this.duplicates.length < 50;
    }

    CoonsContext(AffineTransform affineTransform, GenericColorSpace genericColorSpace, float[] fArray, PdfObject pdfObject, float[][] fArray2, int n, float f, int n2, int n3, PDFFunction[] pDFFunctionArray) {
        this.shadingColorSpace = genericColorSpace;
        this.background = fArray;
        this.bitsPerComponent = pdfObject.getInt(-1344207655);
        this.bitsPerFlag = pdfObject.getInt(1500422077);
        this.bitsPerCoordinate = pdfObject.getInt(-335950113);
        this.decodeArr = pdfObject.getFloatArray(859785322);
        boolean bl = this.bitsPerFlag < 8 || this.bitsPerComponent < 8 || this.bitsPerCoordinate < 8;
        this.reader = new BitReader(pdfObject.getDecodedStream(), bl);
        this.colCompCount = genericColorSpace.getColorComponentCount();
        if (this.decodeArr != null) {
            this.colCompCount = (this.decodeArr.length - 4) / 2;
        }
        this.function = pDFFunctionArray;
        this.matrix = fArray2;
        this.pp = new ArrayList();
        this.pc = new ArrayList();
        this.shapes = new ArrayList();
        this.process();
        this.adjustPoints();
        this.duplicates = new Shape67[this.shapes.size()];
        for (int i = 0; i < this.shapes.size(); ++i) {
            Shape67 shape67 = this.shapes.get(i).cloneShape();
            shape67.applyTransformation(affineTransform);
            this.duplicates[i] = shape67;
        }
        this.isRecursive = this.duplicates.length < 50;
    }

    private void process() {
        block6: while (this.reader.getPointer() < this.reader.getTotalBitLen()) {
            int n = this.reader.getPositive(this.bitsPerFlag);
            Point2D[] point2DArray = new Point2D[4];
            Color[] colorArray = new Color[2];
            float[] fArray = new float[this.colCompCount];
            switch (n) {
                case 0: {
                    Object object;
                    int n2;
                    for (n2 = 0; n2 < 12; ++n2) {
                        object = this.getPointCoords();
                        this.pp.add((Point2D)object);
                    }
                    for (n2 = 0; n2 < 4; ++n2) {
                        for (int i = 0; i < this.colCompCount; ++i) {
                            fArray[i] = this.reader.getFloat(this.bitsPerComponent);
                        }
                        object = this.calculateColor(fArray);
                        this.pc.add((Color)object);
                    }
                    continue block6;
                }
                case 1: {
                    Object object;
                    int n2;
                    point2DArray[0] = this.pp.get(this.pp.size() - 9);
                    point2DArray[1] = this.pp.get(this.pp.size() - 8);
                    point2DArray[2] = this.pp.get(this.pp.size() - 7);
                    point2DArray[3] = this.pp.get(this.pp.size() - 6);
                    this.pp.addAll(Arrays.asList(point2DArray).subList(0, 4));
                    for (n2 = 0; n2 < 8; ++n2) {
                        object = this.getPointCoords();
                        this.pp.add((Point2D)object);
                    }
                    colorArray[0] = this.pc.get(this.pc.size() - 3);
                    colorArray[1] = this.pc.get(this.pc.size() - 2);
                    this.pc.addAll(Arrays.asList(colorArray));
                    for (n2 = 0; n2 < 2; ++n2) {
                        for (int i = 0; i < this.colCompCount; ++i) {
                            fArray[i] = this.reader.getFloat(this.bitsPerComponent);
                        }
                        object = this.calculateColor(fArray);
                        this.pc.add((Color)object);
                    }
                    continue block6;
                }
                case 2: {
                    Object object;
                    int n2;
                    point2DArray[0] = this.pp.get(this.pp.size() - 6);
                    point2DArray[1] = this.pp.get(this.pp.size() - 5);
                    point2DArray[2] = this.pp.get(this.pp.size() - 4);
                    point2DArray[3] = this.pp.get(this.pp.size() - 3);
                    this.pp.addAll(Arrays.asList(point2DArray).subList(0, 4));
                    for (n2 = 0; n2 < 8; ++n2) {
                        object = this.getPointCoords();
                        this.pp.add((Point2D)object);
                    }
                    colorArray[0] = this.pc.get(this.pc.size() - 2);
                    colorArray[1] = this.pc.get(this.pc.size() - 1);
                    this.pc.addAll(Arrays.asList(colorArray));
                    for (n2 = 0; n2 < 2; ++n2) {
                        for (int i = 0; i < this.colCompCount; ++i) {
                            fArray[i] = this.reader.getFloat(this.bitsPerComponent);
                        }
                        object = this.calculateColor(fArray);
                        this.pc.add((Color)object);
                    }
                    continue block6;
                }
                case 3: {
                    Object object;
                    int n2;
                    point2DArray[0] = this.pp.get(this.pp.size() - 3);
                    point2DArray[1] = this.pp.get(this.pp.size() - 2);
                    point2DArray[2] = this.pp.get(this.pp.size() - 1);
                    point2DArray[3] = this.pp.get(this.pp.size() - 12);
                    this.pp.addAll(Arrays.asList(point2DArray).subList(0, 4));
                    for (n2 = 0; n2 < 8; ++n2) {
                        object = this.getPointCoords();
                        this.pp.add((Point2D)object);
                    }
                    colorArray[0] = this.pc.get(this.pc.size() - 1);
                    colorArray[1] = this.pc.get(this.pc.size() - 4);
                    this.pc.addAll(Arrays.asList(colorArray));
                    for (n2 = 0; n2 < 2; ++n2) {
                        for (int i = 0; i < this.colCompCount; ++i) {
                            fArray[i] = this.reader.getFloat(this.bitsPerComponent);
                        }
                        object = this.calculateColor(fArray);
                        this.pc.add((Color)object);
                    }
                    break;
                }
            }
        }
    }

    private void adjustPoints() {
        int n;
        Point2D[] point2DArray;
        if (this.decodeArr != null) {
            float f = this.decodeArr[0];
            float f2 = this.decodeArr[1];
            float f3 = this.decodeArr[2];
            float f4 = this.decodeArr[3];
            float f5 = f2 - f;
            float f6 = f4 - f3;
            point2DArray = new ArrayList();
            for (Point2D object : this.pp) {
                double d = object.getX();
                double d2 = object.getY();
                d = (double)f5 * d + (double)f;
                d2 = (double)f6 * d2 + (double)f3;
                point2DArray.add(new Point2D.Double(d, d2));
            }
            this.pp.clear();
            for (Point2D point2D : point2DArray) {
                this.pp.add(point2D);
            }
        }
        Point2D[] point2DArray2 = new Point2D[this.pp.size()];
        for (n = 0; n < point2DArray2.length; ++n) {
            point2DArray2[n] = this.pp.get(n);
        }
        n = this.pp.size() / 12;
        int n2 = 0;
        double[] dArray = new double[]{this.matrix[0][0], this.matrix[0][1], this.matrix[1][0], this.matrix[1][1], this.matrix[2][0], this.matrix[2][1]};
        AffineTransform affineTransform = new AffineTransform(dArray);
        for (int i = 0; i < n; ++i) {
            point2DArray = new Point2D[12];
            Iterator<Point2D> iterator = new Color[]{this.pc.get(i * 4), this.pc.get(i * 4 + 1), this.pc.get(i * 4 + 2), this.pc.get(i * 4 + 3)};
            System.arraycopy(point2DArray2, n2, point2DArray, 0, 12);
            Shape67 shape67 = new Shape67(point2DArray, (Color[])iterator);
            shape67.applyTransformation(affineTransform);
            this.shapes.add(shape67);
            n2 += 12;
        }
    }

    private Point2D getPointCoords() {
        double d = 0.0;
        double d2 = 0.0;
        block4: for (int i = 0; i < 2; ++i) {
            switch (i) {
                case 0: {
                    d = this.reader.getFloat(this.bitsPerCoordinate);
                    continue block4;
                }
                case 1: {
                    d2 = this.reader.getFloat(this.bitsPerCoordinate);
                }
            }
        }
        return new Point2D.Double(d, d2);
    }

    @Override
    public void dispose() {
        this.reader = null;
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int n, int n2, int n3, int n4) {
        Serializable serializable;
        WritableRaster writableRaster = new BufferedImage(n3, n4, 2).getRaster();
        int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        if (this.background != null) {
            int n5 = 0;
            this.shadingColorSpace.setColor(this.background, 4);
            serializable = (Color)((Object)this.shadingColorSpace.getColor());
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    nArray[n5++] = 0xFF000000 | ((Color)serializable).getRGB();
                }
            }
        }
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        serializable = new ArrayList();
        for (Shape67 shape67 : this.duplicates) {
            if (!shape67.getShape().intersects(rectangle)) continue;
            serializable.add(shape67);
        }
        Iterator iterator = serializable.iterator();
        while (iterator.hasNext()) {
            Shape67 shape67 = (Shape67)iterator.next();
            GeneralPath generalPath = shape67.getShape();
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    Point point;
                    Color color;
                    int n6 = j + n;
                    int n7 = i + n2;
                    if (!generalPath.contains(n6, n7) || (color = shape67.findPointColor(point = new Point(n6, n7), this.isRecursive)) == null) continue;
                    int n8 = i * n3 + j;
                    nArray[n8] = 0xFF000000 | color.getRGB();
                }
            }
        }
        return writableRaster;
    }

    private Color calculateColor(float[] fArray) {
        Color color;
        if (this.function == null) {
            this.shadingColorSpace.setColor(fArray, this.colCompCount);
            color = new Color(this.shadingColorSpace.getColor().getRGB());
        } else {
            float[] fArray2 = ShadingFactory.applyFunctions(this.function, fArray);
            this.shadingColorSpace.setColor(fArray2, fArray2.length);
            color = (Color)((Object)this.shadingColorSpace.getColor());
        }
        return color;
    }

    public ArrayList<Shape67> getShapes() {
        return this.shapes;
    }
}

