/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.BitReader;
import com.idrsolutions.pdf.color.shading.PixelFactory;
import com.idrsolutions.pdf.color.shading.ShadingUtils;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.objects.raw.PdfObject;

public class FreeFormContext
implements PaintContext {
    private final int bitsPerCoordinate;
    private final int bitsPerComponent;
    private final int bitsPerFlag;
    private final int colCompCount;
    private final float[] decodeArr;
    private final float[][] matrix;
    private final ArrayList<Point2D> triangles;
    private final ArrayList<Color> triColors;
    private final ArrayList<GeneralPath> shapes;
    private final int pageHeight;
    private final float scaling;
    private final int offX;
    private final int offY;
    private final BitReader reader;

    FreeFormContext(GenericColorSpace genericColorSpace, float[] fArray, PdfObject pdfObject, float[][] fArray2, int n, float f, int n2, int n3) {
        this.bitsPerComponent = pdfObject.getInt(-1344207655);
        this.bitsPerFlag = pdfObject.getInt(1500422077);
        this.bitsPerCoordinate = pdfObject.getInt(-335950113);
        this.decodeArr = pdfObject.getFloatArray(859785322);
        this.colCompCount = genericColorSpace.getColorComponentCount();
        this.matrix = fArray2;
        this.pageHeight = n;
        this.scaling = f;
        this.offX = n2;
        this.offY = n3;
        this.triangles = new ArrayList();
        this.triColors = new ArrayList();
        this.shapes = new ArrayList();
        boolean bl = this.bitsPerFlag < 8 || this.bitsPerComponent < 8 || this.bitsPerCoordinate < 8;
        this.reader = new BitReader(pdfObject.getDecodedStream(), bl);
        this.process();
        this.adjustPoints();
    }

    private void process() {
        while (this.reader.getPointer() < this.reader.getTotalBitLen()) {
            int n = this.reader.getPositive(this.bitsPerFlag);
            Point2D point2D = this.getPointCoords();
            float[] fArray = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            for (int i = 0; i < this.colCompCount; ++i) {
                fArray[i] = this.reader.getFloat(this.bitsPerComponent);
            }
            Color color = new Color(fArray[0], fArray[1], fArray[2], fArray[3]);
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    Point2D[] point2DArray = new Point2D[]{this.triangles.get(this.triangles.size() - 2), this.triangles.get(this.triangles.size() - 1)};
                    this.triangles.addAll(Arrays.asList(point2DArray));
                    Color[] colorArray = new Color[]{this.triColors.get(this.triColors.size() - 2), this.triColors.get(this.triColors.size() - 1)};
                    this.triColors.addAll(Arrays.asList(colorArray));
                    break;
                }
                case 2: {
                    Point2D[] point2DArray = new Point2D[]{this.triangles.get(this.triangles.size() - 3), this.triangles.get(this.triangles.size() - 1)};
                    this.triangles.addAll(Arrays.asList(point2DArray));
                    Color[] colorArray = new Color[]{this.triColors.get(this.triColors.size() - 3), this.triColors.get(this.triColors.size() - 1)};
                    this.triColors.addAll(Arrays.asList(colorArray));
                }
            }
            this.triangles.add(point2D);
            this.triColors.add(color);
        }
    }

    private void adjustPoints() {
        float f = this.decodeArr[0];
        float f2 = this.decodeArr[1];
        float f3 = this.decodeArr[2];
        float f4 = this.decodeArr[3];
        float f5 = f2 - f;
        float f6 = f4 - f3;
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        for (Point2D point2D : this.triangles) {
            double d = point2D.getX();
            double d2 = point2D.getY();
            d = (double)f5 * d + (double)f;
            d2 = (double)f6 * d2 + (double)f3;
            arrayList.add(new Point2D.Double(d, d2));
        }
        this.triangles.clear();
        float f7 = 1.0f / this.matrix[0][0];
        float f8 = 1.0f / this.matrix[1][1];
        float f9 = this.matrix[2][0] * f7;
        float f10 = this.matrix[2][1] * f8;
        for (Point2D cloneable : arrayList) {
            double d = cloneable.getX();
            double d2 = cloneable.getY();
            float f11 = 0.0f;
            float f12 = 0.0f;
            double d3 = d + (double)f12 * d2 + (double)f9;
            double d4 = (double)f11 * d + d2 + (double)f10;
            d3 = (int)d3;
            d4 = (int)d4;
            this.triangles.add(new Point2D.Double(d3, d4));
        }
        for (int i = 0; i < this.triangles.size(); i += 3) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(this.triangles.get(i).getX(), this.triangles.get(i).getY());
            generalPath.lineTo(this.triangles.get(i + 1).getX(), this.triangles.get(i + 1).getY());
            generalPath.lineTo(this.triangles.get(i + 2).getX(), this.triangles.get(i + 2).getY());
            generalPath.closePath();
            this.shapes.add(generalPath);
        }
    }

    private Point2D getPointCoords() {
        double d = 0.0;
        double d2 = 0.0;
        block4: for (int i = 0; i < 2; ++i) {
            switch (i) {
                case 0: {
                    d = this.reader.getFloat(this.bitsPerCoordinate);
                    continue block4;
                }
                case 1: {
                    d2 = this.reader.getFloat(this.bitsPerCoordinate);
                }
            }
        }
        return new Point2D.Double(d, d2);
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int n, int n2, int n3, int n4) {
        int n5 = n3 * n4 * 4;
        int[] nArray = new int[n5];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                float[] fArray = PixelFactory.convertPhysicalToPDF(false, j, i, this.offX, this.offY, 1.0f / this.scaling, n, n2, 0, this.pageHeight);
                float f = fArray[0];
                float f2 = fArray[1];
                int n6 = 0;
                for (GeneralPath generalPath : this.shapes) {
                    Point2D.Double double_;
                    if (generalPath.contains(double_ = new Point2D.Double(f, f2))) {
                        Color color;
                        Color color2;
                        double d;
                        double d2;
                        Color color3;
                        float f3;
                        double d3;
                        double d4;
                        Point2D point2D;
                        Rectangle2D rectangle2D = generalPath.getBounds2D();
                        Point2D.Double double_2 = new Point2D.Double(-1024.0, f2);
                        Point2D.Double double_3 = new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth(), f2);
                        Line2D.Double double_4 = new Line2D.Double(double_2, double_3);
                        Point2D point2D2 = this.triangles.get(n6 + 0);
                        Color color4 = this.triColors.get(n6 + 0);
                        Point2D point2D3 = this.triangles.get(n6 + 1);
                        Color color5 = this.triColors.get(n6 + 1);
                        Point2D point2D4 = this.triangles.get(n6 + 2);
                        Color color6 = this.triColors.get(n6 + 2);
                        Line2D.Double double_5 = new Line2D.Double(point2D2, point2D3);
                        Line2D.Double double_6 = new Line2D.Double(point2D3, point2D4);
                        Line2D.Double double_7 = new Line2D.Double(point2D2, point2D4);
                        ArrayList<Color> arrayList = new ArrayList<Color>();
                        ArrayList<Point2D> arrayList2 = new ArrayList<Point2D>();
                        if (double_5.intersectsLine(double_4)) {
                            point2D = ShadingUtils.findIntersect(double_2, double_3, point2D2, point2D3);
                            d4 = point2D2.distance(point2D);
                            d3 = point2D3.distance(point2D);
                            f3 = (float)(d4 / (d4 + d3));
                            color3 = ShadingUtils.interpolate2Color(color4, color5, f3);
                            arrayList.add(color3);
                            arrayList2.add(point2D);
                        }
                        if (double_6.intersectsLine(double_4)) {
                            point2D = ShadingUtils.findIntersect(double_2, double_3, point2D3, point2D4);
                            d4 = point2D3.distance(point2D);
                            d3 = point2D4.distance(point2D);
                            f3 = (float)(d4 / (d4 + d3));
                            color3 = ShadingUtils.interpolate2Color(color5, color6, f3);
                            arrayList.add(color3);
                            arrayList2.add(point2D);
                        }
                        if (double_7.intersectsLine(double_4)) {
                            point2D = ShadingUtils.findIntersect(double_2, double_3, point2D2, point2D4);
                            d4 = point2D2.distance(point2D);
                            d3 = point2D4.distance(point2D);
                            f3 = (float)(d4 / (d4 + d3));
                            color3 = ShadingUtils.interpolate2Color(color4, color6, f3);
                            arrayList.add(color3);
                            arrayList2.add(point2D);
                        }
                        if (arrayList2.size() == 2) {
                            d2 = ((Point2D)arrayList2.get(0)).distance(double_);
                            d = ((Point2D)arrayList2.get(1)).distance(double_);
                            color2 = (Color)arrayList.get(0);
                            Color color7 = (Color)arrayList.get(1);
                            float f4 = (float)(d2 / (d2 + d));
                            color = ShadingUtils.interpolate2Color(color2, color7, f4);
                        } else if (point2D2.getY() == ((Point2D)double_).getY()) {
                            d2 = ((Point2D)arrayList2.get(1)).distance(double_);
                            d = point2D2.distance(double_);
                            color2 = (Color)arrayList.get(1);
                            f3 = (float)(d2 / (d2 + d));
                            color = ShadingUtils.interpolate2Color(color2, color4, f3);
                        } else if (point2D3.getY() == ((Point2D)double_).getY()) {
                            d2 = ((Point2D)arrayList2.get(2)).distance(double_);
                            d = point2D3.distance(double_);
                            color2 = (Color)arrayList.get(2);
                            f3 = (float)(d2 / (d2 + d));
                            color = ShadingUtils.interpolate2Color(color2, color5, f3);
                        } else {
                            d2 = ((Point2D)arrayList2.get(0)).distance(double_);
                            d = point2D4.distance(double_);
                            color2 = (Color)arrayList.get(0);
                            f3 = (float)(d2 / (d2 + d));
                            color = ShadingUtils.interpolate2Color(color2, color6, f3);
                        }
                        int n7 = (i * n3 + j) * 4;
                        nArray[n7] = color.getRed();
                        nArray[n7 + 1] = color.getGreen();
                        nArray[n7 + 2] = color.getBlue();
                        nArray[n7 + 3] = color.getAlpha();
                    }
                    n6 += 3;
                }
            }
        }
        WritableRaster writableRaster = new BufferedImage(n3, n4, 2).getRaster();
        writableRaster.setPixels(0, 0, n3, n4, nArray);
        return writableRaster;
    }
}

