/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jpedal.DevFlags;
import org.jpedal.FileAccess;
import org.jpedal.Parser;
import org.jpedal.PdfDecoderInt;
import org.jpedal.constants.JPedalSettings;
import org.jpedal.display.Display;
import org.jpedal.display.DisplayOffsets;
import org.jpedal.display.GUIModes;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.display.PageOffsets;
import org.jpedal.display.javafx.SingleDisplayFX;
import org.jpedal.examples.viewer.commands.javafx.JavaFXPreferences;
import org.jpedal.examples.viewer.gui.FXAdditionalData;
import org.jpedal.examples.viewer.gui.JavaFxGUI;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMouseFunctionality;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMouseListener;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.external.FXExternalHandlers;
import org.jpedal.external.PluginHandler;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.gui.UIViewerInt;
import org.jpedal.gui.ViewerInt;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.JavaFXDefaultActionHandler;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.outlines.OutlineData;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.DecoderResults;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.FXDisplay;
import org.jpedal.text.TextLines;
import org.jpedal.utils.DPIFactory;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;

public class PdfDecoderFX
extends Pane
implements Printable,
Pageable,
PdfDecoderInt {
    private Image previewImage;
    private String previewText;
    private int curThumbPage = 1;
    private final DecoderOptions options = new DecoderOptions();
    private final ExternalHandlers externalHandlers = new FXExternalHandlers(GUIModes.JAVAFX);
    private final PdfResources res = new PdfResources();
    final FileAccess fileAccess = new FileAccess(this.externalHandlers, this.res, this.options);
    private final DecoderResults resultsFromDecode = new DecoderResults();
    final Parser parser = new Parser(this.externalHandlers, this.options, this.fileAccess, this.res, this.resultsFromDecode);
    private final DPIFactory scalingdpi = new DPIFactory();
    public boolean useNewGraphicsMode = true;
    public Display pages;
    private boolean isBorderPresent = true;
    private final DisplayOffsets displayOffsets = new DisplayOffsets();
    private ActionHandler formsActionHandler;
    private ActionHandler userActionHandler;
    private int scrollInterval = 10;
    private boolean isNewRotationSet;
    int displayRotation;
    int x_size = 100;
    int y_size = 100;
    int max_x;
    int max_y;
    float scaling = 1.0f;
    protected Border myBorder;
    private Rectangle imageHighlighter;
    private StatusBar statusBar;
    Canvas previewThumbnail;
    protected int specialMode = -1;
    public int textPrint;
    public final Pane highlightsPane = new Pane();
    private static int color;
    private static float opacity;
    private static javafx.scene.paint.Color highlights;

    @Override
    public boolean isOpen() {
        return this.fileAccess.isOpen();
    }

    private void drawPreviewImage(Graphics2D graphics2D, java.awt.Rectangle rectangle) {
        if (this.previewImage != null) {
            GraphicsContext graphicsContext = this.previewThumbnail.getGraphicsContext2D();
            graphicsContext.setFill((Paint)new javafx.scene.paint.Color(0.25, 0.25, 0.25, 1.0));
            graphicsContext.fillRect(0.0, 0.0, this.previewThumbnail.getWidth(), this.previewThumbnail.getHeight());
            graphicsContext.drawImage(this.previewImage, 10.0, 10.0);
            graphicsContext.setStroke((Paint)new javafx.scene.paint.Color(1.0, 1.0, 1.0, 1.0));
            graphicsContext.strokeText(this.previewText, 10.0, this.previewThumbnail.getHeight() - 10.0);
            ScrollPane scrollPane = (ScrollPane)this.getParent().getParent().getParent().getParent();
            Group group = (Group)this.getParent();
            double d = group.getBoundsInParent().getMinX();
            double d2 = scrollPane.getViewportBounds().getWidth();
            double d3 = scrollPane.getViewportBounds().getHeight();
            double d4 = this.getBoundsInParent().getWidth();
            double d5 = this.previewThumbnail.getBoundsInLocal().getWidth();
            double d6 = this.previewThumbnail.getBoundsInLocal().getHeight();
            double d7 = d4 + (d2 - d - d4 - d5 - 10.0);
            double d8 = (d3 - d6) / (double)this.getPageCount() * (double)(this.curThumbPage - 1);
            this.previewThumbnail.setLayoutX(d7);
            this.previewThumbnail.setLayoutY(d8);
        }
    }

    @Override
    public ExternalHandlers getExternalHandler() {
        return this.externalHandlers;
    }

    protected PdfResources getRes() {
        return this.res;
    }

    @Override
    public int getDisplayRotation() {
        return this.displayRotation;
    }

    DecoderOptions getOptions() {
        return this.options;
    }

    @Override
    public int getPageNumber() {
        return this.fileAccess.getPageNumber();
    }

    public void setPageNumber(int n) {
        this.fileAccess.setPageNumber(n);
    }

    @Override
    public void setDisplayRotation(int n) {
        this.displayRotation = n;
    }

    @Override
    public Display getPages() {
        return this.pages;
    }

    @Override
    public int getlastPageDecoded() {
        return this.fileAccess.getLastPageDecoded();
    }

    @Override
    public Iterator getPageInfo(int n) {
        return this.resultsFromDecode.getPageInfo(n);
    }

    @Override
    public OutlineData getOutlineData() {
        return this.res.getOutlineData();
    }

    @Override
    public boolean isLoadingLinearizedPDF() {
        return this.fileAccess.linearParser.linearizedBackgroundReaderer != null && this.fileAccess.linearParser.linearizedBackgroundReaderer.isAlive();
    }

    @Override
    public boolean useNewGraphicsMode() {
        return this.useNewGraphicsMode;
    }

    @Override
    public void useNewGraphicsMode(boolean bl) {
        this.useNewGraphicsMode = bl;
    }

    @Override
    public int getSpecialMode() {
        return this.specialMode;
    }

    public void scrollRectToVisible(java.awt.Rectangle rectangle) {
        ScrollPane scrollPane = ((JavaFxGUI)this.getExternalHandler(4)).getPageContainer();
        double d = this.getWidth();
        double d2 = this.getHeight();
        scrollPane.setVvalue((double)rectangle.y / d2);
        scrollPane.setHvalue((double)rectangle.x / d);
    }

    @Override
    public void resetViewableArea() {
        throw new RuntimeException("resetViewableArea called in PdfDecoderFx");
    }

    @Override
    public AffineTransform setViewableArea(java.awt.Rectangle rectangle) throws PdfException {
        return null;
    }

    @Override
    public int getPageAlignment() {
        return this.options.getPageAlignment();
    }

    public PdfDecoderFX(int n, UIViewerInt uIViewerInt) {
        this.specialMode = n;
        this.pages = new SingleDisplayFX(this, this.options);
        this.options.setRenderPage(true);
        if (!FontMappings.fontsInitialised) {
            FontMappings.initFonts();
            FontMappings.fontsInitialised = true;
        }
        this.setId("PdfDecoderFX");
    }

    public void setPageDisplayMode(int n) {
        this.specialMode = n;
    }

    public static UIViewerInt getUIViewer() {
        return null;
    }

    public PdfDecoderFX() {
        this.pages = new SingleDisplayFX(this, this.options);
        this.options.setRenderPage(true);
        if (!FontMappings.fontsInitialised) {
            FontMappings.initFonts();
            FontMappings.fontsInitialised = true;
        }
        this.setId("PdfDecoderFX");
    }

    public PdfDecoderFX(UIViewerInt uIViewerInt, ViewerInt viewerInt, int n) {
        this.fileAccess.setPageCount(n);
        this.pages = new SingleDisplayFX(this, this.options);
        this.options.setRenderPage(true);
        this.setId("PdfDecoderFX");
    }

    public static void disposeAllStatic() {
        StandardFonts.dispose();
        FontMappings.dispose();
    }

    @Override
    public final void dispose() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.parser.disposeObjects();
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PdfDecoderFX.this.parser.disposeObjects();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public final void closePdfFile() {
        if (this.pages != null) {
            this.pages.stopGeneratingPage();
        }
        this.pages.disableScreen();
        this.fileAccess.closePdfFile();
    }

    @Override
    public final PdfData getPdfData() throws PdfException {
        return this.parser.getPdfData();
    }

    @Override
    public final boolean hasOutline() {
        return this.res.hasOutline();
    }

    @Override
    public final Document getOutlineAsXML() {
        return this.res.getOutlineAsXML(this.getIO());
    }

    @Override
    public final PdfPageData getPdfPageData() {
        return this.fileAccess.getPdfPageData();
    }

    public void setPagePrintRange(int n, int n2) throws PdfException {
    }

    public void setTextPrint(int n) {
        this.textPrint = n;
    }

    public void useLogicalPrintOffset(int n) {
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        return -1;
    }

    @Override
    public BufferedImage getPageAsImage(int n) throws PdfException {
        return this.getPageAsImage(n, false);
    }

    private BufferedImage getPageAsImage(int n, boolean bl) throws PdfException {
        this.parser.setParms(this.displayRotation, this.scaling, 0, this.specialMode);
        return this.parser.getPageAsImage(n, bl);
    }

    @Override
    public final void flushObjectValues(boolean bl) {
        this.parser.flushObjectValues(bl);
    }

    @Override
    public final PdfImageData getPdfImageData() {
        return this.parser.getPdfImageData();
    }

    @Override
    public final void setRenderMode(int n) {
        this.parser.setRenderMode(n);
    }

    @Override
    public final void setExtractionMode(int n) {
        this.parser.setExtractionMode(n);
    }

    @Override
    public void modifyNonstaticJPedalParameters(Map map) throws PdfException {
        this.options.set(map);
        if (map.containsKey(JPedalSettings.DISPLAY_BACKGROUND)) {
            // empty if block
        }
    }

    public static void modifyJPedalParameters(Map map) throws PdfException {
        if (map != null) {
            DecoderOptions.modifyJPedalParameters(map);
        }
    }

    @Override
    public final PdfFileInformation getFileInformationData() {
        return this.res.getMetaData(this.getIO());
    }

    @Override
    public final void setExtractionMode(int n, float f) {
        this.scaling = f;
        this.parser.setExtractionMode(n, f);
    }

    @Override
    public DPIFactory getDPIFactory() {
        return this.scalingdpi;
    }

    @Override
    public void setPageParameters(float f, int n) {
        boolean bl;
        PdfLayerList pdfLayerList;
        this.fileAccess.setPageNumber(n);
        this.parser.resetMultiplyer();
        if (this.getDisplayView() == 5 && f == -100.0f) {
            return;
        }
        if (f > 0.0f) {
            this.scaling = f;
        } else {
            f = this.scaling;
        }
        if (this.pages != null) {
            this.pages.setScaling(f);
        }
        if ((pdfLayerList = this.res.getPdfLayerList()) != null && (bl = pdfLayerList.setZoom(this.scalingdpi.removeScaling(f)))) {
            this.decodePage(-1);
        }
        PdfPageData pdfPageData = this.fileAccess.getPdfPageData();
        pdfPageData.setScalingValue(f);
        int n2 = pdfPageData.getMediaBoxWidth(n);
        this.max_y = pdfPageData.getMediaBoxHeight(n);
        this.max_x = pdfPageData.getMediaBoxWidth(n);
        int n3 = pdfPageData.getCropBoxWidth(n);
        int n4 = pdfPageData.getCropBoxHeight(n);
        this.x_size = (int)((float)n3 * f);
        this.y_size = (int)((float)n4 * f);
        if (!this.isNewRotationSet && this.getDisplayView() != 5) {
            this.displayRotation = pdfPageData.getRotation(n);
        } else {
            this.isNewRotationSet = false;
        }
        DynamicVectorRenderer dynamicVectorRenderer = this.fileAccess.getDynamicRenderer();
        dynamicVectorRenderer.init(n2, this.max_y, this.options.getPageColor());
        if (!dynamicVectorRenderer.isHTMLorSVG()) {
            dynamicVectorRenderer.setValue(1, this.options.getPageColor().getRGB());
            if (this.options.getTextColor() != null) {
                dynamicVectorRenderer.setValue(2, this.options.getTextColor().getRGB());
                if (this.options.getChangeTextAndLine()) {
                    dynamicVectorRenderer.setValue(3, 1);
                } else {
                    dynamicVectorRenderer.setValue(3, 0);
                }
            }
        }
        this.pages.setPageRotation(this.displayRotation);
        AcroRenderer acroRenderer = this.externalHandlers.getFormRenderer();
        if (acroRenderer != null) {
            acroRenderer.getCompData().setForceRedraw(true);
        }
    }

    @Override
    public void setPageParameters(float f, int n, int n2) {
        this.isNewRotationSet = true;
        this.displayRotation = n2;
        if (this.getDisplayView() == 5) {
            this.pages.init(0.0f, this.displayRotation, 0, null, false);
        } else {
            this.setPageParameters(f, n);
        }
    }

    @Override
    public void setStatusBarObject(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    @Override
    public void waitForDecodingToFinish() {
        this.fileAccess.waitForDecodingToFinish();
    }

    @Override
    public DynamicVectorRenderer getDynamicRenderer() {
        return this.fileAccess.getDynamicRenderer();
    }

    @Override
    public DynamicVectorRenderer getDynamicRenderer(boolean bl) {
        return this.fileAccess.getDynamicRenderer(bl);
    }

    public void setDefaultCursor(Cursor cursor) {
        if (SingleDisplayFX.allowChangeCursor) {
            this.setCursor(cursor);
        }
    }

    @Override
    public final void decodePage(final int n) {
        boolean bl = this.isPageAvailable(n);
        PdfObject pdfObject = this.fileAccess.linearParser.getLinearPageObject();
        boolean bl2 = this.res.getPdfLayerList() != null ? this.res.getPdfLayerList().getChangesMade() : false;
        if (!bl) {
            return;
        }
        if (bl && pdfObject != null) {
            this.fileAccess.readAllPageReferences(true, pdfObject, new HashMap(1000), new HashMap(1000), n, this.getFormRenderer(), this.res, this.options.getInsetW(), this.options.getInsetH());
        }
        this.parser.setStatusBar(this.statusBar);
        this.parser.setParms(this.displayRotation, this.scaling, (int)this.pages.getIndent(), this.specialMode);
        this.pages.setCursorBoxOnScreen(null, n == this.fileAccess.getLastPageDecoded());
        final FXDisplay fXDisplay = new FXDisplay(n, this.getObjectStore(), false);
        this.fileAccess.setDVR(fXDisplay);
        this.parser.decodePage(n);
        if (bl2) {
            this.externalHandlers.getFormRenderer().getCompData().resetScaledLocation(this.pages.getOldScaling(), this.displayRotation, 0);
        }
        if (Platform.isFxApplicationThread()) {
            color = DecoderOptions.highlightColor.getRGB();
            opacity = DecoderOptions.highlightComposite;
            this.highlightsPane.getChildren().clear();
            this.pages.init(this.scaling, this.displayRotation, n, fXDisplay, true);
            this.pages.refreshDisplay();
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    color = DecoderOptions.highlightColor.getRGB();
                    opacity = DecoderOptions.highlightComposite;
                    PdfDecoderFX.this.highlightsPane.getChildren().clear();
                    PdfDecoderFX.this.pages.init(PdfDecoderFX.this.scaling, PdfDecoderFX.this.displayRotation, n, fXDisplay, true);
                    PdfDecoderFX.this.pages.refreshDisplay();
                }
            });
        }
    }

    @Override
    public synchronized boolean isPageAvailable(int n) {
        return this.parser.isPageAvailable(n);
    }

    @Override
    public void drawAdditionalObjectsOverPage(int n, int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
        if (n == this.getPageNumber()) {
            FXAdditionalData fXAdditionalData = (FXAdditionalData)this.externalHandlers.getExternalHandler(33);
            if (fXAdditionalData != null) {
                fXAdditionalData.setType(nArray);
                fXAdditionalData.setObj(objectArray);
            } else {
                DynamicVectorRenderer dynamicVectorRenderer = this.fileAccess.getDynamicRenderer();
                dynamicVectorRenderer.drawAdditionalObjectsOverPage(nArray, colorArray, objectArray);
                this.pages.refreshDisplay();
            }
        }
    }

    @Override
    public void flushAdditionalObjectsOnPage(int n) throws PdfException {
        if (n == this.getPageNumber()) {
            this.fileAccess.setLastPageDecoded(-n);
            this.decodePage(n);
        }
    }

    @Override
    public boolean isHiResScreenDisplay() {
        return this.options.useHiResImageForDisplay();
    }

    @Override
    public void useHiResScreenDisplay(boolean bl) {
        this.options.useHiResImageForDisplay(bl);
    }

    @Override
    public final synchronized void decodePageInBackground(int n) throws Exception {
        this.parser.decodePageInBackground(n);
    }

    @Override
    public final int getPageCount() {
        return this.fileAccess.getPageCount();
    }

    @Override
    public final boolean isEncrypted() {
        return this.fileAccess.isEncrypted();
    }

    @Override
    public final boolean isPasswordSupplied() {
        return this.fileAccess.isPasswordSupplied(this.getIO());
    }

    @Override
    public boolean isFileViewable() {
        return this.fileAccess.isFileViewable(this.getIO());
    }

    @Override
    public boolean isExtractionAllowed() {
        if (this.getIO() != null) {
            PdfFileReader pdfFileReader = this.getIO().getObjectReader();
            DecryptionFactory decryptionFactory = pdfFileReader.getDecryptionObject();
            return decryptionFactory == null || decryptionFactory.getBooleanValue(103);
        }
        return false;
    }

    @Override
    public final void setEncryptionPassword(String string) throws PdfException {
        if (this.getIO() == null) {
            throw new PdfException("Must open PdfDecoder file first");
        }
        this.getIO().getObjectReader().setPassword(string);
        if (this.getIO() != null) {
            try {
                this.preOpen();
                this.fileAccess.openPdfFile();
                this.postOpen();
            }
            catch (PdfException pdfException) {
                LogWriter.writeLog("Exception " + pdfException + " opening file");
            }
        }
    }

    @Override
    public final void openPdfArray(byte[] byArray, String string) throws PdfException {
        if (byArray == null) {
            throw new RuntimeException("Attempting to open null byte stream");
        }
        this.preOpen();
        if (this.fileAccess.isOpen) {
            this.closePdfFile();
        }
        this.fileAccess.openPdfArray(byArray, string);
        this.postOpen();
    }

    @Override
    public final void openPdfArray(byte[] byArray) throws PdfException {
        if (byArray == null) {
            throw new RuntimeException("Attempting to open null byte stream");
        }
        this.preOpen();
        if (this.fileAccess.isOpen) {
            this.closePdfFile();
        }
        this.fileAccess.openPdfArray(byArray);
        this.postOpen();
    }

    @Override
    public void openPdfFile(String string, Certificate certificate, PrivateKey privateKey) throws PdfException {
        this.fileAccess.setUserEncryption(certificate, privateKey);
        this.openPdfFile(string);
    }

    @Override
    public final void openPdfFileFromStream(Object object, String string) throws PdfException {
        this.preOpen();
        this.fileAccess.openPdfFileFromStream(object, string);
        this.postOpen();
    }

    @Override
    public final void openPdfFile(String string) throws PdfException {
        if (this.fileAccess.isOpen && this.fileAccess.linearParser.linearizedBackgroundReaderer == null) {
            this.closePdfFile();
        }
        this.preOpen();
        this.fileAccess.openPdfFile(string);
        this.postOpen();
    }

    @Override
    public final void openPdfFile(String string, String string2) throws PdfException {
        if (this.fileAccess.isOpen) {
            this.closePdfFile();
        }
        this.preOpen();
        this.fileAccess.openPdfFile(string, string2);
        this.postOpen();
    }

    @Override
    public final boolean openPdfFileFromURL(String string, boolean bl) throws PdfException {
        this.preOpen();
        InputStream inputStream = null;
        String string2 = null;
        try {
            URL uRL = new URL(string);
            string2 = uRL.getPath().substring(uRL.getPath().lastIndexOf(47) + 1);
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            LogWriter.writeLog("Exception: " + iOException.getMessage());
        }
        boolean bl2 = this.fileAccess.readFile(bl, inputStream, string2, null);
        this.postOpen();
        return bl2;
    }

    @Override
    public final boolean openPdfFileFromURL(String string, boolean bl, String string2) throws PdfException {
        InputStream inputStream = null;
        String string3 = null;
        try {
            URL uRL = new URL(string);
            string3 = uRL.getPath().substring(uRL.getPath().lastIndexOf(47) + 1);
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            LogWriter.writeLog("Exception: " + iOException.getMessage());
        }
        this.preOpen();
        boolean bl2 = this.fileAccess.readFile(bl, inputStream, string3, string2);
        this.postOpen();
        return bl2;
    }

    @Override
    public final boolean openPdfFileFromInputStream(InputStream inputStream, boolean bl) throws PdfException {
        String string = "inputstream" + System.currentTimeMillis() + '-' + this.fileAccess.getObjectStore().getKey() + ".pdf";
        this.preOpen();
        boolean bl2 = this.fileAccess.readFile(bl, inputStream, string, null);
        this.postOpen();
        return bl2;
    }

    @Override
    public final boolean openPdfFileFromInputStream(InputStream inputStream, boolean bl, String string) throws PdfException {
        String string2 = "inputstream" + System.currentTimeMillis() + '-' + this.fileAccess.getObjectStore().getKey() + ".pdf";
        this.preOpen();
        boolean bl2 = this.fileAccess.readFile(bl, inputStream, string2, string);
        this.postOpen();
        return bl2;
    }

    private void postOpen() {
        if (this.fileAccess.getPageCount() < 2) {
            this.options.setDisplayView(1);
        } else {
            this.options.setDisplayView(this.options.getPageMode());
        }
        this.formsActionHandler.init(this, this.externalHandlers.getJavaScript(), this.getFormRenderer());
        PluginHandler pluginHandler = (PluginHandler)this.externalHandlers.getExternalHandler(-4);
        if (pluginHandler != null) {
            pluginHandler.setFileName(this.fileAccess.getFilename());
        }
    }

    private void preOpen() {
        this.pages.disableScreen();
        this.pages.stopGeneratingPage();
        this.fileAccess.setDecoding(true);
        if (this.options.getCurrentOffsets() == null) {
            this.options.setCurrentOffsets(new PageOffsets(this.fileAccess.getPageCount(), this.getPdfPageData()));
        }
        this.fileAccess.setDecoding(false);
        this.parser.resetOnOpen();
        Object object = this.externalHandlers.getExternalHandler(6);
        this.externalHandlers.openPdfFile(object);
        AcroRenderer acroRenderer = this.externalHandlers.getFormRenderer();
        this.formsActionHandler = this.userActionHandler != null ? this.userActionHandler : new JavaFXDefaultActionHandler(null);
        acroRenderer.resetHandler(this.formsActionHandler, this.scalingdpi.getDpi(), this.externalHandlers.getJavaScript());
        acroRenderer.getCompData().setRootDisplayComponent(this);
    }

    @Override
    public Object getJPedalObject(int n) {
        return this.parser.getJPedalObject(n);
    }

    @Override
    public void setPageMode(int n) {
        this.options.setPageMode(n);
    }

    @Override
    public boolean isXMLExtraction() {
        return this.options.isXMLExtraction();
    }

    @Override
    public void useTextExtraction() {
        this.options.setXMLExtraction(false);
    }

    @Override
    public void useXMLExtraction() {
        this.options.setXMLExtraction(true);
    }

    public void clearScreen() {
        DynamicVectorRenderer dynamicVectorRenderer = this.fileAccess.getDynamicRenderer();
        dynamicVectorRenderer.flush();
        this.pages.refreshDisplay();
    }

    @Override
    public void setStreamCacheSize(int n) {
        this.fileAccess.setStreamCacheSize(n);
    }

    @Override
    public boolean hasEmbeddedFonts() {
        return this.resultsFromDecode.hasEmbeddedFonts();
    }

    @Override
    public int getPageFromObjectRef(String string) {
        return this.getIO().convertObjectToPageNumber(string);
    }

    @Override
    public String getInfo(int n) {
        return this.parser.getInfo(n);
    }

    @Override
    public AcroRenderer getFormRenderer() {
        return this.externalHandlers.getFormRenderer();
    }

    @Override
    public Javascript getJavaScript() {
        return this.externalHandlers.getJavaScript();
    }

    public static boolean isPageSuccessful() {
        return false;
    }

    @Override
    public String getPageDecodeReport() {
        return this.parser.getPageDecodeReport();
    }

    public static String getPageFailureMessage() {
        return null;
    }

    @Override
    public BufferedImage getSelectedRectangleOnscreen(float f, float f2, float f3, float f4, float f5) {
        return null;
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.fileAccess.getObjectStore();
    }

    @Override
    public void setObjectStore(ObjectStore objectStore) {
        this.fileAccess.setObjectStore(objectStore);
    }

    @Override
    public DecoderOptions getDecoderOptions() {
        return this.options;
    }

    @Override
    public PdfGroupingAlgorithms getGroupingObject() throws PdfException {
        return this.parser.getGroupingObject();
    }

    @Override
    public PdfGroupingAlgorithms getBackgroundGroupingObject() {
        return this.parser.getBackgroundGroupingObject();
    }

    @Override
    public final String getPDFVersion() {
        if (this.getIO() == null) {
            return "";
        }
        return this.getIO().getObjectReader().getType();
    }

    @Override
    public void resetForNonPDFPage(int n) {
        DynamicVectorRenderer dynamicVectorRenderer = this.fileAccess.getDynamicRenderer();
        dynamicVectorRenderer.setHiResImageForDisplayMode(false);
        this.parser.resetFontsInFile();
        this.fileAccess.setPageCount(n);
        AcroRenderer acroRenderer = this.externalHandlers.getFormRenderer();
        if (acroRenderer != null) {
            acroRenderer.removeDisplayComponentsFromScreen();
        }
        this.fileAccess.setPageData(new PdfPageData());
    }

    public boolean hasAllImages() {
        return this.resultsFromDecode.getImagesProcessedFully();
    }

    @Override
    public boolean getPageDecodeStatus(int n) {
        if (DevFlags.testing && n == 4) {
            return false;
        }
        return this.resultsFromDecode.getPageDecodeStatus(n);
    }

    @Override
    public DisplayOffsets getDisplayOffsets() {
        return this.displayOffsets;
    }

    @Override
    public String getPageDecodeStatusReport(int n) {
        return this.resultsFromDecode.getPageDecodeStatusReport(n);
    }

    public void setPrintAutoRotateAndCenter(boolean bl) {
    }

    public void setPrintCurrentView(boolean bl) {
    }

    @Override
    public void addExternalHandler(Object object, int n) {
        switch (n) {
            case 5: {
                this.userActionHandler = (ActionHandler)object;
                break;
            }
            case 26: {
                JavaFXMouseListener.setCustomMouseFunctions((JavaFXMouseFunctionality)object);
                break;
            }
            case 8: {
                this.pages.setThumbnailPanel((GUIThumbnailPanel)object);
                break;
            }
            default: {
                this.externalHandlers.addExternalHandler(object, n);
            }
        }
    }

    @Override
    public Object getExternalHandler(int n) {
        switch (n) {
            case 16: {
                return this.pages;
            }
            case 17: {
                return this.fileAccess.getOffset();
            }
            case 37: {
                return this.displayOffsets;
            }
            case 35: {
                return this.fileAccess;
            }
        }
        return this.externalHandlers.getExternalHandler(n);
    }

    @Override
    public PdfObjectReader getIO() {
        return this.parser.getIO();
    }

    @Override
    public String getFileName() {
        return this.fileAccess.getFilename();
    }

    @Override
    public boolean isForm() {
        return this.res.isForm();
    }

    @Override
    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    @Override
    public TextLines getTextLines() {
        return this.parser.getTextLines();
    }

    @Override
    public final void setInset(int n, int n2) {
        this.options.setInset(n, n2);
        AcroRenderer acroRenderer = this.externalHandlers.getFormRenderer();
        if (acroRenderer != null) {
            acroRenderer.setInsets(n, n2);
        }
    }

    @Override
    public void setUserOffsets(int n, int n2, int n3) {
        this.displayOffsets.setUserOffsets(n, n2, (int)this.getHeight(), n3);
    }

    public Point getUserOffsets(int n) {
        return this.displayOffsets.getUserOffsets(n);
    }

    public final int[] getMaximumSize() {
        int[] nArray = null;
        int n = this.options.getDisplayView();
        if (n != 1) {
            nArray = this.pages.getPageSize(n);
        }
        int n2 = this.options.getInsetW();
        int n3 = this.options.getInsetH();
        if (nArray == null) {
            nArray = this.displayRotation == 90 || this.displayRotation == 270 ? new int[]{this.y_size + n2 + n2, this.x_size + n3 + n3} : new int[]{this.x_size + n2 + n2, this.y_size + n3 + n3};
        }
        if (nArray == null) {
            nArray = this.getMinimumSize();
        }
        return nArray;
    }

    private int[] getMinimumSize() {
        return new int[]{100 + this.options.getInsetW(), 100 + this.options.getInsetH()};
    }

    @Override
    public final void updateCursorBoxOnScreen(java.awt.Rectangle rectangle, Color color) {
        if (this.options.getDisplayView() != 1) {
            return;
        }
        throw new RuntimeException(" updateCursorBoxOnScreen called in PdfDecoderFxm please call updateCursorBoxOnScreenFX instead");
    }

    @Override
    public final void updateCursorBoxOnScreen(int[] nArray, int n) {
        if (this.options.getDisplayView() != 1) {
            return;
        }
        this.pages.updateCursorBoxOnScreen(nArray, n, this.getPageNumber(), this.x_size, this.y_size);
    }

    @Override
    public final int getPDFWidth() {
        int n = this.options.getInsetW();
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            return this.y_size + n + n;
        }
        return this.x_size + n + n;
    }

    @Override
    public final int getPDFHeight() {
        int n = this.options.getInsetH();
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            return this.x_size + n + n;
        }
        return this.y_size + n + n;
    }

    @Override
    public final void setPDFBorder(Border border) {
        this.myBorder = border;
    }

    @Override
    public int getScrollInterval() {
        return this.scrollInterval;
    }

    @Override
    public void setScrollInterval(int n) {
        this.scrollInterval = n;
    }

    @Override
    public int getDisplayView() {
        return this.options.getDisplayView();
    }

    @Override
    public float getScaling() {
        return this.scaling;
    }

    @Override
    public int getInsetH() {
        return this.options.getInsetH();
    }

    @Override
    public int getInsetW() {
        return this.options.getInsetW();
    }

    @Override
    public int getNumberOfPages() {
        return -1;
    }

    @Override
    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return null;
    }

    @Override
    public void setScaling(float f) {
        this.scaling = f;
    }

    @Override
    public int[] getMaxSizeWH() {
        return this.getMaximumSize();
    }

    @Override
    public int[] getPaneBounds() {
        int[] nArray = new int[]{(int)this.getBoundsInLocal().getWidth(), (int)this.getBoundsInLocal().getHeight()};
        return nArray;
    }

    @Override
    public void repaintPane(int n) {
        this.curThumbPage = n;
        Map map = this.parser.getTextLines().getAllHighlights();
        if (map != null) {
            int[][] nArray = (int[][])map.get(n);
            if (nArray != null) {
                highlights = JavaFXPreferences.shiftColorSpaceToFX(color);
                Object[] objectArray = new Rectangle[nArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = new Rectangle((double)nArray[i][0], (double)nArray[i][1], (double)nArray[i][2], (double)nArray[i][3]);
                    objectArray[i].setFill((Paint)highlights);
                    objectArray[i].setOpacity((double)opacity);
                }
                this.highlightsPane.getChildren().clear();
                this.highlightsPane.getChildren().addAll(objectArray);
            }
        } else {
            this.highlightsPane.getChildren().clear();
        }
        this.drawHighlightsForImage();
        this.drawPreviewImage(null, new java.awt.Rectangle((int)this.getBoundsInLocal().getMinX(), (int)this.getBoundsInLocal().getMinY(), (int)this.getBoundsInLocal().getWidth(), (int)this.getBoundsInLocal().getHeight()));
    }

    private void drawHighlightsForImage() {
        int[] nArray = this.pages.getHighlightedImage();
        if (nArray == null) {
            if (this.imageHighlighter != null) {
                this.highlightsPane.getChildren().remove((Object)this.imageHighlighter);
                this.imageHighlighter = null;
            }
        } else if (nArray.length > 0) {
            if (nArray[0] < 0) {
                nArray[0] = 0;
            }
            if (nArray[1] < 0) {
                nArray[1] = 0;
            }
            if (nArray[0] + nArray[2] > this.max_x) {
                nArray[2] = this.max_x - nArray[0];
            }
            if (nArray[1] + nArray[3] > this.max_y) {
                nArray[3] = this.max_y - nArray[1];
            }
            this.imageHighlighter = new Rectangle((double)nArray[0], (double)nArray[1], (double)nArray[2], (double)nArray[3]);
            this.imageHighlighter.setStroke((Paint)javafx.scene.paint.Color.BLACK);
            this.imageHighlighter.setFill((Paint)javafx.scene.paint.Color.rgb((int)0, (int)0, (int)0, (double)0.25));
            this.highlightsPane.getChildren().add((Object)this.imageHighlighter);
        }
    }

    @Override
    public void setBorderPresent(boolean bl) {
        this.isBorderPresent = bl;
    }

    @Override
    public boolean isBorderPresent() {
        return this.isBorderPresent;
    }

    @Override
    public void setPreviewThumbnail(BufferedImage bufferedImage, String string) {
        Group group;
        if (this.previewThumbnail == null) {
            this.previewThumbnail = new Canvas((double)(bufferedImage.getWidth() + 20), (double)(bufferedImage.getHeight() + 40));
        }
        if (!(group = (Group)this.getParent()).getChildren().contains((Object)this.previewThumbnail)) {
            group.getChildren().add((Object)this.previewThumbnail);
        }
        this.previewImage = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
        this.previewText = string;
    }

    @Override
    public int getTextPrint() {
        return this.textPrint;
    }

    @Override
    public java.awt.Rectangle getVisibleRect() {
        return null;
    }

    static {
        String string = System.getProperty("os.name");
        if (string.equals("Mac OS X")) {
            DecoderOptions.isRunningOnMac = true;
        } else if (string.startsWith("Windows")) {
            DecoderOptions.isRunningOnWindows = true;
        } else if (string.startsWith("AIX")) {
            DecoderOptions.isRunningOnAIX = true;
        } else if (string.equals("Linux")) {
            DecoderOptions.isRunningOnLinux = true;
        }
        try {
            DecoderOptions.javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        }
        catch (NumberFormatException numberFormatException) {
            LogWriter.writeLog("Exception: " + numberFormatException.getMessage());
        }
        if (LogWriter.isRunningFromIDE) {
            DevFlags.addShutdownHook();
        }
        color = DecoderOptions.highlightColor.getRGB();
        opacity = DecoderOptions.highlightComposite;
    }
}

