/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import org.jpedal.PdfDecoderInt;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.utils.LogWriter;

public class ThumbnailDecoder {
    private final PdfDecoderInt decode_pdf;

    public ThumbnailDecoder(PdfDecoderInt pdfDecoderInt) {
        this.decode_pdf = pdfDecoderInt;
    }

    public final synchronized BufferedImage getPageAsThumbnail(int n, int n2) {
        BufferedImage bufferedImage = null;
        try {
            AcroRenderer acroRenderer = this.decode_pdf.getFormRenderer();
            boolean bl = acroRenderer.getCompData().formsRasterizedForDisplay();
            acroRenderer.getCompData().setRasterizeForms(true);
            float f = this.decode_pdf.getScaling();
            if (f > 0.5f) {
                this.decode_pdf.setScaling(0.5f);
            }
            BufferedImage bufferedImage2 = this.decode_pdf.getPageAsImage(n);
            if (f > 0.5f) {
                this.decode_pdf.setScaling(f);
            }
            acroRenderer.getCompData().setRasterizeForms(bl);
            int n3 = bufferedImage2.getHeight();
            double d = (double)n2 / (double)n3;
            int n4 = (int)((double)bufferedImage2.getWidth() * d);
            bufferedImage = new BufferedImage(n4, n2, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(bufferedImage2, 0, 0, n4, n2, null);
            graphics.dispose();
        }
        catch (PdfException pdfException) {
            LogWriter.writeLog("Exception: " + pdfException.getMessage());
        }
        return bufferedImage;
    }
}

