/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import org.jpedal.color.DeviceCMYKColorSpace;

public class CMYKtoRGB {
    public static BufferedImage convert(Raster raster, int n, int n2) {
        byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
        return CMYKtoRGB.decode(byArray, n, n2);
    }

    public static BufferedImage convert(byte[] byArray, int n, int n2) {
        return CMYKtoRGB.decode(byArray, n, n2);
    }

    public static BufferedImage decode(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        ColorSpace colorSpace = DeviceCMYKColorSpace.getColorSpaceInstance();
        int n3 = n * n2;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = byArray[n4++] & 0xFF;
            int n6 = byArray[n4++] & 0xFF;
            int n7 = byArray[n4++] & 0xFF;
            int n8 = byArray[n4++] & 0xFF;
            float[] fArray = colorSpace.toRGB(new float[]{(float)n5 / 255.0f, (float)n6 / 255.0f, (float)n7 / 255.0f, (float)n8 / 255.0f});
            int n9 = (int)(fArray[0] * 255.0f);
            int n10 = (int)(fArray[1] * 255.0f);
            int n11 = (int)(fArray[2] * 255.0f);
            nArray[i] = n9 << 16 | n10 << 8 | n11;
        }
        return bufferedImage;
    }
}

