/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class DeviceCMYKColorSpace
extends GenericColorSpace {
    private static final long serialVersionUID = 4054062852632000027L;
    private float lastC = -1.0f;
    private float lastM = -1.0f;
    private float lastY = -1.0f;
    private float lastK = -1.0f;
    public static ColorSpace CMYK;

    @Override
    public void clearCache() {
        this.lastC = -1.0f;
    }

    private void initColorspace() {
        InputStream inputStream = null;
        try {
            String string = System.getProperty("org.jpedal.CMYKprofile");
            if (string == null) {
                inputStream = this.getClass().getResourceAsStream("/org/jpedal/res/cmm/cmyk.icm");
            } else {
                try {
                    inputStream = new FileInputStream(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    try {
                        throw new PdfException("PdfException attempting to use user profile " + string + " Message=" + fileNotFoundException);
                    }
                    catch (PdfException pdfException) {
                        Logger.getLogger(DeviceCMYKColorSpace.class.getName()).log(Level.SEVERE, null, pdfException);
                    }
                }
            }
            ICC_Profile iCC_Profile = ICC_Profile.getInstance(inputStream);
            CMYK = new ICC_ColorSpace(iCC_Profile);
        }
        catch (IOException iOException) {
            LogWriter.writeLog("Exception " + iOException);
            throw new RuntimeException("Problem setting CMYK Colorspace with message " + iOException + " Possible cause file cmyk.icm corrupted");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LogWriter.writeLog("Exception " + iOException);
                }
            }
        }
    }

    public DeviceCMYKColorSpace() {
        this.componentCount = 4;
        if (CMYK == null) {
            this.initColorspace();
        }
        this.cs = CMYK;
        this.setType(1498837125);
    }

    @Override
    public final void setColor(String[] stringArray, int n) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = Float.parseFloat(stringArray[i]);
        }
        this.setColor(fArray, n);
    }

    @Override
    public final void setColor(float[] fArray, int n) {
        this.c = 1.0f;
        this.y = 1.0f;
        this.m = 1.0f;
        this.k = 1.0f;
        if (n > 3) {
            this.c = fArray[0];
            this.m = fArray[1];
            this.y = fArray[2];
            this.k = fArray[3];
        } else {
            if (n > 0) {
                this.c = fArray[0];
            }
            if (n > 1) {
                this.m = fArray[1];
            }
            if (n > 2) {
                this.y = fArray[2];
            }
            if (n > 3) {
                this.k = fArray[3];
            }
        }
        if (this.lastC != this.c || this.lastM != this.m || this.lastY != this.y || this.lastK != this.k) {
            this.rawValues = new float[4];
            this.rawValues[0] = this.c;
            this.rawValues[1] = this.m;
            this.rawValues[2] = this.y;
            this.rawValues[3] = this.k;
            if (this.c == 0.0f && this.y == 0.0f && this.m == 0.0f && this.k == 0.0f) {
                this.currentColor = new PdfColor(1.0f, 1.0f, 1.0f);
            } else if (this.c == 1.0f && this.y == 1.0f && this.m == 1.0f && this.k == 1.0f) {
                this.currentColor = new PdfColor(0.0f, 0.0f, 0.0f);
            } else {
                if ((double)this.c > 0.99) {
                    this.c = 1.0f;
                } else if ((double)this.c < 0.01) {
                    this.c = 0.0f;
                }
                if ((double)this.m > 0.99) {
                    this.m = 1.0f;
                } else if ((double)this.m < 0.01) {
                    this.m = 0.0f;
                }
                if ((double)this.y > 0.99) {
                    this.y = 1.0f;
                } else if ((double)this.y < 0.01) {
                    this.y = 0.0f;
                }
                if ((double)this.k > 0.99) {
                    this.k = 1.0f;
                } else if ((double)this.k < 0.01) {
                    this.k = 0.0f;
                }
                float[] fArray2 = null;
                if (fArray2 == null) {
                    float[] fArray3 = new float[]{this.c, this.m, this.y, this.k};
                    fArray2 = CMYK.toRGB(fArray3);
                    for (int i = 0; i < 3; ++i) {
                        if ((double)fArray2[i] > 0.99) {
                            fArray2[i] = 1.0f;
                            continue;
                        }
                        if (!((double)fArray2[i] < 0.01)) continue;
                        fArray2[i] = 0.0f;
                    }
                }
                this.currentColor = new PdfColor((float)fArray2[0], (float)fArray2[1], (float)fArray2[2]);
            }
            this.lastC = this.c;
            this.lastM = this.m;
            this.lastY = this.y;
            this.lastK = this.k;
        }
    }

    @Override
    public final BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, boolean bl, PdfObject pdfObject) {
        return this.nonRGBJPEGToRGBImage(byArray, n, n2, fArray, n3, n4);
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = n * n2 * 4;
        int n4 = byArray.length;
        if (n3 > n4) {
            n3 = n4 - 3;
        }
        ColorSpace colorSpace = DeviceCMYKColorSpace.getColorSpaceInstance();
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        byte[] byArray2 = new byte[n * n2 * 3];
        int n9 = 0;
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
        for (int i = 0; i < n3; i += 4) {
            int n10 = byArray[i] & 0xFF;
            int n11 = byArray[i + 1] & 0xFF;
            int n12 = byArray[i + 2] & 0xFF;
            int n13 = byArray[i + 3] & 0xFF;
            if (n10 != n5 || n11 != n6 || n12 != n7 || n13 != n8) {
                if (n10 == 0 && n11 == 0 && n12 == 0 && n13 == 0) {
                    fArray = new float[]{1.0f, 1.0f, 1.0f};
                } else if (n10 == 255 && n11 == 255 && n12 == 255 && n13 == 255) {
                    fArray = new float[]{0.0f, 0.0f, 0.0f};
                } else {
                    fArray = colorSpace.toRGB(new float[]{(float)n10 / 255.0f, (float)n11 / 255.0f, (float)n12 / 255.0f, (float)n13 / 255.0f});
                    n5 = n10;
                    n6 = n11;
                    n7 = n12;
                    n8 = n13;
                }
            }
            byArray2[n9] = (byte)(fArray[0] * 255.0f);
            byArray2[n9 + 1] = (byte)(fArray[1] * 255.0f);
            byArray2[n9 + 2] = (byte)(fArray[2] * 255.0f);
            n9 += 3;
        }
        return byArray2;
    }

    @Override
    public BufferedImage JPEG2000ToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, int n5) throws PdfException {
        BufferedImage bufferedImage = DefaultImageHelper.JPEG2000ToRGBImage(byArray, n, n2, fArray, n3, n4);
        if (bufferedImage != null) {
            return bufferedImage;
        }
        return this.JPEG2000ToImage(byArray, n3, n4, fArray);
    }

    @Override
    public final byte[] convertIndexToRGB(byte[] byArray) {
        this.isConverted = true;
        return this.convert4Index(byArray);
    }

    public static ColorSpace getColorSpaceInstance() {
        ColorSpace colorSpace = new DeviceCMYKColorSpace().getColorSpace();
        String string = System.getProperty("org.jpedal.CMYKprofile");
        if (string != null) {
            try {
                colorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(new FileInputStream(string)));
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to create CMYK colorspace with  " + string + "\nPlease check Path and file valid or use built-in " + iOException);
            }
        }
        return colorSpace;
    }
}

