/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class JPEGDecoder {
    static BufferedImage JPEGToRGBImageFromLUV(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage;
        try {
            Raster raster = DefaultImageHelper.readRasterFromJPeg(byArray);
            if (raster == null) {
                return null;
            }
            raster = GenericColorSpace.cleanupRaster(raster, n, n2, 3);
            int n3 = raster.getWidth();
            int n4 = raster.getHeight();
            int n5 = n3 * n4;
            byte[] byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = -1.0f;
            float f5 = -1.0f;
            float f6 = -1.0f;
            for (int i = 0; i < n5 * 3; i += 3) {
                float f7 = byArray2[i] & 0xFF;
                float f8 = byArray2[i + 1] & 0xFF;
                float f9 = byArray2[i + 2] & 0xFF;
                if (f7 != f4 || f8 != f5 || f9 != f6) {
                    f = f7 + 1.402f * (f9 - 128.0f);
                    if (f < 0.0f) {
                        f = 0.0f;
                    } else if (f > 255.0f) {
                        f = 255.0f;
                    }
                    f2 = f7 - 0.344f * (f8 - 128.0f) - 0.714f * (f9 - 128.0f);
                    if (f2 < 0.0f) {
                        f2 = 0.0f;
                    } else if (f2 > 255.0f) {
                        f2 = 255.0f;
                    }
                    f3 = f7 + 1.772f * (f8 - 128.0f);
                    if (f3 < 0.0f) {
                        f3 = 0.0f;
                    } else if (f3 > 255.0f) {
                        f3 = 255.0f;
                    }
                    f4 = f7;
                    f5 = f8;
                    f6 = f9;
                }
                byArray2[i] = (byte)f;
                byArray2[i + 1] = (byte)f2;
                byArray2[i + 2] = (byte)f3;
            }
            DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
            int[] nArray = new int[]{0, 1, 2};
            bufferedImage = new BufferedImage(n3, n4, 1);
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n3, n4, n3 * 3, 3, nArray, null);
            bufferedImage.setData(writableRaster);
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
        }
        return bufferedImage;
    }

    public static void write(BufferedImage bufferedImage, String string, String string2) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string2)));
            ImageIO.write((RenderedImage)bufferedImage, string, bufferedOutputStream);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            LogWriter.writeLog("Exception: " + iOException.getMessage());
        }
    }

    public static void write(BufferedImage bufferedImage, String string, OutputStream outputStream) {
        try {
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            LogWriter.writeLog("Exception: " + iOException.getMessage());
        }
    }

    public static Raster getRasterFromJPEG(byte[] byArray, String string) {
        ImageReader imageReader = null;
        Raster raster = null;
        try {
            ImageReader imageReader2;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
            while (iterator.hasNext() && !(imageReader = (imageReader2 = iterator.next())).canReadRaster()) {
            }
            ImageIO.setUseCache(false);
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
            imageReader.setInput(imageInputStream, true);
            raster = imageReader.readRaster(0, null);
            byteArrayInputStream.close();
            imageReader.dispose();
            imageInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Problem closing  " + exception);
        }
        return raster;
    }

    static BufferedImage grayJPEGToRGBImage(byte[] byArray, int n, int n2, boolean bl) {
        BufferedImage bufferedImage = null;
        try {
            Raster raster = JPEGDecoder.getRasterFromJPEG(byArray, "JPEG");
            if (raster != null) {
                raster = GenericColorSpace.cleanupRaster(raster, n, n2, 1);
                int n3 = raster.getWidth();
                int n4 = raster.getHeight();
                DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
                byte[] byArray2 = dataBufferByte.getData();
                int n5 = byArray2.length;
                byte[] byArray3 = new byte[n5 * 3];
                int n6 = 0;
                for (int i = 0; i < n5; ++i) {
                    if (bl) {
                        byArray2[i] = (byte)(byArray2[i] ^ 0xFF);
                    }
                    byArray3[n6] = byArray2[i];
                    byArray3[++n6] = byArray2[i];
                    byArray3[++n6] = byArray2[i];
                    ++n6;
                }
                int[] nArray = new int[]{0, 1, 2};
                bufferedImage = new BufferedImage(n3, n4, 1);
                WritableRaster writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray3, byArray3.length), n3, n4, n3 * 3, 3, nArray, null);
                bufferedImage.setData(writableRaster);
            }
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
        }
        return bufferedImage;
    }

    public static byte[] getBytesFromJPEG(byte[] byArray, GenericColorSpace genericColorSpace, PdfObject pdfObject) {
        byte[] byArray2;
        block7: {
            byArray2 = null;
            Raster raster = null;
            try {
                BufferedImage bufferedImage = genericColorSpace.JPEGToRGBImage(byArray, pdfObject.getInt(959726687), pdfObject.getInt(959926393), null, -1, -1, false, pdfObject);
                if (bufferedImage.getType() == 1) {
                    if ((bufferedImage = ColorSpaceConvertor.convertColorspace(bufferedImage, 5)) != null) {
                        raster = bufferedImage.getData();
                    }
                    byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
                    for (int i = 0; i < byArray2.length; i += 3) {
                        byte by;
                        byte by2 = byArray2[i];
                        byte by3 = byArray2[i + 1];
                        byArray2[i] = by = byArray2[i + 2];
                        byArray2[i + 1] = by3;
                        byArray2[i + 2] = by2;
                    }
                } else {
                    if (bufferedImage != null) {
                        raster = bufferedImage.getData();
                    }
                    byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block7;
                LogWriter.writeLog("Exception with JPeg Image ");
            }
        }
        return byArray2;
    }
}

