/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import com.idrsolutions.pdf.color.shading.ShadedPaint;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PatternDisplay;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.color.ShearedTexturePaint;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PatternObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoderForPattern;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.RenderUtils;
import org.jpedal.utils.LogWriter;

public class PatternColorSpace
extends GenericColorSpace {
    boolean newFlag;
    private final PdfObjectReader currentPdfFile;
    private boolean colorsReversed;
    BufferedImage patternImage;
    PatternObject PatternObj;
    final GenericColorSpace patternColorSpace;
    float[][] matrix;
    PdfPaint strokCol;
    private BufferedImage fullImage;

    public PatternColorSpace(PdfObjectReader pdfObjectReader, GenericColorSpace genericColorSpace) {
        this.setType(1146450818);
        this.currentPdfFile = pdfObjectReader;
        this.patternColorSpace = genericColorSpace;
        this.currentColor = new PdfColor(1.0f, 1.0f, 1.0f);
    }

    @Override
    public void setColor(String[] stringArray, int n) {
        if (this.patternColorSpace != null) {
            int n2 = stringArray.length - 1;
            String[] stringArray2 = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray2[i] = stringArray[n2 - i];
            }
            this.patternColorSpace.setColor(stringArray2, n2);
            this.strokCol = this.patternColorSpace.getColor();
        }
        this.PatternObj = (PatternObject)this.patterns.get(stringArray[0]);
        this.currentPdfFile.checkResolved(this.PatternObj);
        byte[] byArray = this.currentPdfFile.readStream(this.PatternObj, true, true, true, false, false, this.PatternObj.getCacheName(this.currentPdfFile.getObjectReader()));
        int n3 = this.PatternObj.getInt(1755231159);
        float[] fArray = this.PatternObj.getFloatArray(1145198201);
        if (fArray != null) {
            if (n3 == 1) {
                float[][] fArrayArray = new float[][]{{fArray[0], fArray[1], 0.0f}, {fArray[2], fArray[3], 0.0f}, {0.0f, 0.0f, 1.0f}};
                if (!this.newFlag && fArray[5] < 0.0f) {
                    fArray[4] = 0.0f;
                    fArray[5] = 0.0f;
                }
                this.matrix = fArrayArray;
            } else {
                float[][] fArrayArray = new float[][]{{fArray[0], fArray[1], 0.0f}, {fArray[2], fArray[3], 0.0f}, {fArray[4], fArray[5], 1.0f}};
                this.colorsReversed = fArrayArray[2][0] < 0.0f;
                this.matrix = fArrayArray;
            }
        }
        if (!this.newFlag) {
            if (n3 == 1) {
                this.currentColor = this.setupTilingNew(this.PatternObj, byArray);
            } else if (n3 == 2) {
                this.currentColor = this.setupShading(this.PatternObj, this.matrix);
            }
        }
    }

    public BufferedImage getImageForPatternedShape(GraphicsState graphicsState) {
        BufferedImage bufferedImage;
        boolean bl;
        Object object = graphicsState.CTM;
        AffineTransform affineTransform = new AffineTransform(object[0][0], object[0][1], object[1][0], object[1][1], object[2][0], object[2][1]);
        this.currentPdfFile.checkResolved(this.PatternObj);
        byte[] byArray = this.currentPdfFile.readStream(this.PatternObj, true, true, true, false, false, this.PatternObj.getCacheName(this.currentPdfFile.getObjectReader()));
        int n = this.PatternObj.getInt(1755231159);
        if (n != 1) {
            return null;
        }
        AffineTransform affineTransform2 = new AffineTransform();
        float[] fArray = this.PatternObj.getFloatArray(1145198201);
        if (fArray != null) {
            object = new float[][]{{fArray[0], fArray[1], 0.0f}, {fArray[2], fArray[3], 0.0f}, {fArray[4], fArray[5], 1.0f}};
            affineTransform2 = new AffineTransform(object[0][0], object[0][1], object[1][0], object[1][1], object[2][0], object[2][1]);
        }
        affineTransform2.concatenate(affineTransform);
        object = PatternColorSpace.getMatrix(affineTransform2);
        boolean bl2 = bl = affineTransform2.getShearX() != 0.0 || affineTransform2.getShearY() != 0.0;
        if (bl) {
            affineTransform2 = new AffineTransform();
            object = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        }
        float[] fArray2 = this.PatternObj.getFloatArray(303185736);
        float f = Math.abs(fArray2[2] - fArray2[0]);
        float f2 = Math.abs(fArray2[1] - fArray2[3]);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray2[0], fArray2[1]);
        generalPath.lineTo(fArray2[2], fArray2[1]);
        generalPath.lineTo(fArray2[2], fArray2[3]);
        generalPath.lineTo(fArray2[0], fArray2[3]);
        generalPath.lineTo(fArray2[0], fArray2[1]);
        generalPath.closePath();
        Shape shape = generalPath.createTransformedShape(affineTransform2);
        Rectangle2D rectangle2D = shape.getBounds2D();
        float f3 = this.PatternObj.getFloatNumber(591672680);
        f3 = f3 < -30000.0f ? 0.0f : f3;
        float f4 = this.PatternObj.getFloatNumber(591672681);
        f4 = f4 < -30000.0f ? 0.0f : f4;
        float[] fArray3 = new float[4];
        fArray3[2] = f3 < 0.0f ? f - f3 : f3;
        fArray3[3] = f4 < 0.0f ? f2 - f4 : f4;
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(fArray3[0], fArray3[1]);
        generalPath2.lineTo(fArray3[2], fArray3[1]);
        generalPath2.lineTo(fArray3[2], fArray3[3]);
        generalPath2.lineTo(fArray3[0], fArray3[3]);
        generalPath2.lineTo(fArray3[0], fArray3[1]);
        generalPath2.closePath();
        Shape shape2 = generalPath2.createTransformedShape(affineTransform2);
        Rectangle2D rectangle2D2 = shape2.getBounds2D();
        double d = Math.abs(rectangle2D2.getX()) + rectangle2D2.getWidth() - Math.abs(rectangle2D.getX());
        double d2 = Math.abs(rectangle2D2.getY()) + rectangle2D2.getHeight() - Math.abs(rectangle2D.getY());
        d = f3 == 0.0f ? rectangle2D.getWidth() : d;
        d2 = f4 == 0.0f ? rectangle2D.getWidth() : d2;
        d = d > 3000.0 ? 1500.0 : d;
        d2 = d2 > 3000.0 ? 1500.0 : d2;
        int n2 = (int)d;
        n2 = n2 < 1 ? 1 : n2;
        int n3 = (int)d2;
        int n4 = n3 = n3 < 1 ? 1 : n3;
        if (d2 < 1.0 && d < 2.5) {
            n2 = 1;
        }
        ObjectStore objectStore = new ObjectStore();
        if (affineTransform2.getScaleX() < 0.0 || affineTransform2.getScaleY() < 0.0) {
            DynamicVectorRenderer dynamicVectorRenderer = this.decodePatternContent(this.PatternObj, (float[][])object, byArray, objectStore);
            bufferedImage = new BufferedImage(n2, n3, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            dynamicVectorRenderer.setG2(graphics2D);
            AffineTransform affineTransform3 = new AffineTransform();
            affineTransform3.setToTranslation(-rectangle2D.getX(), -rectangle2D.getY());
            dynamicVectorRenderer.paint(null, affineTransform3, null);
        } else {
            DynamicVectorRenderer dynamicVectorRenderer = this.decodePatternContent(this.PatternObj, null, byArray, objectStore);
            double[] dArray = new double[6];
            affineTransform2.getMatrix(dArray);
            dArray[4] = dArray[4] - rectangle2D.getX();
            dArray[5] = dArray[5] - rectangle2D.getY();
            AffineTransform affineTransform4 = new AffineTransform(dArray);
            bufferedImage = new BufferedImage(n2, n3, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            dynamicVectorRenderer.setG2(graphics2D);
            dynamicVectorRenderer.paint(null, affineTransform4, null);
        }
        return bufferedImage;
    }

    private static float[][] getMatrix(AffineTransform affineTransform) {
        return new float[][]{{(float)affineTransform.getScaleX(), (float)affineTransform.getShearX(), 0.0f}, {(float)affineTransform.getShearY(), (float)affineTransform.getScaleY(), 0.0f}, {(float)affineTransform.getTranslateX(), (float)affineTransform.getTranslateY(), 1.0f}};
    }

    public BufferedImage getRawImage(int n, int n2, AffineTransform affineTransform) {
        byte[] byArray = this.currentPdfFile.readStream(this.PatternObj, true, true, true, false, false, this.PatternObj.getCacheName(this.currentPdfFile.getObjectReader()));
        ObjectStore objectStore = new ObjectStore();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.concatenate(affineTransform);
        DynamicVectorRenderer dynamicVectorRenderer = this.decodePatternContent(this.PatternObj, PatternColorSpace.getMatrix(affineTransform2), byArray, objectStore);
        return dynamicVectorRenderer.getSingleImagePattern();
    }

    private PdfPaint setupTilingNew(PdfObject pdfObject, byte[] byArray) {
        boolean bl;
        float[][] fArrayArray;
        AffineTransform affineTransform = new AffineTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        float[] fArray = pdfObject.getFloatArray(1145198201);
        if (fArray != null) {
            fArrayArray = new float[][]{{fArray[0], fArray[1], 0.0f}, {fArray[2], fArray[3], 0.0f}, {fArray[4], fArray[5], 1.0f}};
            affineTransform = new AffineTransform(fArrayArray[0][0], fArrayArray[0][1], fArrayArray[1][0], fArrayArray[1][1], fArrayArray[2][0], fArrayArray[2][1]);
        } else {
            fArrayArray = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        }
        ObjectStore objectStore = new ObjectStore();
        boolean bl2 = bl = affineTransform.getShearX() != 0.0 || affineTransform.getShearY() != 0.0;
        if (bl) {
            affineTransform2 = affineTransform;
            affineTransform = new AffineTransform();
            fArrayArray = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        }
        float[] fArray2 = pdfObject.getFloatArray(303185736);
        float f = Math.abs(fArray2[2] - fArray2[0]);
        float f2 = Math.abs(fArray2[1] - fArray2[3]);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray2[0], fArray2[1]);
        generalPath.lineTo(fArray2[2], fArray2[1]);
        generalPath.lineTo(fArray2[2], fArray2[3]);
        generalPath.lineTo(fArray2[0], fArray2[3]);
        generalPath.lineTo(fArray2[0], fArray2[1]);
        generalPath.closePath();
        Shape shape = generalPath.createTransformedShape(affineTransform);
        Rectangle2D rectangle2D = shape.getBounds2D();
        float f3 = pdfObject.getFloatNumber(591672680);
        f3 = f3 < -30000.0f ? 0.0f : f3;
        float f4 = pdfObject.getFloatNumber(591672681);
        f4 = f4 < -30000.0f ? 0.0f : f4;
        float[] fArray3 = new float[4];
        fArray3[2] = f3 < 0.0f ? f - f3 : f3;
        fArray3[3] = f4 < 0.0f ? f2 - f4 : f4;
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(fArray3[0], fArray3[1]);
        generalPath2.lineTo(fArray3[2], fArray3[1]);
        generalPath2.lineTo(fArray3[2], fArray3[3]);
        generalPath2.lineTo(fArray3[0], fArray3[3]);
        generalPath2.lineTo(fArray3[0], fArray3[1]);
        generalPath2.closePath();
        Shape shape2 = generalPath2.createTransformedShape(affineTransform);
        Rectangle2D rectangle2D2 = shape2.getBounds2D();
        double d = Math.abs(rectangle2D2.getX()) + rectangle2D2.getWidth() - Math.abs(rectangle2D.getX());
        double d2 = Math.abs(rectangle2D2.getY()) + rectangle2D2.getHeight() - Math.abs(rectangle2D.getY());
        d = f3 == 0.0f ? rectangle2D.getWidth() : d;
        d2 = f4 == 0.0f ? rectangle2D.getWidth() : d2;
        d = d > 3000.0 ? 3000.0 : d;
        d2 = d2 > 3000.0 ? 3000.0 : d2;
        int n = (int)d;
        n = n < 1 ? 1 : n;
        int n2 = (int)d2;
        int n3 = n2 = n2 < 1 ? 1 : n2;
        if (d2 < 1.0 && d < 2.5) {
            n = 1;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), d, d2);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        if (bl) {
            DynamicVectorRenderer dynamicVectorRenderer = this.decodePatternContent(pdfObject, null, byArray, objectStore);
            BufferedImage bufferedImage2 = dynamicVectorRenderer.getSingleImagePattern();
            if (bufferedImage2 != null) {
                bufferedImage2 = RenderUtils.invertImage(bufferedImage2);
                return new ShearedTexturePaint(bufferedImage2, double_, affineTransform2);
            }
            fArrayArray[2][0] = (float)((double)fArrayArray[2][0] - rectangle2D.getX());
            fArrayArray[2][1] = (float)((double)fArrayArray[2][1] - rectangle2D.getY());
            dynamicVectorRenderer = this.decodePatternContent(pdfObject, fArrayArray, byArray, objectStore);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            dynamicVectorRenderer.setG2(graphics2D);
            dynamicVectorRenderer.paint(null, null, null);
            return new ShearedTexturePaint(bufferedImage, double_, affineTransform2);
        }
        fArrayArray[2][0] = (float)((double)fArrayArray[2][0] - rectangle2D.getX());
        fArrayArray[2][1] = (float)((double)fArrayArray[2][1] - rectangle2D.getY());
        DynamicVectorRenderer dynamicVectorRenderer = this.decodePatternContent(pdfObject, fArrayArray, byArray, objectStore);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        dynamicVectorRenderer.setG2(graphics2D);
        dynamicVectorRenderer.paint(null, null, null);
        return new ShearedTexturePaint(bufferedImage, double_, affineTransform2);
    }

    private DynamicVectorRenderer decodePatternContent(PdfObject pdfObject, float[][] fArray, byte[] byArray, ObjectStore objectStore) {
        PdfObject pdfObject2 = pdfObject.getDictionary(2004251818);
        PdfStreamDecoderForPattern pdfStreamDecoderForPattern = new PdfStreamDecoderForPattern(this.currentPdfFile);
        pdfStreamDecoderForPattern.setParameters(false, true, 7, 0, false, false);
        pdfStreamDecoderForPattern.setObjectValue(-8, objectStore);
        PatternDisplay patternDisplay = new PatternDisplay(0, false, 20, objectStore);
        patternDisplay.setHiResImageForDisplayMode(true);
        try {
            pdfStreamDecoderForPattern.setRenderer(patternDisplay);
            if (pdfObject2 != null) {
                pdfStreamDecoderForPattern.readResources(pdfObject2, true);
            }
            GraphicsState graphicsState = new GraphicsState(0, 0);
            pdfStreamDecoderForPattern.setGS(graphicsState);
            if (fArray != null) {
                graphicsState.CTM = fArray;
            }
            if (this.strokCol == null) {
                pdfStreamDecoderForPattern.setDefaultColors(this.gs.getStrokeColor(), this.gs.getNonstrokeColor());
            } else {
                pdfStreamDecoderForPattern.setDefaultColors(this.strokCol, new PdfColor(0, 255, 0));
            }
            pdfStreamDecoderForPattern.decodePageContent(graphicsState, byArray);
        }
        catch (PdfException pdfException) {
            LogWriter.writeLog("Exception: " + pdfException.getMessage());
        }
        return patternDisplay;
    }

    private PdfPaint setupShading(PdfObject pdfObject, float[][] fArray) {
        PdfObject pdfObject2 = pdfObject.getDictionary(878474856);
        PdfObject pdfObject3 = pdfObject2.getDictionary(2087749783);
        GenericColorSpace genericColorSpace = ColorspaceFactory.getColorSpaceInstance(this.currentPdfFile, pdfObject3);
        if (genericColorSpace.getID() == 1247168582 && pdfObject3.getParameterConstant(2054519176) == 1498837125) {
            genericColorSpace = new DeviceCMYKColorSpace();
        }
        return new ShadedPaint(pdfObject2, this.isPrinting, genericColorSpace, this.currentPdfFile, fArray, this.colorsReversed);
    }
}

