/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display;

import org.jpedal.display.GUIDisplay;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;

public class MultiDisplayOptions {
    private boolean turnoverOn = GUIDisplay.default_turnoverOn;
    private boolean separateCover = GUIDisplay.default_separateCover;
    private int[] xReached;
    private int[] yReached;
    private int[] pageW;
    private int[] pageH;
    private boolean isGeneratingOtherPages;
    private boolean running;
    private int startViewPage = 1;
    private int endViewPage;
    private int pageNumber;
    private final PdfPageData pageData = new PdfPageData();

    public boolean isTurnoverOn() {
        return this.turnoverOn;
    }

    public void setTurnoverOn(boolean bl) {
        this.turnoverOn = bl;
    }

    public boolean isSeparateCover() {
        return this.separateCover;
    }

    public void setSeparateCover(boolean bl) {
        this.separateCover = bl;
    }

    void resetValues(int n) {
        this.setxReached(new int[n + 1]);
        this.setyReached(new int[n + 1]);
        this.setPageW(new int[n + 1]);
        this.setPageH(new int[n + 1]);
    }

    public void setReachedToNull() {
        this.setxReached(null);
    }

    public void setPageValuesToNull() {
        this.setPageH(null);
        this.setPageW(null);
    }

    public int[] getPageH() {
        return this.pageH;
    }

    public int getPageH(int n) {
        return this.pageH[n];
    }

    public void setPageH(int[] nArray) {
        this.pageH = nArray;
    }

    public int[] getPageW() {
        return this.pageW;
    }

    public int getPageW(int n) {
        return this.pageW[n];
    }

    public void setPageW(int[] nArray) {
        this.pageW = nArray;
    }

    public int[] getyReached() {
        return this.yReached;
    }

    public int getyReached(int n) {
        return this.yReached[n];
    }

    public void setyReached(int[] nArray) {
        this.yReached = nArray;
    }

    public int[] getxReached() {
        return this.xReached;
    }

    public int getxReached(int n) {
        return this.xReached[n];
    }

    public void setxReached(int[] nArray) {
        this.xReached = nArray;
    }

    public boolean isIsGeneratingOtherPages() {
        return this.isGeneratingOtherPages;
    }

    public void setIsGeneratingOtherPages(boolean bl) {
        this.isGeneratingOtherPages = bl;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean bl) {
        this.running = bl;
    }

    public int getStartViewPage() {
        return this.startViewPage;
    }

    public void setStartViewPage(int n) {
        this.startViewPage = n;
    }

    public int getEndViewPage() {
        return this.endViewPage;
    }

    public void setEndViewPage(int n) {
        this.endViewPage = n;
    }

    public void calcDisplayRangeForFacing() {
        int n = this.pageData.getPageCount();
        if (this.separateCover) {
            if (n == 2) {
                this.startViewPage = 1;
                this.endViewPage = 2;
            } else {
                this.startViewPage = this.pageNumber;
                if (this.startViewPage == 1) {
                    this.endViewPage = 1;
                } else if ((this.startViewPage & 1) != 1) {
                    this.startViewPage = this.pageNumber;
                    this.endViewPage = this.pageNumber + 1;
                } else {
                    this.startViewPage = this.pageNumber - 1;
                    this.endViewPage = this.pageNumber;
                }
            }
        } else {
            this.startViewPage = this.pageNumber - (1 - (this.pageNumber & 1));
            this.endViewPage = this.startViewPage + 1;
        }
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int n) {
        this.pageNumber = n;
    }

    public void waitToDieThred() {
        while (this.running) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                LogWriter.writeLog("Exception: " + interruptedException.getMessage());
            }
        }
    }
}

