/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Semaphore;
import org.jpedal.FileAccess;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.DisplayOffsets;
import org.jpedal.display.GUIModes;
import org.jpedal.display.MultiDisplayOptions;
import org.jpedal.display.MultiPagesDisplay;
import org.jpedal.external.RenderChangeListener;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.text.TextLines;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public abstract class MultiPageDecoder {
    private final Semaphore semaphore = new Semaphore(1);
    final GUIFactory gui;
    private Thread worker;
    public final Map currentPageViews = new HashMap();
    private final FileAccess fileAccess;
    private final PdfObjectReader currentPdfFile;
    private final AcroRenderer formRenderer;
    private int displayView;
    private Map cachedPageViews = new WeakHashMap();
    private final MultiPagesDisplay display;
    private RenderChangeListener customRenderChangeListener;
    private final BufferedImage[] facingDragCachedImages = new BufferedImage[4];
    private BufferedImage facingDragTempLeftImg;
    private BufferedImage facingDragTempRightImg;
    private int facingDragTempLeftNo;
    private int facingDragTempRightNo;
    private final MultiDisplayOptions multiDisplayOptions;
    public final PdfDecoderInt pdf;
    private final PdfPageData pageData;
    final DecoderOptions options;
    final DisplayOffsets offsets;

    public MultiPageDecoder(GUIFactory gUIFactory, PdfDecoderInt pdfDecoderInt, PdfPageData pdfPageData, MultiPagesDisplay multiPagesDisplay, MultiDisplayOptions multiDisplayOptions, DynamicVectorRenderer dynamicVectorRenderer, int n, FileAccess fileAccess, PdfObjectReader pdfObjectReader, AcroRenderer acroRenderer, DecoderOptions decoderOptions) {
        this.gui = gUIFactory;
        this.pdf = pdfDecoderInt;
        this.pageData = pdfPageData;
        this.display = multiPagesDisplay;
        this.multiDisplayOptions = multiDisplayOptions;
        this.fileAccess = fileAccess;
        this.currentPdfFile = pdfObjectReader;
        this.formRenderer = acroRenderer;
        this.options = decoderOptions;
        this.offsets = (DisplayOffsets)pdfDecoderInt.getExternalHandler(37);
        if (dynamicVectorRenderer != null) {
            this.currentPageViews.put(n, dynamicVectorRenderer);
        }
    }

    public void decodeOtherPages(int n, int n2, int n3, PdfDecoderInt pdfDecoderInt) {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            LogWriter.writeLog("Exception: " + interruptedException.getMessage());
        }
        this.displayView = n3;
        if (n < 1) {
            n = 1;
        }
        int n4 = this.multiDisplayOptions.getPageNumber();
        this.multiDisplayOptions.setPageNumber(n);
        if (n3 == 4 && this.multiDisplayOptions.isTurnoverOn()) {
            int n5 = this.multiDisplayOptions.isSeparateCover() ? n4 / 2 * 2 : n4 - (1 - (n4 & 1));
            if (this.offsets.getDragLeft()) {
                this.facingDragTempLeftImg = this.facingDragCachedImages[0];
                this.facingDragTempLeftNo = n5 - 2;
                this.facingDragTempRightImg = this.facingDragCachedImages[1];
                this.facingDragTempRightNo = n5 - 1;
            } else {
                this.facingDragTempLeftImg = this.facingDragCachedImages[2];
                this.facingDragTempLeftNo = n5 + 2;
                this.facingDragTempRightImg = this.facingDragCachedImages[3];
                this.facingDragTempRightNo = n5 + 3;
            }
        }
        this.facingDragCachedImages[0] = null;
        this.facingDragCachedImages[1] = null;
        this.facingDragCachedImages[2] = null;
        this.facingDragCachedImages[3] = null;
        this.calcDisplayedRange();
        while (this.multiDisplayOptions.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                LogWriter.writeLog("Exception: " + interruptedException.getMessage());
            }
        }
        if (this.worker != null && this.worker.getState() == Thread.State.TERMINATED) {
            this.worker = null;
        }
        if (!(this.worker != null && this.worker.getState() != Thread.State.NEW || this.worker != null && this.multiDisplayOptions.isRunning())) {
            this.multiDisplayOptions.setRunning(true);
            this.worker = new Thread(){

                @Override
                public void run() {
                    try {
                        MultiPageDecoder.this.decodeOtherPages();
                        MultiPageDecoder.this.multiDisplayOptions.setRunning(false);
                        if (MultiPageDecoder.this.customRenderChangeListener != null) {
                            MultiPageDecoder.this.customRenderChangeListener.renderingWorkerFinished();
                        }
                    }
                    catch (Exception exception) {
                        MultiPageDecoder.this.multiDisplayOptions.setRunning(false);
                        LogWriter.writeLog("Exception: " + exception.getMessage());
                    }
                    catch (Error error) {
                        MultiPageDecoder.this.multiDisplayOptions.setRunning(false);
                        LogWriter.writeLog("Error: " + error.getMessage());
                    }
                    finally {
                        MultiPageDecoder.this.semaphore.release();
                    }
                }
            };
            this.worker.setDaemon(true);
            this.worker.start();
        }
    }

    void decodeOtherPages() {
        int n = this.pageData.getPageCount();
        this.multiDisplayOptions.setIsGeneratingOtherPages(true);
        int n2 = this.multiDisplayOptions.getStartViewPage();
        int n3 = this.multiDisplayOptions.getStartViewPage();
        int n4 = this.multiDisplayOptions.getEndViewPage() + 1;
        int n5 = 1;
        int n6 = 1;
        if (this.multiDisplayOptions.isTurnoverOn() && this.displayView == 4) {
            n5 = n3 - 2;
            n6 = n5 + 6;
            if (n5 < 1) {
                n5 = 1;
            }
            if (n6 > n + 1) {
                n6 = n + 1;
            }
        }
        int n7 = n6 - n5;
        this.resetPageCaches(this.multiDisplayOptions.getStartViewPage(), this.multiDisplayOptions.getEndViewPage() + 1);
        while (this.multiDisplayOptions.isIsGeneratingOtherPages()) {
            if (n3 != this.multiDisplayOptions.getStartViewPage() && n4 != this.multiDisplayOptions.getEndViewPage()) {
                n2 = this.multiDisplayOptions.getStartViewPage();
                n4 = this.multiDisplayOptions.getEndViewPage() + 1;
                if (n2 == 0) {
                    // empty if block
                }
                n3 = ++n2;
                if (this.multiDisplayOptions.isTurnoverOn() && this.displayView == 4) {
                    n5 = n3 - 2;
                    n6 = n5 + 6;
                    if (n5 < 1) {
                        n5 = 1;
                    }
                    if (n6 > n + 1) {
                        n6 = n + 1;
                    }
                    n7 = n6 - n5;
                }
                this.resetPageCaches(n3, n4);
            }
            if (this.multiDisplayOptions.isTurnoverOn() && this.displayView == 4 && n7 == 0 || (!this.multiDisplayOptions.isTurnoverOn() || this.displayView != 4) && n2 == n4 || n3 > n4) break;
            if (n2 > 0 && n2 < this.pdf.getPageCount() + 1) {
                this.decodeMorePages(n2, n3, n4);
            }
            if (this.displayView == 4 && this.multiDisplayOptions.isTurnoverOn()) {
                int n8;
                int n9 = this.multiDisplayOptions.getPageNumber();
                if (this.multiDisplayOptions.isSeparateCover() && (n9 & 1) == 1) {
                    --n9;
                }
                if (!this.multiDisplayOptions.isSeparateCover() && (n9 & 1) == 0) {
                    --n9;
                }
                if ((n8 = n2 - n9 + 2) <= 1 || n8 >= 4) {
                    if (n8 > 1) {
                        n8 -= 2;
                    }
                    int[] nArray = this.multiDisplayOptions.getPageW();
                    int[] nArray2 = this.multiDisplayOptions.getPageH();
                    if (n8 < 4 && n8 > -1 && this.facingDragCachedImages[n8] == null) {
                        BufferedImage bufferedImage = new BufferedImage(nArray[n2], nArray2[n2], 2);
                        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                        int n10 = this.display.getDisplayRotation();
                        graphics2D.rotate((double)n10 * Math.PI / 180.0);
                        try {
                            if (n10 == 90) {
                                graphics2D.translate(0, -nArray[n2]);
                                graphics2D.drawImage(this.pdf.getPageAsImage(n2), 0, 0, nArray2[n2] + 1, nArray[n2] + 1, null);
                            } else if (n10 == 180) {
                                graphics2D.translate(-nArray[n2], -nArray2[n2]);
                                graphics2D.drawImage(this.pdf.getPageAsImage(n2), 0, 0, nArray[n2] + 1, nArray2[n2] + 1, null);
                            } else if (n10 == 270) {
                                graphics2D.translate(-nArray2[n2], 0);
                                graphics2D.drawImage(this.pdf.getPageAsImage(n2), 0, 0, nArray2[n2] + 1, nArray[n2] + 1, null);
                            } else {
                                graphics2D.drawImage(this.pdf.getPageAsImage(n2), 0, 0, nArray[n2] + 1, nArray2[n2] + 1, null);
                            }
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("Exception: " + exception.getMessage());
                        }
                        this.facingDragCachedImages[n8] = bufferedImage;
                    }
                }
            }
            --n7;
            if (!this.multiDisplayOptions.isTurnoverOn() || this.displayView != 4 || ++n2 != n6) continue;
            n2 = n5;
        }
    }

    public void decodeMorePages(int n, int n2, int n3) {
        if (this.currentPageViews.get(n) == null) {
            this.decodePage(n, n2, n3);
        }
        this.repaint();
    }

    public void decodePage(int n, int n2, int n3) {
        Integer n4;
        Object v;
        Object object;
        AcroRenderer acroRenderer = this.pdf.getFormRenderer();
        if (this.displayView == 2 || this.displayView == 3) {
            object = (PdfStreamDecoder)this.currentPageViews.get(n);
            acroRenderer.createDisplayComponentsForPage(n, (PdfStreamDecoder)object);
            if (this.pdf.getSpecialMode() != -1 && this.pdf.getSpecialMode() != 1 && n != this.pdf.getPageCount()) {
                acroRenderer.createDisplayComponentsForPage(n + 1, (PdfStreamDecoder)object);
            }
        }
        if (((object = this.pdf.getIO().getReferenceforPage(n)) != null || acroRenderer.isXFA() && acroRenderer.useXFA()) && (v = this.currentPageViews.get(n4 = Integer.valueOf(n))) == null && this.multiDisplayOptions.isIsGeneratingOtherPages()) {
            this.display.forceRedraw();
            this.getPageView((String)object, n);
        }
    }

    private void getPageView(String string, int n) {
        PageObject pageObject = new PageObject(string);
        pageObject.setPageNumber(n);
        this.currentPdfFile.readObject(pageObject);
        PdfObject pdfObject = ((PdfObject)pageObject).getDictionary(2004251818);
        DynamicVectorRenderer dynamicVectorRenderer = this.getNewDisplay(n);
        dynamicVectorRenderer.setHiResImageForDisplayMode(this.pdf.isHiResScreenDisplay());
        int n2 = 0;
        if (this.pdf.getDisplayView() == 2 && this.pdf.getDisplayView() == 3) {
            n2 = 1;
        }
        PdfStreamDecoder pdfStreamDecoder = this.formRenderer.getStreamDecoder(this.currentPdfFile, this.pdf.isHiResScreenDisplay(), this.fileAccess.getRes().getPdfLayerList(), true);
        if (this.formRenderer != null && this.pdf.isForm()) {
            this.formRenderer.createDisplayComponentsForPage(n, pdfStreamDecoder);
        }
        pdfStreamDecoder.setParameters(true, true, 7, n2, false, this.pdf.getExternalHandler().getMode().equals((Object)GUIModes.JAVAFX));
        pdfStreamDecoder.setXMLExtraction(this.pdf.isXMLExtraction());
        this.pdf.getExternalHandler().addHandlers(pdfStreamDecoder);
        pdfStreamDecoder.setObjectValue(-9, this.fileAccess.getFilename());
        pdfStreamDecoder.setObjectValue(-8, this.pdf.getObjectStore());
        pdfStreamDecoder.setObjectValue(-18, this.pageData);
        pdfStreamDecoder.setIntValue(-10, n);
        pdfStreamDecoder.setRenderer(dynamicVectorRenderer);
        try {
            dynamicVectorRenderer.init(this.pageData.getMediaBoxWidth(n), this.pageData.getMediaBoxHeight(n), this.options.getPageColor());
            dynamicVectorRenderer.setValue(1, this.options.getPageColor().getRGB());
            if (this.options.getTextColor() != null) {
                dynamicVectorRenderer.setValue(2, this.options.getTextColor().getRGB());
                if (this.options.getChangeTextAndLine()) {
                    dynamicVectorRenderer.setValue(3, 1);
                } else {
                    dynamicVectorRenderer.setValue(3, 0);
                }
            }
            this.fileAccess.getRes().setupResources(pdfStreamDecoder, false, pdfObject, n, this.currentPdfFile);
            pdfStreamDecoder.decodePageContent(pageObject);
            TextLines textLines = this.pdf.getTextLines();
            if (textLines != null) {
                Vector_Rectangle_Int vector_Rectangle_Int = (Vector_Rectangle_Int)pdfStreamDecoder.getObjectValue(-21);
                vector_Rectangle_Int.trim();
                int[][] nArray = vector_Rectangle_Int.get();
                Vector_Int vector_Int = (Vector_Int)pdfStreamDecoder.getObjectValue(22);
                vector_Int.trim();
                int[] nArray2 = vector_Int.get();
                for (int i = 0; i != nArray.length; ++i) {
                    textLines.addToLineAreas(nArray[i], nArray2[i], n);
                }
            }
            dynamicVectorRenderer.flagDecodingFinished();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        catch (Error error) {
            LogWriter.writeLog("Exception: " + error.getMessage());
        }
        this.currentPageViews.put(n, dynamicVectorRenderer);
        this.display.setCurrentDisplay(dynamicVectorRenderer);
    }

    void resetPageCaches(int n, int n2) {
        Object v;
        int n3;
        Integer n4;
        Object object2;
        for (Object object2 : this.cachedPageViews.keySet()) {
            n4 = (Integer)object2;
            n3 = n4;
            if (n3 < n || n3 > n2 || (v = this.cachedPageViews.get(n4)) == null) continue;
            this.currentPageViews.put(n4, v);
        }
        Iterator iterator = this.currentPageViews.keySet().iterator();
        object2 = new HashMap();
        while (iterator.hasNext()) {
            n4 = (Integer)iterator.next();
            n3 = n4;
            if (n3 >= n && n3 <= n2) continue;
            v = this.currentPageViews.get(n4);
            if (v != null) {
                this.cachedPageViews.put(n4, v);
            }
            object2.put(n4, "x");
        }
        iterator = object2.keySet().iterator();
        while (iterator.hasNext()) {
            this.currentPageViews.remove(iterator.next());
        }
    }

    private synchronized void calcDisplayedRange() {
        int n = this.pageData.getPageCount();
        if (this.displayView == 1) {
            return;
        }
        this.display.getDisplayedRectangle();
        if (this.displayView == 4) {
            this.multiDisplayOptions.calcDisplayRangeForFacing();
        } else {
            int n2 = this.updatePageDisplayed();
            this.fileAccess.setPageNumber(n2);
            if (n2 != -1) {
                this.gui.setPage(n2);
            }
        }
        if (this.multiDisplayOptions.getEndViewPage() > n) {
            this.multiDisplayOptions.setEndViewPage(n);
        }
        if (this.displayView != 4) {
            this.display.refreshDisplay();
        }
    }

    public void flushPageCaches() {
        this.currentPageViews.clear();
        this.cachedPageViews.clear();
    }

    public DynamicVectorRenderer getCurrentPageView(int n) {
        return (DynamicVectorRenderer)this.currentPageViews.get(n);
    }

    public void dispose() {
        this.cachedPageViews = null;
    }

    private int updatePageDisplayed() {
        int n = -1;
        int n2 = this.pageData.getPageCount();
        int[] nArray = this.multiDisplayOptions.getyReached();
        int[] nArray2 = this.multiDisplayOptions.getPageH();
        int n3 = this.display.getRy();
        int n4 = this.display.getRh();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 1; i <= n2; ++i) {
            int n8;
            int n9 = nArray[i];
            int n10 = nArray[i] + nArray2[i];
            int n11 = n3 + n4;
            if (n9 > n11 || n10 < n3) continue;
            if (n == -1) {
                n = i;
                n6 = i;
            }
            n7 = i;
            int n12 = n3 + n4 / 2;
            int n13 = n12 - nArray[i];
            if (n13 < 0 || n13 > nArray2[i]) {
                n13 = 0;
            }
            if ((n8 = nArray[i] + nArray2[i] - n12) < 0 || n8 > nArray2[i]) {
                n8 = 0;
            }
            if (n8 > n13) {
                n13 = n8;
            }
            if (n13 <= 0 || n13 <= n5) continue;
            n5 = n13;
            n = i;
        }
        if (n == -1) {
            n = 1;
            n6 = 1;
            n7 = 1;
        }
        this.multiDisplayOptions.setStartViewPage(n6);
        this.multiDisplayOptions.setEndViewPage(n7);
        if (this.multiDisplayOptions.getEndViewPage() > n2) {
            this.multiDisplayOptions.setEndViewPage(n2);
        }
        return n;
    }

    public void resetCachedFacingImages() {
        for (int i = 0; i < 4; ++i) {
            this.facingDragCachedImages[i] = null;
        }
    }

    public BufferedImage[] getFacingDragImages() {
        return this.facingDragCachedImages;
    }

    public BufferedImage getfacingDragTempLeftImg() {
        return this.facingDragTempLeftImg;
    }

    public BufferedImage getfacingDragTempRightImg() {
        return this.facingDragTempRightImg;
    }

    public int getFacingDragTempLeftNo() {
        return this.facingDragTempLeftNo;
    }

    public int getFacingDragTempRightNo() {
        return this.facingDragTempRightNo;
    }

    public void setCustomRenderChangeListener(RenderChangeListener renderChangeListener) {
        this.customRenderChangeListener = renderChangeListener;
    }

    public void repaint() {
        throw new UnsupportedOperationException("repaint Not supported yet.");
    }

    public DynamicVectorRenderer getNewDisplay(int n) {
        throw new UnsupportedOperationException(this + "Not supported yet.");
    }
}

