/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.CacheHint;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.CheckBox;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.effect.PerspectiveTransform;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIDisplay;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class PageFlowFX
extends AnchorPane {
    private final boolean isFX;
    protected final PdfDecoderInt pdf;
    private boolean stopAddingPages;
    private final int pageCount;
    private int displayRotation;
    protected int pageNumber;
    private int pagesToGenerate = 21;
    private static final int textureSize = 256;
    private Page[] pages;
    private double totalPageWidth;
    private Rectangle backgroundTop;
    private Rectangle backgroundBottom;
    private NavBar navBar;
    private ZoomBar zoomBar;
    private CheckBox perspectiveCheckBox;
    private CheckBox reflectionCheckBox;
    private Cursor defaultCursor;
    private Cursor grabbingCursor;
    private Cursor grabCursor;
    private double sceneXOffset;
    private double sceneYOffset;
    private boolean currentlyAddingPages;
    private boolean memoryWarningShown;
    private boolean pageFlowEnding;
    private double scaling = 1.5;
    private double pageFocus = 1.0;
    private int currentZPosition = -1;
    private boolean formsIgnoredStore;
    private int pagesInMemory;
    private final long memoryLimit;
    private final Runtime runtime;
    private final int pageLimit;
    private boolean pageClickEvent;
    private boolean enableReflection = true;
    private boolean enablePerspectiveTransform = true;
    private double newSceneWidth;
    private double newSceneHeight;
    private volatile double x;
    private volatile boolean isAnimating;
    private volatile boolean stopAnimating;
    private int newDestination;
    private double speed;
    final DoubleProperty pageNumberProperty = new SimpleDoubleProperty();
    private boolean isUpdateMemory;
    private String memoryMessage;

    public PageFlowFX(PdfDecoderInt pdfDecoderInt, boolean bl) {
        Platform.setImplicitExit((boolean)false);
        this.pdf = pdfDecoderInt;
        this.isFX = bl;
        this.pageCount = this.pdf.getPageCount();
        this.setPageNumber(pdfDecoderInt.getPageNumber());
        this.pageFocus = this.pageNumber;
        this.pagesInMemory = 0;
        this.runtime = Runtime.getRuntime();
        long l = this.runtime.maxMemory();
        this.memoryLimit = (float)l * 0.25f < 3.6E7f ? l - 36000000L : (long)((float)l * 0.75f);
        AcroRenderer acroRenderer = this.pdf.getFormRenderer();
        if (acroRenderer != null) {
            this.formsIgnoredStore = acroRenderer.ignoreForms();
            acroRenderer.setIgnoreForms(true);
        }
        this.pages = new Page[this.pageCount];
        this.createScene();
        this.pageLimit = 50;
    }

    private void createScene() {
        ObservableList observableList = this.getChildren();
        this.sceneXOffset = this.newSceneWidth / 2.0;
        this.sceneYOffset = this.newSceneHeight / 2.0;
        this.backgroundTop = new Rectangle(0.0, 0.0, this.newSceneWidth, this.newSceneHeight / 2.0);
        this.backgroundTop.setFill((Paint)new Color(0.21568627655506134, 0.21568627655506134, 0.2549019753932953, 1.0));
        this.backgroundBottom = new Rectangle(0.0, this.newSceneHeight / 2.0, this.newSceneWidth, this.newSceneHeight / 2.0);
        this.backgroundBottom.setFill((Paint)new Color(0.10980392247438431, 0.10980392247438431, 0.125490203499794, 1.0));
        this.navBar = new NavBar();
        this.zoomBar = new ZoomBar();
        this.perspectiveCheckBox = new CheckBox("Perspectives");
        this.perspectiveCheckBox.setLayoutX(5.0);
        this.perspectiveCheckBox.setLayoutY(5.0);
        this.perspectiveCheckBox.setTextFill((Paint)Color.WHITE);
        this.perspectiveCheckBox.setSelected(true);
        this.perspectiveCheckBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                PageFlowFX.this.togglePerspectives();
            }
        });
        this.reflectionCheckBox = new CheckBox("Reflections");
        this.reflectionCheckBox.setLayoutX(5.0);
        this.reflectionCheckBox.setLayoutY(25.0);
        this.reflectionCheckBox.setTextFill((Paint)Color.WHITE);
        this.reflectionCheckBox.setSelected(true);
        this.reflectionCheckBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                PageFlowFX.this.toggleReflections();
            }
        });
        if (DecoderOptions.isRunningOnLinux) {
            this.toggleReflections();
            this.togglePerspectives();
        }
        observableList.addAll((Object[])new Node[]{this.backgroundTop, this.backgroundBottom, this.navBar, this.zoomBar, this.perspectiveCheckBox, this.reflectionCheckBox});
        this.setupMouseHandlers();
        this.setupWindowResizeListeners();
        this.addPages();
    }

    private void repositionObjects() {
        this.newSceneWidth = this.getWidth();
        this.newSceneHeight = this.getHeight();
        this.sceneXOffset = this.newSceneWidth / 2.0;
        this.totalPageWidth = (double)this.pageCount * this.getPageWidthOrHeight();
        this.sceneYOffset = this.newSceneHeight / 2.0;
        this.navBar.update();
        this.zoomBar.update();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PageFlowFX.this.backgroundTop.setWidth(PageFlowFX.this.newSceneWidth);
                PageFlowFX.this.backgroundBottom.setWidth(PageFlowFX.this.newSceneWidth);
                PageFlowFX.this.backgroundTop.setHeight(PageFlowFX.this.newSceneHeight);
                PageFlowFX.this.backgroundBottom.setHeight(PageFlowFX.this.newSceneHeight);
                PageFlowFX.this.backgroundBottom.setY(PageFlowFX.this.newSceneHeight / 2.0);
                if (PageFlowFX.this.pages[PageFlowFX.this.pageNumber - 1] != null) {
                    PageFlowFX.this.pages[PageFlowFX.this.pageNumber - 1].setMain(true);
                }
                for (Page page : PageFlowFX.this.pages) {
                    if (page == null) continue;
                    page.update();
                }
            }
        });
    }

    private void setupWindowResizeListeners() {
        this.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                PageFlowFX.this.repositionObjects();
            }
        });
        this.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                PageFlowFX.this.repositionObjects();
            }
        });
    }

    private void setupMouseHandlers() {
        this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (GUIDisplay.allowChangeCursor) {
                    PageFlowFX.this.setCursor(PageFlowFX.this.grabbingCursor);
                }
                if (!PageFlowFX.this.navBar.isNavBarPress(mouseEvent) && !PageFlowFX.this.zoomBar.isZoomBarPress(mouseEvent)) {
                    if (PageFlowFX.this.isAnimating) {
                        PageFlowFX.this.stopAnimating = true;
                    }
                    PageFlowFX.this.x = mouseEvent.getSceneX();
                }
            }
        });
        this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (!PageFlowFX.this.navBar.isNavBarDrag(mouseEvent) && !PageFlowFX.this.zoomBar.isZoomBarDrag(mouseEvent)) {
                    int n;
                    double d = PageFlowFX.this.pageFocus - (mouseEvent.getSceneX() - PageFlowFX.this.x) / PageFlowFX.this.totalPageWidth * 4.0 * (double)PageFlowFX.this.pageCount;
                    if (d > 1.0 && d < (double)PageFlowFX.this.pageCount) {
                        PageFlowFX.this.isAnimating = true;
                        PageFlowFX.this.reorderPages(PageFlowFX.this.pageFocus, false);
                        PageFlowFX.this.pageFocus = d;
                        PageFlowFX.this.navBar.update();
                        for (Page page : PageFlowFX.this.pages) {
                            if (page == null) continue;
                            page.update();
                        }
                        PageFlowFX.this.isAnimating = false;
                    }
                    if (PageFlowFX.this.pageNumber != (n = (int)(PageFlowFX.this.pageFocus + 0.5))) {
                        PageFlowFX.this.setPageNumber(n);
                    }
                    PageFlowFX.this.addPages();
                    PageFlowFX.this.x = mouseEvent.getSceneX();
                }
            }
        });
        this.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (GUIDisplay.allowChangeCursor) {
                    PageFlowFX.this.setCursor(PageFlowFX.this.grabCursor);
                }
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (GUIDisplay.allowChangeCursor) {
                            PageFlowFX.this.setCursor(PageFlowFX.this.defaultCursor);
                        }
                    }
                }, 350L);
                if (!PageFlowFX.this.navBar.isNavBarRelease(mouseEvent) && !PageFlowFX.this.zoomBar.isZoomBarRelease()) {
                    if (!PageFlowFX.this.pageClickEvent) {
                        if (PageFlowFX.this.pageFocus < 1.0) {
                            PageFlowFX.this.pageFocus = 1.0;
                        } else if (PageFlowFX.this.pageFocus > (double)PageFlowFX.this.pageCount) {
                            PageFlowFX.this.pageFocus = PageFlowFX.this.pageCount;
                        }
                        PageFlowFX.this.goTo((int)(PageFlowFX.this.pageFocus + 0.5));
                    } else {
                        PageFlowFX.this.pageClickEvent = false;
                    }
                }
            }
        });
        this.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (PageFlowFX.this.navBar.isNavBarHover(mouseEvent) || PageFlowFX.this.zoomBar.isZoomBarHover(mouseEvent)) {
                    if (GUIDisplay.allowChangeCursor) {
                        PageFlowFX.this.setCursor(PageFlowFX.this.grabCursor);
                    }
                } else if (GUIDisplay.allowChangeCursor) {
                    PageFlowFX.this.setCursor(PageFlowFX.this.defaultCursor);
                }
            }
        });
        this.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                KeyCode keyCode = keyEvent.getCode();
                switch (keyCode) {
                    case RIGHT: {
                        int n = PageFlowFX.this.pageNumber + 1;
                        if (n > PageFlowFX.this.pageCount) break;
                        PageFlowFX.this.goTo(n);
                        break;
                    }
                    case LEFT: {
                        int n = PageFlowFX.this.pageNumber - 1;
                        if (n <= 0) break;
                        PageFlowFX.this.goTo(n);
                        break;
                    }
                    case R: {
                        PageFlowFX.this.toggleReflections();
                        break;
                    }
                    case T: {
                        PageFlowFX.this.togglePerspectives();
                    }
                }
            }
        });
        this.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent scrollEvent) {
                double d = scrollEvent.getDeltaY();
                if (scrollEvent.isControlDown()) {
                    if (d < 0.0) {
                        if (PageFlowFX.this.scaling < 2.0) {
                            PageFlowFX.this.scaling = PageFlowFX.this.scaling + 0.1;
                            if (PageFlowFX.this.scaling > 2.0) {
                                PageFlowFX.this.scaling = 2.0;
                            }
                            PageFlowFX.this.zoomBar.update();
                            for (Page page : PageFlowFX.this.pages) {
                                if (page == null) continue;
                                page.update();
                            }
                        }
                    } else if (d > 0.0 && PageFlowFX.this.scaling > 1.0) {
                        PageFlowFX.this.scaling = PageFlowFX.this.scaling - 0.1;
                        if (PageFlowFX.this.scaling < 1.0) {
                            PageFlowFX.this.scaling = 1.0;
                        }
                        PageFlowFX.this.zoomBar.update();
                        for (Page page : PageFlowFX.this.pages) {
                            if (page == null) continue;
                            page.update();
                        }
                    }
                } else if (d > 0.0) {
                    int n = PageFlowFX.this.pageNumber - 1;
                    if (n > 0) {
                        PageFlowFX.this.goTo(n);
                    }
                } else {
                    int n = PageFlowFX.this.pageNumber + 1;
                    if (n <= PageFlowFX.this.pageCount) {
                        PageFlowFX.this.goTo(n);
                    }
                }
            }
        });
        this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    if (PageFlowFX.this.scaling != 1.0) {
                        PageFlowFX.this.scaling = 1.0;
                    } else {
                        PageFlowFX.this.scaling = 2.0;
                    }
                    PageFlowFX.this.zoomBar.update();
                    for (Page page : PageFlowFX.this.pages) {
                        if (page == null) continue;
                        page.update();
                    }
                }
            }
        });
    }

    private void reorderPages(double d, boolean bl) {
        final int n = (int)(d + 0.5);
        if (!(bl || this.currentZPosition != n && n >= 1 && n <= this.pageCount)) {
            return;
        }
        this.currentZPosition = n;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                int n2;
                PageFlowFX.this.getChildren().clear();
                PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.backgroundTop);
                PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.backgroundBottom);
                for (n2 = PageFlowFX.this.pageCount; n2 > n; --n2) {
                    if (PageFlowFX.this.pages[n2 - 1] == null) continue;
                    PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.pages[n2 - 1]);
                    if (!PageFlowFX.this.enableReflection) continue;
                    PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.pages[n2 - 1].getReflection());
                }
                for (n2 = 1; n2 < n; ++n2) {
                    if (PageFlowFX.this.pages[n2 - 1] == null) continue;
                    PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.pages[n2 - 1]);
                    if (!PageFlowFX.this.enableReflection) continue;
                    PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.pages[n2 - 1].getReflection());
                }
                if (PageFlowFX.this.pages[n - 1] != null) {
                    PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.pages[n - 1]);
                    if (PageFlowFX.this.enableReflection) {
                        PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.pages[n - 1].getReflection());
                    }
                }
                PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.navBar);
                PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.zoomBar);
                PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.perspectiveCheckBox);
                PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.reflectionCheckBox);
            }
        });
    }

    public void setRotation(int n) {
        if (this.displayRotation != n) {
            this.displayRotation = n;
            for (Page page : this.pages) {
                if (page == null) continue;
                page.dispose();
            }
            this.stop();
            this.stopAddingPages = false;
            this.goTo(this.pageNumber);
        }
    }

    private void toggleReflections() {
        if (this.enableReflection) {
            this.enableReflection = false;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    PageFlowFX.this.reflectionCheckBox.setSelected(false);
                }
            });
            for (Page page : this.pages) {
                if (page == null) continue;
                page.disposeReflection();
            }
            this.reorderPages(this.pageFocus, true);
        } else if (this.enablePerspectiveTransform) {
            this.enableReflection = true;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    PageFlowFX.this.reflectionCheckBox.setSelected(true);
                }
            });
            for (Page page : this.pages) {
                if (page == null) continue;
                page.setupReflection();
                page.update();
            }
            this.reorderPages(this.pageFocus, true);
        }
    }

    private void togglePerspectives() {
        if (this.enablePerspectiveTransform) {
            if (this.enableReflection) {
                this.toggleReflections();
            }
            this.enablePerspectiveTransform = false;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    PageFlowFX.this.perspectiveCheckBox.setSelected(false);
                    PageFlowFX.this.reflectionCheckBox.setDisable(true);
                }
            });
            for (Page page : this.pages) {
                if (page == null) continue;
                page.disposePerspectiveTransform();
                page.update();
            }
        } else {
            this.enablePerspectiveTransform = true;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    PageFlowFX.this.perspectiveCheckBox.setSelected(true);
                    PageFlowFX.this.reflectionCheckBox.setDisable(false);
                }
            });
            for (Page page : this.pages) {
                if (page == null) continue;
                page.setupPerspectiveTransform();
                page.update();
            }
        }
    }

    public void setCursors(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.grabCursor = bufferedImage != null ? new ImageCursor((Image)SwingFXUtils.toFXImage((BufferedImage)bufferedImage, (WritableImage)new WritableImage(bufferedImage.getWidth(), bufferedImage.getHeight())), 8.0, 8.0) : Cursor.DEFAULT;
        this.grabbingCursor = bufferedImage2 != null ? new ImageCursor((Image)SwingFXUtils.toFXImage((BufferedImage)bufferedImage2, (WritableImage)new WritableImage(bufferedImage2.getWidth(), bufferedImage2.getHeight())), 8.0, 8.0) : Cursor.DEFAULT;
        this.defaultCursor = Cursor.DEFAULT;
    }

    public void goTo(final int n) {
        this.setPageNumber(n);
        for (int i = 0; i < this.pageCount; ++i) {
            if (this.pages[i] == null || i == this.pageNumber - 1) continue;
            this.pages[i].setMain(false);
        }
        if (this.pages[this.pageNumber - 1] != null) {
            this.pages[this.pageNumber - 1].setMain(true);
        }
        this.pdf.setPageParameters(-100.0f, n);
        this.addPages();
        if (this.isAnimating) {
            this.newDestination = n;
            return;
        }
        Thread thread = new Thread("PageFlow-goTo"){

            @Override
            public void run() {
                int n2 = n;
                while (!PageFlowFX.this.stopAnimating && (PageFlowFX.this.pageFocus > (double)n2 || PageFlowFX.this.pageFocus < (double)n2)) {
                    if (PageFlowFX.this.newDestination != 0) {
                        n2 = PageFlowFX.this.newDestination;
                        PageFlowFX.this.newDestination = 0;
                    }
                    if (PageFlowFX.this.pageFocus < (double)n2) {
                        if (PageFlowFX.this.speed < (double)0.2f) {
                            PageFlowFX.this.speed = 0.2f;
                        }
                        PageFlowFX.this.speed = PageFlowFX.this.speed * (double)1.15f;
                    } else {
                        if (PageFlowFX.this.speed > (double)-0.2f) {
                            PageFlowFX.this.speed = -0.2f;
                        }
                        PageFlowFX.this.speed = PageFlowFX.this.speed * (double)1.15f;
                    }
                    double d = ((double)n2 - PageFlowFX.this.pageFocus) / 4.0;
                    if (Math.abs(PageFlowFX.this.speed) > Math.abs(d)) {
                        PageFlowFX.this.speed = d;
                    }
                    PageFlowFX.this.pageFocus = PageFlowFX.this.pageFocus + PageFlowFX.this.speed;
                    if (PageFlowFX.this.pageFocus - (double)((int)PageFlowFX.this.pageFocus) > 0.99) {
                        PageFlowFX.this.pageFocus = (int)PageFlowFX.this.pageFocus + 1;
                    } else if (PageFlowFX.this.pageFocus - (double)((int)PageFlowFX.this.pageFocus) < 0.01) {
                        PageFlowFX.this.pageFocus = (int)PageFlowFX.this.pageFocus;
                    }
                    PageFlowFX.this.navBar.update();
                    PageFlowFX.this.reorderPages(PageFlowFX.this.pageFocus, false);
                    for (Page page : PageFlowFX.this.pages) {
                        if (page == null) continue;
                        page.update();
                    }
                    try {
                        Thread.sleep(40L);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception: " + exception.getMessage());
                    }
                    if (PageFlowFX.this.newDestination == 0) continue;
                    n2 = PageFlowFX.this.newDestination;
                    PageFlowFX.this.newDestination = 0;
                }
                PageFlowFX.this.stopAnimating = false;
                PageFlowFX.this.isAnimating = false;
            }
        };
        thread.setDaemon(true);
        this.isAnimating = true;
        thread.start();
    }

    private synchronized Image getPageImage(int n, int n2, int n3) {
        int n4;
        if (n != this.pageNumber && n3 > 256) {
            return null;
        }
        int n5 = this.pdf.getPdfPageData().getCropBoxWidth(n);
        float f = n5 > (n4 = this.pdf.getPdfPageData().getCropBoxHeight(n)) ? (float)n3 / (float)n5 : (float)n3 / (float)n4;
        try {
            float f2 = this.pdf.getScaling();
            this.pdf.setScaling(f);
            BufferedImage bufferedImage = this.pdf.getPageAsImage(n);
            this.pdf.setScaling(f2);
            BufferedImage bufferedImage2 = new BufferedImage(n3, n3, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
            graphics2D.rotate((double)n2 / 180.0 * Math.PI, n3 / 2, n3 / 2);
            int n6 = (n3 - bufferedImage.getWidth()) / 2;
            int n7 = n3 - bufferedImage.getHeight();
            graphics2D.drawImage(bufferedImage, n6, n7, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
            return SwingFXUtils.toFXImage((BufferedImage)bufferedImage2, (WritableImage)new WritableImage(bufferedImage2.getWidth(), bufferedImage2.getHeight()));
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
            return null;
        }
    }

    public void dispose() {
        for (Page page : this.pages) {
            if (page == null) continue;
            page.dispose();
        }
        this.pages = null;
        AcroRenderer acroRenderer = this.pdf.getFormRenderer();
        if (acroRenderer != null) {
            acroRenderer.setIgnoreForms(this.formsIgnoredStore);
        }
    }

    public void stop() {
        this.stopAddingPages = true;
        if (!this.isFX) {
            while (this.currentlyAddingPages) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    LogWriter.writeLog("Exception: " + interruptedException.getMessage());
                }
            }
        }
    }

    private void addPages() {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                PageFlowFX.this.currentlyAddingPages = true;
                int n = PageFlowFX.this.pageNumber;
                for (int i = 0; i <= PageFlowFX.this.pagesToGenerate; ++i) {
                    Page page;
                    if (PageFlowFX.this.checkMemory()) {
                        return null;
                    }
                    int n2 = PageFlowFX.this.pagesToGenerate * 2 - 1 - PageFlowFX.this.pagesInMemory;
                    if (n2 < 2) {
                        PageFlowFX.this.removeFurthestPages(2 - n2);
                    }
                    if (i == PageFlowFX.this.pagesToGenerate - 1) {
                        long l = PageFlowFX.this.runtime.totalMemory() - PageFlowFX.this.runtime.freeMemory();
                        if (l < PageFlowFX.this.memoryLimit && PageFlowFX.this.pagesToGenerate < PageFlowFX.this.pageCount && PageFlowFX.this.pagesToGenerate < PageFlowFX.this.pageLimit) {
                            PageFlowFX.this.pagesToGenerate++;
                        } else {
                            l = PageFlowFX.this.runtime.totalMemory() - PageFlowFX.this.runtime.freeMemory();
                            if (l < PageFlowFX.this.memoryLimit && PageFlowFX.this.pagesToGenerate < PageFlowFX.this.pageCount && PageFlowFX.this.pagesToGenerate < PageFlowFX.this.pageLimit) {
                                PageFlowFX.this.pagesToGenerate++;
                            }
                        }
                    }
                    if (PageFlowFX.this.stopAddingPages) {
                        PageFlowFX.this.currentlyAddingPages = false;
                        PageFlowFX.this.stopAddingPages = false;
                        return null;
                    }
                    int n3 = n + i;
                    if (i > 40) {
                        n3 += i - 40;
                        if ((n3 -= n3 & 1) > PageFlowFX.this.pageCount && ((n3 -= PageFlowFX.this.pageCount - (n + 40)) & 1) == 0) {
                            --n3;
                        }
                    }
                    if (n3 <= PageFlowFX.this.pageCount && PageFlowFX.this.pages != null && PageFlowFX.this.pages[n3 - 1] == null) {
                        try {
                            page = new Page(n3);
                            if (PageFlowFX.this.pages != null) {
                                ((PageFlowFX)PageFlowFX.this).pages[n3 - 1] = page;
                                PageFlowFX.this.reorderPages(PageFlowFX.this.pageFocus, true);
                                PageFlowFX.this.pagesInMemory++;
                                if (n3 == PageFlowFX.this.pageNumber) {
                                    page.setMain(true);
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (PageFlowFX.this.pages != null) {
                                ((PageFlowFX)PageFlowFX.this).pages[n3 - 1] = null;
                            }
                            PageFlowFX.this.pagesInMemory--;
                            LogWriter.writeLog("Exception: " + exception.getMessage());
                        }
                    }
                    if (PageFlowFX.this.stopAddingPages) {
                        PageFlowFX.this.currentlyAddingPages = false;
                        PageFlowFX.this.stopAddingPages = false;
                        return null;
                    }
                    n3 = n - i;
                    if (i > 40) {
                        n3 -= i - 40;
                        if ((n3 += n3 & 1) < 1 && ((n3 += n - 41) & 1) == 0) {
                            --n3;
                        }
                    }
                    if (n3 > 0 && PageFlowFX.this.pages != null && PageFlowFX.this.pages[n3 - 1] == null) {
                        page = new Page(n3);
                        if (PageFlowFX.this.pages != null) {
                            ((PageFlowFX)PageFlowFX.this).pages[n3 - 1] = page;
                            PageFlowFX.this.reorderPages(PageFlowFX.this.pageFocus, true);
                            PageFlowFX.this.pagesInMemory++;
                        }
                    }
                    if (n != PageFlowFX.this.pageNumber) {
                        i = -1;
                        n = PageFlowFX.this.pageNumber;
                    }
                    if (i <= 10) continue;
                    while ((PageFlowFX.this.speed > (double)0.005f || PageFlowFX.this.speed < (double)-0.005f) && n == PageFlowFX.this.pageNumber) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            LogWriter.writeLog("Exception: " + interruptedException.getMessage());
                        }
                    }
                }
                PageFlowFX.this.currentlyAddingPages = false;
                return null;
            }
        };
        Thread thread = new Thread((Runnable)task);
        if (!this.currentlyAddingPages) {
            this.currentlyAddingPages = true;
            thread.setDaemon(true);
            thread.start();
        }
    }

    private boolean checkMemory() {
        if (this.runtime.maxMemory() - (this.runtime.totalMemory() - this.runtime.freeMemory()) < 32000000L) {
            if (this.pagesInMemory > 1) {
                boolean bl = true;
                while (this.runtime.maxMemory() - (this.runtime.totalMemory() - this.runtime.freeMemory()) < 32000000L) {
                    if (this.pagesToGenerate > 5) {
                        --this.pagesToGenerate;
                        int n = this.pagesInMemory - (this.pagesToGenerate * 2 - 1);
                        if (n <= 0) continue;
                        this.removeFurthestPages(n);
                        continue;
                    }
                    bl = false;
                }
                if (bl) {
                    return false;
                }
                if (this.runtime.maxMemory() - (this.runtime.totalMemory() - this.runtime.freeMemory()) < 32000000L) {
                    if (!this.memoryWarningShown) {
                        if (!this.pageFlowEnding) {
                            this.isUpdateMemory = true;
                            this.memoryMessage = Messages.getMessage("PdfViewer.PageFlowLowMemory");
                        } else {
                            this.isUpdateMemory = false;
                        }
                        this.memoryWarningShown = true;
                    }
                    this.currentlyAddingPages = false;
                    return true;
                }
            } else {
                this.stop();
                if (!Platform.isFxApplicationThread()) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                        }
                    };
                    Platform.runLater((Runnable)runnable);
                }
                if (!this.pageFlowEnding) {
                    this.pageFlowEnding = true;
                    this.isUpdateMemory = true;
                    this.memoryMessage = Messages.getMessage("PdfViewer.PageFlowNotEnoughMemory");
                } else {
                    this.isUpdateMemory = false;
                }
                return true;
            }
        }
        return false;
    }

    private void removeFurthestPages(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = this.pageNumber - 1;
        int n7 = this.pageCount - this.pageNumber;
        int n8 = n4 = n6 > n7 ? n6 : n7;
        while (n5 < n && n8 >= 40) {
            n3 = this.pageNumber - n8;
            if ((n3 -= 1 - (n3 & 1)) > 0 && this.pages[n3 - 1] != null) {
                this.pages[n3 - 1].dispose();
                ++n5;
            }
            if (n5 == n) continue;
            n2 = this.pageNumber + n8;
            if ((n2 -= 1 - (n2 & 1)) <= this.pageCount && this.pages[n2 - 1] != null) {
                this.pages[n2 - 1].dispose();
                ++n5;
            }
            --n8;
        }
        n8 = n4;
        while (n5 < n && n8 >= 0) {
            n3 = this.pageNumber - n8;
            if (n3 > 0 && this.pages[n3 - 1] != null) {
                this.pages[n3 - 1].dispose();
                ++n5;
            }
            if (n5 == n) continue;
            n2 = this.pageNumber + n8;
            if (n2 <= this.pageCount && this.pages[n2 - 1] != null) {
                this.pages[n2 - 1].dispose();
                ++n5;
            }
            --n8;
        }
    }

    private double getFullPageWidthOrHeight() {
        return this.newSceneHeight / 13.0 * 12.0;
    }

    private double getPageWidthOrHeight() {
        return this.newSceneHeight / (13.0 * this.scaling) * 12.0;
    }

    public PdfDecoderInt getPdfDecoderInt() {
        return this.pdf;
    }

    public DoubleProperty getPageNumber() {
        return this.pageNumberProperty;
    }

    private void setPageNumber(int n) {
        this.pageNumberProperty.set((double)n);
        this.pageNumber = n;
    }

    public boolean isUpdateMemory() {
        return this.isUpdateMemory;
    }

    public String getMemoryMessage() {
        return this.memoryMessage;
    }

    private class ZoomBar
    extends Parent {
        private final Line zoomLine = new Line();
        private final Circle zoomCircle;
        private static final int distanceFromSide = 15;
        private boolean handlingMouse;

        ZoomBar() {
            this.zoomLine.setStrokeWidth(1.5);
            this.zoomLine.setStroke((Paint)Color.WHITESMOKE);
            this.zoomCircle = new Circle(5.0);
            this.zoomCircle.setStrokeWidth(2.0);
            this.zoomCircle.setStroke((Paint)Color.WHITE);
            this.zoomCircle.setFill((Paint)Color.GRAY);
            this.getChildren().addAll((Object[])new Node[]{this.zoomLine, this.zoomCircle});
        }

        public boolean isZoomBarHover(MouseEvent mouseEvent) {
            return mouseEvent.getX() < 30.0 && mouseEvent.getY() > this.getStartY() - 5.0 && mouseEvent.getY() < this.getEndY() + 5.0;
        }

        public boolean isZoomBarPress(MouseEvent mouseEvent) {
            if (mouseEvent.getX() < 30.0 && mouseEvent.getY() > this.getStartY() - 5.0 && mouseEvent.getY() < this.getEndY() + 5.0) {
                this.handlingMouse = true;
                this.isZoomBarDrag(mouseEvent);
                return true;
            }
            return false;
        }

        public boolean isZoomBarDrag(MouseEvent mouseEvent) {
            if (this.handlingMouse) {
                double d = mouseEvent.getY();
                double d2 = this.getStartY();
                double d3 = this.getEndY();
                if (d < d2) {
                    d = d2;
                }
                if (d > d3) {
                    d = d3;
                }
                if (d != this.zoomCircle.getCenterY()) {
                    this.zoomCircle.setCenterY(d);
                    double d4 = (d - d2) / (d3 - d2);
                    PageFlowFX.this.scaling = 1.0 + d4;
                    for (Page page : PageFlowFX.this.pages) {
                        if (page == null) continue;
                        page.update();
                    }
                }
                return true;
            }
            return false;
        }

        public boolean isZoomBarRelease() {
            if (this.handlingMouse) {
                this.handlingMouse = false;
                return true;
            }
            return false;
        }

        public void update() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ZoomBar.this.zoomCircle.setCenterX(15.0);
                    ZoomBar.this.zoomLine.setStartX(15.5);
                    ZoomBar.this.zoomLine.setStartY(PageFlowFX.this.newSceneHeight * 0.2);
                    ZoomBar.this.zoomLine.setEndX(15.5);
                    ZoomBar.this.zoomLine.setEndY(PageFlowFX.this.newSceneHeight * 0.4);
                    double d = 2.0 - PageFlowFX.this.scaling;
                    double d2 = ZoomBar.this.getStartY();
                    double d3 = ZoomBar.this.getEndY();
                    ZoomBar.this.zoomCircle.setCenterY(d3 - (d3 - d2) * d);
                }
            });
        }

        private double getStartY() {
            return PageFlowFX.this.newSceneHeight * 0.2;
        }

        private double getEndY() {
            return PageFlowFX.this.newSceneHeight * 0.4;
        }
    }

    private class NavBar
    extends Parent {
        private final Line navLine = new Line();
        private final Circle navCircle;
        private static final int distanceFromSides = 20;
        private static final int distanceFromBottom = 15;
        private boolean handlingMouse;

        NavBar() {
            this.navLine.setStrokeWidth(1.5);
            this.navLine.setStroke((Paint)Color.WHITE);
            this.navCircle = new Circle(5.0);
            this.navCircle.setStrokeWidth(2.0);
            this.navCircle.setStroke((Paint)Color.WHITE);
            this.navCircle.setFill((Paint)Color.GRAY);
            this.getChildren().addAll((Object[])new Node[]{this.navLine, this.navCircle});
        }

        public boolean isNavBarHover(MouseEvent mouseEvent) {
            return mouseEvent.getY() > PageFlowFX.this.newSceneHeight - 30.0;
        }

        public boolean isNavBarPress(MouseEvent mouseEvent) {
            if (mouseEvent.getY() > PageFlowFX.this.newSceneHeight - 30.0) {
                this.handlingMouse = true;
                return true;
            }
            return false;
        }

        public boolean isNavBarDrag(MouseEvent mouseEvent) {
            if (this.handlingMouse) {
                double d = mouseEvent.getX();
                if (d < 20.0) {
                    d = 20.0;
                }
                if (d > PageFlowFX.this.newSceneWidth - 20.0) {
                    d = PageFlowFX.this.newSceneWidth - 20.0;
                }
                if (d != this.navCircle.getCenterX()) {
                    this.navCircle.setCenterX(d);
                    double d2 = (d - 20.0) / (PageFlowFX.this.newSceneWidth - 40.0);
                    PageFlowFX.this.pageFocus = (double)(PageFlowFX.this.pageCount - 1) * d2 + 1.0;
                    int n = (int)(PageFlowFX.this.pageFocus + 0.5);
                    if (PageFlowFX.this.pageNumber != n) {
                        PageFlowFX.this.setPageNumber(n);
                    }
                    PageFlowFX.this.addPages();
                    PageFlowFX.this.reorderPages(PageFlowFX.this.pageFocus, false);
                    for (Page page : PageFlowFX.this.pages) {
                        if (page == null) continue;
                        page.update();
                    }
                }
                return true;
            }
            return false;
        }

        public boolean isNavBarRelease(MouseEvent mouseEvent) {
            if (this.handlingMouse) {
                double d = mouseEvent.getX();
                if (d < 20.0) {
                    d = 20.0;
                }
                if (d > PageFlowFX.this.newSceneWidth - 20.0) {
                    d = PageFlowFX.this.newSceneWidth - 20.0;
                }
                double d2 = (d - 20.0) / (PageFlowFX.this.newSceneWidth - 40.0);
                int n = (int)((double)(PageFlowFX.this.pageCount - 1) * d2 + 1.0 + 0.5);
                if (PageFlowFX.this.pageNumber != n) {
                    PageFlowFX.this.setPageNumber(n);
                }
                PageFlowFX.this.goTo(PageFlowFX.this.pageNumber);
                this.handlingMouse = false;
                return true;
            }
            return false;
        }

        public void update() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    NavBar.this.navCircle.setCenterY(PageFlowFX.this.newSceneHeight - 15.0);
                    NavBar.this.navLine.setStartX(20.0);
                    NavBar.this.navLine.setStartY(PageFlowFX.this.newSceneHeight - 15.0 + 0.5);
                    NavBar.this.navLine.setEndX(PageFlowFX.this.newSceneWidth - 20.0);
                    NavBar.this.navLine.setEndY(PageFlowFX.this.newSceneHeight - 15.0 + 0.5);
                    double d = (PageFlowFX.this.pageFocus - 1.0) / (double)(PageFlowFX.this.pageCount - 1);
                    double d2 = 20.0 + (PageFlowFX.this.newSceneWidth - 40.0) * d;
                    NavBar.this.navCircle.setCenterX(d2);
                }
            });
        }
    }

    private class Page
    extends ImageView {
        private final Image lowResImage;
        private final int page;
        private final int rotation;
        private PerspectiveTransform trans;
        private ColorAdjust colorAdjust;
        private int mainTextureSize;
        private ImageView reflection;
        private PerspectiveTransform reflectionTransform;
        private double x;
        private double y;
        private double widthHeight;
        private double altWidthHeight;

        Page(int n) {
            this.rotation = PageFlowFX.this.displayRotation;
            this.page = n;
            this.lowResImage = PageFlowFX.this.getPageImage(n, this.rotation, 256);
            if (this.lowResImage == null) {
                this.dispose();
                this.widthHeight = 0.0;
                return;
            }
            this.setImage(this.lowResImage);
            this.setupMouseHandlers();
            if (PageFlowFX.this.enableReflection) {
                this.setupReflection();
            }
            this.colorAdjust = new ColorAdjust();
            if (PageFlowFX.this.enablePerspectiveTransform) {
                this.setupPerspectiveTransform();
            }
            this.setCache(true);
            this.setCacheHint(CacheHint.QUALITY);
            this.update();
        }

        public void setupReflection() {
            this.reflection = new ImageView();
            this.reflectionTransform = new PerspectiveTransform();
            this.reflectionTransform.setInput((Effect)new ColorAdjust(0.0, 0.0, -0.75, 0.0));
            this.reflection.setEffect((Effect)this.reflectionTransform);
            this.reflection.setImage(this.lowResImage);
        }

        public void disposeReflection() {
            this.reflection = null;
            this.reflectionTransform = null;
        }

        public void setupPerspectiveTransform() {
            this.trans = new PerspectiveTransform();
            this.trans.setInput((Effect)this.colorAdjust);
            this.setEffect((Effect)this.trans);
        }

        public void disposePerspectiveTransform() {
            this.trans = null;
            this.setEffect(null);
        }

        private void setupMouseHandlers() {
            this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    PageFlowFX.this.pageClickEvent = true;
                }
            });
            this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    PageFlowFX.this.pageClickEvent = false;
                }
            });
            this.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (PageFlowFX.this.pageClickEvent) {
                        PageFlowFX.this.goTo(Page.this.page);
                    }
                }
            });
        }

        public void update() {
            this.widthHeight = PageFlowFX.this.getPageWidthOrHeight();
            this.y = -this.widthHeight / 40.0;
            double d = (double)this.page - PageFlowFX.this.pageFocus;
            if (d > 1.0) {
                d = (d - 1.0) / 5.0 + 1.0;
            } else if (d < -1.0) {
                d = (d + 1.0) / 5.0 - 1.0;
            }
            this.x = d * this.widthHeight;
            this.redraw();
        }

        private void redraw() {
            boolean bl;
            boolean bl2 = bl = !PageFlowFX.this.enablePerspectiveTransform || this.trans != null && (this.getRealX(this.x) + this.widthHeight > 0.0 && this.getRealX(this.x) < PageFlowFX.this.newSceneWidth || this.trans.getUrx() > 0.0 && this.trans.getUlx() < PageFlowFX.this.newSceneWidth);
            if (bl) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        double d = (double)Page.this.page - PageFlowFX.this.pageFocus;
                        double d2 = Math.abs(d);
                        if (d2 > 1.0) {
                            d2 = (d2 - 1.0) / (double)(PageFlowFX.this.enablePerspectiveTransform ? 16 : 8) + 1.0;
                        }
                        double d3 = Math.pow(0.7, d2);
                        if (d > 1.0) {
                            d = 1.0;
                        }
                        if (d < -1.0) {
                            d = -1.0;
                        }
                        boolean bl = d > 0.0;
                        if ((d = Math.abs(d)) == 0.0) {
                            Page.this.setEffect(null);
                        } else if (PageFlowFX.this.enablePerspectiveTransform) {
                            Page.this.setEffect((Effect)Page.this.trans);
                        }
                        Page.this.colorAdjust.setBrightness(-d / 2.0);
                        double d4 = Page.this.widthHeight / 2.0;
                        double d5 = d / 2.0;
                        if (!PageFlowFX.this.enablePerspectiveTransform) {
                            d5 /= 8.0;
                        }
                        double d6 = d / 4.0;
                        double d7 = Page.this.getRealX(d4 + Page.this.x - (1.0 - d5) * d4 * d3);
                        double d8 = Page.this.getRealX(d4 + Page.this.x + (1.0 - d5) * d4 * d3);
                        if (PageFlowFX.this.enablePerspectiveTransform) {
                            Page.this.trans.setLlx(d7);
                            Page.this.trans.setUlx(d7);
                            Page.this.trans.setLrx(d8);
                            Page.this.trans.setUrx(d8);
                            if (bl) {
                                Page.this.trans.setLly(Page.this.getRealY(d4 + Page.this.y + (1.0 - d6) * d4 * d3));
                                Page.this.trans.setUly(Page.this.getRealY(d4 + Page.this.y - (1.0 - d6) * d4 * d3));
                                Page.this.trans.setLry(Page.this.getRealY(d4 + Page.this.y + d4 * d3));
                                Page.this.trans.setUry(Page.this.getRealY(d4 + Page.this.y - d4 * d3));
                            } else {
                                Page.this.trans.setLry(Page.this.getRealY(d4 + Page.this.y + (1.0 - d6) * d4 * d3));
                                Page.this.trans.setUry(Page.this.getRealY(d4 + Page.this.y - (1.0 - d6) * d4 * d3));
                                Page.this.trans.setLly(Page.this.getRealY(d4 + Page.this.y + d4 * d3));
                                Page.this.trans.setUly(Page.this.getRealY(d4 + Page.this.y - d4 * d3));
                            }
                        }
                        if (PageFlowFX.this.enableReflection) {
                            Page.this.reflectionTransform.setLlx(d7);
                            Page.this.reflectionTransform.setUlx(d7);
                            Page.this.reflectionTransform.setLrx(d8);
                            Page.this.reflectionTransform.setUrx(d8);
                            Page.this.reflectionTransform.setLly(Page.this.trans.getLly());
                            Page.this.reflectionTransform.setLry(Page.this.trans.getLry());
                            Page.this.reflectionTransform.setUly(Page.this.trans.getLly() + (Page.this.trans.getLly() - Page.this.trans.getUly()));
                            Page.this.reflectionTransform.setUry(Page.this.trans.getLry() + (Page.this.trans.getLry() - Page.this.trans.getUry()));
                        }
                        if (!PageFlowFX.this.enablePerspectiveTransform) {
                            Page.this.altWidthHeight = d8 - d7;
                            if (d == 0.0) {
                                Page.this.setFitWidth((int)Page.this.altWidthHeight);
                                Page.this.setFitHeight((int)Page.this.altWidthHeight);
                            } else {
                                Page.this.setFitWidth(Page.this.altWidthHeight);
                                Page.this.setFitHeight(Page.this.altWidthHeight);
                            }
                        } else if (d == 0.0) {
                            Page.this.setFitWidth((int)Page.this.widthHeight);
                            Page.this.setFitHeight((int)Page.this.widthHeight);
                        } else {
                            Page.this.setFitWidth(Page.this.widthHeight);
                            Page.this.setFitHeight(Page.this.widthHeight);
                        }
                        if (d == 0.0) {
                            Page.this.setX((int)Page.this.getRealX(Page.this.x));
                            Page.this.setY((int)Page.this.getRealY(Page.this.y));
                        } else {
                            Page.this.setX(Page.this.getRealX(Page.this.x));
                            Page.this.setY(Page.this.getRealY(Page.this.y));
                        }
                    }
                });
            }
        }

        public void setMain(boolean bl) {
            if (bl) {
                Thread thread = new Thread("FX-setMain"){

                    @Override
                    public void run() {
                        if (PageFlowFX.this.checkMemory()) {
                            return;
                        }
                        Page.this.mainTextureSize = (int)PageFlowFX.this.getFullPageWidthOrHeight();
                        final Image image = PageFlowFX.this.getPageImage(Page.this.page, Page.this.rotation, Page.this.mainTextureSize);
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (image != null) {
                                    Page.this.setImage(image);
                                }
                            }
                        });
                    }
                };
                thread.setDaemon(true);
                thread.start();
            } else {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Page.this.setImage(Page.this.lowResImage);
                    }
                });
            }
        }

        private ImageView getReflection() {
            return this.reflection;
        }

        private double getRealX(double d) {
            return PageFlowFX.this.sceneXOffset + this.getXOffset() + d;
        }

        private double getRealY(double d) {
            return PageFlowFX.this.sceneYOffset + this.getYOffset() + d;
        }

        private double getXOffset() {
            if (PageFlowFX.this.enablePerspectiveTransform) {
                return -this.widthHeight / 2.0;
            }
            return -this.altWidthHeight / 2.0;
        }

        private double getYOffset() {
            if (PageFlowFX.this.enablePerspectiveTransform) {
                return -this.widthHeight / 2.0;
            }
            return -this.altWidthHeight / 2.0;
        }

        public void dispose() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Page.this.setImage(null);
                }
            });
            PageFlowFX.this.pagesInMemory--;
            ((PageFlowFX)PageFlowFX.this).pages[this.page - 1] = null;
        }
    }
}

