/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display;

import org.jpedal.display.MultiDisplayOptions;
import org.jpedal.objects.PdfPageData;

public class PageOffsets {
    private int width;
    private int height;
    private int totalSingleWidth;
    private int totalDoubleWidth;
    private int gaps;
    private int doubleGaps;
    private int totalSingleHeight;
    private int totalDoubleHeight;
    protected int maxW;
    protected int maxH;
    public static final int pageGap = 10;
    private int doublePageWidth;
    private int doublePageHeight;
    private int biggestWidth;
    private int biggestHeight;
    private int widestPageNR;
    private int widestPageR;

    public PageOffsets(int n, PdfPageData pdfPageData) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.totalSingleHeight = 0;
        this.totalSingleWidth = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        this.widestPageR = 0;
        this.widestPageNR = 0;
        this.totalDoubleWidth = 0;
        this.totalDoubleHeight = 0;
        this.gaps = 0;
        this.doubleGaps = 0;
        this.biggestWidth = 0;
        this.biggestHeight = 0;
        for (int i = 1; i < n + 1; ++i) {
            int n10 = pdfPageData.getCropBoxWidth(i);
            int n11 = pdfPageData.getCropBoxHeight(i);
            int n12 = pdfPageData.getRotation(i);
            if (n12 == 90 || n12 == 270) {
                int n13 = n10;
                n10 = n11;
                n11 = n13;
            }
            if (n10 > this.maxW) {
                this.maxW = n10;
            }
            if (n11 > this.maxH) {
                this.maxH = n11;
            }
            this.gaps += 10;
            this.totalSingleWidth += n10;
            this.totalSingleHeight += n11;
            if ((i & 1) == 1) {
                if (n7 < n10) {
                    n7 = n10;
                }
                if (n9 < n11) {
                    n9 = n11;
                }
            } else {
                if (n6 < n10) {
                    n6 = n10;
                }
                if (n8 < n11) {
                    n8 = n11;
                }
            }
            if (this.widestPageNR < n10) {
                this.widestPageNR = n10;
            }
            if (this.widestPageR < n11) {
                this.widestPageR = n11;
            }
            if (n10 > this.biggestWidth) {
                this.biggestWidth = n10;
            }
            if (n11 > this.biggestHeight) {
                this.biggestHeight = n11;
            }
            if ((i & 1) == 1) {
                if (n4 < n10) {
                    n4 = n10;
                }
                if (n5 < n11) {
                    n5 = n11;
                }
                if (i == 1) {
                    this.totalDoubleWidth = n10;
                    this.totalDoubleHeight = n11;
                } else {
                    this.totalDoubleWidth += n4;
                    this.totalDoubleHeight += n5;
                }
                this.doubleGaps += 10;
                n2 = n10;
                n3 = n11;
                continue;
            }
            n2 += n10;
            n3 += n11;
            n4 = n10;
            n5 = n11;
            if (i != n) continue;
            this.totalDoubleWidth = this.totalDoubleWidth + n4 + 10;
            this.totalDoubleHeight = this.totalDoubleHeight + n5 + 10;
        }
        this.doublePageWidth = n6 + n7 + 10;
        this.doublePageHeight = n8 + n9 + 10;
        this.totalSingleWidth -= 10;
        this.totalSingleHeight -= 10;
    }

    public int getMaxH() {
        return this.maxH;
    }

    public int getMaxW() {
        return this.maxW;
    }

    public int getWidestPageR() {
        return this.widestPageR;
    }

    public int getWidestPageNR() {
        return this.widestPageNR;
    }

    public int getTotalSingleWidth() {
        return this.totalSingleWidth;
    }

    public void setTotalSingleWidth(int n) {
        this.totalSingleWidth = n;
    }

    public int getGaps() {
        return this.gaps;
    }

    public void setGaps(int n) {
        this.gaps = n;
    }

    public int getDoubleGaps() {
        return this.doubleGaps;
    }

    public void setDoubleGaps(int n) {
        this.doubleGaps = n;
    }

    public int getTotalDoubleWidth() {
        return this.totalDoubleWidth;
    }

    public void setTotalDoubleWidth(int n) {
        this.totalDoubleWidth = n;
    }

    public int getTotalSingleHeight() {
        return this.totalSingleHeight;
    }

    public void setTotalSingleHeight(int n) {
        this.totalSingleHeight = n;
    }

    public int getTotalDoubleHeight() {
        return this.totalDoubleHeight;
    }

    public void setTotalDoubleHeight(int n) {
        this.totalDoubleHeight = n;
    }

    public int getDoublePageWidth() {
        return this.doublePageWidth;
    }

    public void setDoublePageWidth(int n) {
        this.doublePageWidth = n;
    }

    public int getDoublePageHeight() {
        return this.doublePageHeight;
    }

    public void setDoublePageHeight(int n) {
        this.doublePageHeight = n;
    }

    public int getBiggestWidth() {
        return this.biggestWidth;
    }

    public void setBiggestWidth(int n) {
        this.biggestWidth = n;
    }

    public int getBiggestHeight() {
        return this.biggestHeight;
    }

    public void setBiggestHeight(int n) {
        this.biggestHeight = n;
    }

    public void setWidestPageNR(int n) {
        this.widestPageNR = n;
    }

    public void setWidestPageR(int n) {
        this.widestPageR = n;
    }

    public void calculateCombinedPageSizes(int n, int n2, int n3, MultiDisplayOptions multiDisplayOptions, PdfPageData pdfPageData, float f, int n4, int n5) {
        int n6;
        int n7;
        int n8 = 0;
        if (n == 4 && multiDisplayOptions.getPageW() != null) {
            if (multiDisplayOptions.isSeparateCover()) {
                n7 = n2;
                if ((n7 & 1) == 1) {
                    --n7;
                }
                n6 = n7 + 1;
            } else {
                n7 = n2;
                if ((n7 & 1) == 0) {
                    --n7;
                }
                n6 = n7 + 1;
            }
            n8 = multiDisplayOptions.getPageH(n7);
            if (n6 < multiDisplayOptions.getPageH().length && n8 < multiDisplayOptions.getPageH(n6)) {
                n8 = multiDisplayOptions.getPageH(n6);
            }
        }
        n7 = this.gaps;
        n6 = this.doubleGaps;
        switch (n) {
            case 4: {
                int n9 = (n3 + pdfPageData.getRotation(n2)) % 180 == 90 ? pdfPageData.getCropBoxHeight(n2) : pdfPageData.getCropBoxWidth(n2);
                int n10 = pdfPageData.getPageCount();
                int n11 = n2 + 1 > n10 || n2 == 1 && n10 != 2 ? n9 : ((n3 + pdfPageData.getRotation(n2 + 1)) % 180 == 90 ? pdfPageData.getCropBoxHeight(n2 + 1) : pdfPageData.getCropBoxWidth(n2 + 1));
                int n12 = n9 + n11;
                this.width = (int)((float)n12 * f) + 10;
                this.height = n8;
                break;
            }
            case 2: {
                if (n3 == 90 | n3 == 270) {
                    this.width = (int)((float)this.biggestHeight * f);
                    this.height = (int)((float)this.totalSingleWidth * f) + n7 + n5;
                    break;
                }
                this.width = (int)((float)this.biggestWidth * f);
                this.height = (int)((float)this.totalSingleHeight * f) + n7 + n5;
                break;
            }
            case 3: {
                if (n3 == 90 | n3 == 270) {
                    this.width = (int)((float)this.doublePageHeight * f) + n4 * 2 + n6;
                    this.height = (int)((float)this.totalDoubleWidth * f) + n6 + n5;
                    break;
                }
                this.width = (int)((float)this.doublePageWidth * f) + n4 * 2;
                this.height = (int)((float)this.totalDoubleHeight * f) + n6 + n5;
            }
        }
    }

    public int getPageWidth() {
        return this.width;
    }

    public int getPageHeight() {
        return this.height;
    }
}

