/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display.javafx;

import javafx.application.Platform;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Transform;
import org.jpedal.PdfDecoderFX;
import org.jpedal.display.Display;
import org.jpedal.display.GUIDisplay;
import org.jpedal.examples.viewer.commands.javafx.JavaFXPreferences;
import org.jpedal.examples.viewer.gui.JavaFxGUI;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.FXDisplay;
import org.jpedal.text.TextLines;

public class SingleDisplayFX
extends GUIDisplay
implements Display {
    final PdfDecoderFX pdf;
    private int[] cursorBoxOnScreen;
    Rectangle cursorRect;
    final Pane cursorBoxPane = new Pane();

    public SingleDisplayFX(int n, DynamicVectorRenderer dynamicVectorRenderer, PdfDecoderFX pdfDecoderFX, DecoderOptions decoderOptions) {
        if (n < 1) {
            n = 1;
        }
        this.pageNumber = n;
        this.currentDisplay = dynamicVectorRenderer;
        this.pdf = pdfDecoderFX;
        this.options = decoderOptions;
        this.displayOffsets = pdfDecoderFX.getDisplayOffsets();
        this.pageData = pdfDecoderFX.getPdfPageData();
    }

    public SingleDisplayFX(PdfDecoderFX pdfDecoderFX, DecoderOptions decoderOptions) {
        this.pdf = pdfDecoderFX;
        this.options = decoderOptions;
        this.displayOffsets = pdfDecoderFX.getDisplayOffsets();
        this.pageData = pdfDecoderFX.getPdfPageData();
    }

    @Override
    public void refreshDisplay() {
        if (Platform.isFxApplicationThread()) {
            if (this.displayScalingDbl != null) {
                this.pdf.getTransforms().setAll((Object[])new Transform[]{Transform.affine((double)this.displayScalingDbl[0], (double)this.displayScalingDbl[1], (double)this.displayScalingDbl[2], (double)this.displayScalingDbl[3], (double)this.displayScalingDbl[4], (double)this.displayScalingDbl[5])});
            }
            if (this.currentDisplay != null) {
                this.paintPage(this.pdf.highlightsPane, this.pdf.getFormRenderer(), null);
            }
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (SingleDisplayFX.this.displayScalingDbl != null) {
                        SingleDisplayFX.this.pdf.getTransforms().setAll((Object[])new Transform[]{Transform.affine((double)SingleDisplayFX.this.displayScalingDbl[0], (double)SingleDisplayFX.this.displayScalingDbl[1], (double)SingleDisplayFX.this.displayScalingDbl[2], (double)SingleDisplayFX.this.displayScalingDbl[3], (double)SingleDisplayFX.this.displayScalingDbl[4], (double)SingleDisplayFX.this.displayScalingDbl[5])});
                    }
                    if (SingleDisplayFX.this.currentDisplay != null) {
                        SingleDisplayFX.this.paintPage(SingleDisplayFX.this.pdf.highlightsPane, SingleDisplayFX.this.pdf.getFormRenderer(), null);
                    }
                }
            });
        }
    }

    @Override
    public void setPageRotation(int n) {
        super.setPageRotation(n);
        this.refreshDisplay();
    }

    static Path getBorder(int n, int n2) {
        Path path = new Path();
        path.getElements().add((Object)new MoveTo(-1.0, -1.0));
        path.getElements().add((Object)new LineTo((double)(n + 2), -1.0));
        path.getElements().add((Object)new LineTo((double)(n + 2), (double)(n2 + 2)));
        path.getElements().add((Object)new LineTo(-1.0, (double)(n2 + 2)));
        path.getElements().add((Object)new ClosePath());
        path.setStroke((Paint)Color.rgb((int)0, (int)0, (int)0));
        return path;
    }

    @Override
    public void disableScreen() {
        if (this.currentDisplay != null) {
            Group group = ((FXDisplay)this.currentDisplay).getFXPane();
            if (this.pdf.getChildren().contains((Object)group)) {
                int n = this.pdf.getChildren().size();
                for (int i = 0; i < n; ++i) {
                    this.pdf.getChildren().remove(0);
                }
            }
        }
    }

    @Override
    public void paintPage(Object object, AcroRenderer acroRenderer, TextLines textLines) {
        Pane pane = (Pane)object;
        Group group = ((FXDisplay)this.currentDisplay).getFXPane();
        String string = String.valueOf(this.pageNumber);
        Rectangle rectangle = new Rectangle((double)this.crx, (double)this.cry, (double)this.crw, (double)this.crh);
        rectangle.setFill((Paint)Color.WHITE);
        if (pane != null && pane.getParent() != null) {
            ((Group)pane.getParent()).getChildren().remove((Object)pane);
        }
        group.getChildren().addAll((Object[])new Node[]{pane});
        this.pdf.setPrefSize(this.crw, this.crh);
        if (this.displayView == 1) {
            this.pdf.getChildren().clear();
            if (acroRenderer.isXFA()) {
                Path path = SingleDisplayFX.getBorder(this.crw, this.crh);
                path.setFill((Paint)Color.WHITE);
                this.pdf.getChildren().addAll((Object[])new Node[]{path});
                path.setLayoutX((double)this.crx);
                path.setLayoutY((double)this.cry);
            }
            if (!this.pdf.getChildren().contains((Object)group)) {
                this.pdf.getChildren().addAll((Object[])new Node[]{group});
            }
            group.setLayoutX((double)(-this.crx));
            group.setLayoutY((double)(-this.cry));
        } else {
            Object object22;
            Node node = null;
            for (Object object22 : this.pdf.getChildren()) {
                if (object22.getId() == null || !object22.getId().equals(string) || !(object22 instanceof Path)) continue;
                node = object22;
            }
            if (node != null) {
                this.pdf.getChildren().remove(node);
            }
            group.setId(string);
            if (!this.pdf.getChildren().contains((Object)group)) {
                this.pdf.getChildren().addAll((Object[])new Node[]{group});
            }
            Object object3 = this.multiDisplayOptions.getxReached();
            object22 = this.multiDisplayOptions.getyReached();
            int n = this.pageNumber;
            int n2 = (int)((float)object3[n] / this.scaling);
            int n3 = (int)((float)object22[n] / this.scaling);
            if (this.displayView == 3) {
                n2 = this.currentOffset.getWidestPageR() - n2;
            }
            group.setLayoutX((double)(-n2));
            group.setLayoutY(this.pdf.getHeight() - (double)n3);
        }
        rectangle.setFill((Paint)Color.WHITE);
        group.setClip((Node)rectangle);
        this.addForms(acroRenderer);
    }

    private void addForms(AcroRenderer acroRenderer) {
        int n = this.pageNumber;
        int n2 = this.pageNumber;
        if (this.displayView != 1) {
            n = this.getStartPage();
            n2 = this.getEndPage();
            if (n == 0 || n2 == 0 || this.lastEnd != n2 || this.lastStart != n) {
                this.lastFormPage = -1;
            }
            this.lastEnd = n2;
            this.lastStart = n;
        }
        if (this.lastFormPage != this.pageNumber && acroRenderer != null) {
            acroRenderer.displayComponentsOnscreen(n, n2);
            if (acroRenderer.getCompData().hasformsOnPageDecoded(this.pageNumber)) {
                this.lastFormPage = this.pageNumber;
            }
        }
        if (acroRenderer != null && this.currentOffset != null) {
            acroRenderer.getCompData().setPageValues(this.scaling, this.displayRotation, (int)this.indent, this.displayOffsets.getUserOffsetX(), this.displayOffsets.getUserOffsetY(), this.displayView, this.currentOffset.getWidestPageNR(), this.currentOffset.getWidestPageR());
            acroRenderer.getCompData().resetScaledLocation(this.scaling, this.displayRotation, (int)this.indent);
        }
    }

    @Override
    public void init(float f, int n, int n2, DynamicVectorRenderer dynamicVectorRenderer, boolean bl) {
        this.pageData = this.pdf.getPdfPageData();
        super.init(f, n, n2, dynamicVectorRenderer, bl);
        this.setPageSize(n2, f);
        this.lastFormPage = -1;
    }

    @Override
    public void setPageSize(int n, float f) {
        this.pageData.setScalingValue(f);
        this.topW = this.pageData.getCropBoxWidth(n);
        this.topH = this.pageData.getCropBoxHeight(n);
        double d = this.pageData.getMediaBoxHeight(n);
        this.cropX = this.pageData.getCropBoxX(n);
        this.cropY = this.pageData.getCropBoxY(n);
        this.cropW = this.topW;
        this.cropH = this.topH;
        if (this.displayView == 1) {
            this.crx = (int)((double)this.insetW + this.cropX);
            this.cry = (int)((double)this.insetH - this.cropY);
        } else {
            this.crx = this.insetW;
            this.cry = this.insetH;
        }
        int n2 = (int)(d - this.cropH);
        if (!this.pageData.getMediaValue(n).isEmpty()) {
            n2 -= this.pageData.getMediaBoxHeight(n) - (int)(this.cropY + this.cropH) - this.pageData.getCropBoxY(n);
        }
        this.crw = (int)this.cropW;
        this.crh = (int)this.cropH;
        this.cry += n2;
    }

    @Override
    public int[] getCursorBoxOnScreenAsArray() {
        return this.cursorBoxOnScreen;
    }

    @Override
    public void updateCursorBoxOnScreen(int[] nArray, int n, int n2, int n3, int n4) {
        if (this.displayView != 1 && this.getPageSize(this.displayView)[0] == 0 && this.getPageSize(this.displayView)[1] == 0) {
            return;
        }
        if (nArray != null) {
            int n5 = nArray[0];
            int n6 = nArray[1];
            int n7 = nArray[2];
            int n8 = nArray[3];
            int n9 = this.pageData.getCropBoxX(n2);
            int n10 = this.pageData.getCropBoxY(n2);
            this.cursorBoxOnScreen = new int[]{n5 -= n9, n6 -= n10, n7, n8};
            if (DecoderOptions.showMouseBox) {
                this.cursorRect = new Rectangle((double)n5, (double)n6, (double)n7, (double)n8);
                this.cursorRect.setStroke((Paint)JavaFXPreferences.shiftColorSpaceToFX(n));
                this.cursorRect.setFill((Paint)Color.TRANSPARENT);
                if (this.pdf.getChildren().contains((Object)this.cursorBoxPane)) {
                    this.cursorBoxPane.getChildren().clear();
                    this.cursorBoxPane.getChildren().add((Object)this.cursorRect);
                    this.pdf.getChildren().remove((Object)this.cursorBoxPane);
                }
                this.pdf.getChildren().add((Object)this.cursorBoxPane);
            }
        } else {
            this.cursorBoxOnScreen = null;
            if (this.pdf.getChildren().contains((Object)this.cursorBoxPane)) {
                this.cursorBoxPane.getChildren().clear();
                this.pdf.getChildren().remove((Object)this.cursorBoxPane);
            }
        }
    }

    @Override
    public java.awt.Rectangle getDisplayedRectangle() {
        ScrollPane scrollPane = ((JavaFxGUI)this.pdf.getExternalHandler(4)).getPageContainer();
        if (scrollPane == null) {
            return new java.awt.Rectangle(0, 0, 0, 0);
        }
        Bounds bounds = scrollPane.getViewportBounds();
        return this.getDisplayedRectangle(true, new java.awt.Rectangle((int)bounds.getMinX(), (int)(-bounds.getMinY()), (int)bounds.getWidth(), (int)bounds.getHeight()));
    }
}

