/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.baseviewer;

import java.io.File;
import java.util.List;
import javafx.animation.Transition;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import org.jpedal.PdfDecoderFX;
import org.jpedal.examples.viewer.gui.javafx.FXViewerTransitions;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXInputDialog;
import org.jpedal.exception.PdfException;
import org.jpedal.external.PluginHandler;
import org.jpedal.objects.PdfPageData;
import org.jpedal.parser.DecoderOptions;

public class BaseViewerFX
extends Application {
    private final PdfDecoderFX pdf = new PdfDecoderFX();
    PluginHandler customPluginHandle = null;
    String PDFfile;
    File file;
    private String password;
    private boolean closePasswordPrompt;
    private VBox top;
    private HBox bottom;
    private ScrollPane center;
    private Group group;
    private Text fileLoc;
    private float scale = 1.0f;
    private final float[] scalings = new float[]{0.01f, 0.1f, 0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 4.0f, 7.5f, 10.0f};
    private int currentScaling = 5;
    private static final float insetX = 25.0f;
    private static final float insetY = 25.0f;
    private int currentPage = 1;
    Stage stage;
    Scene scene;
    static final int FXscaling = 1;
    FitToPage zoomMode = FitToPage.AUTO;
    private FXViewerTransitions.TransitionType transitionType = FXViewerTransitions.TransitionType.None;

    public static void main(String[] stringArray) {
        DecoderOptions.javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        System.out.println("JAVA VERSION : " + DecoderOptions.javaVersion);
        if (DecoderOptions.javaVersion < 1.8f) {
            throw new RuntimeException("You need to Run Java 1.8+");
        }
        BaseViewerFX.launch((String[])stringArray);
    }

    public void start(Stage stage) {
        String string;
        stage.setTitle("Base Viewer FX - 6.6.30");
        String string2 = System.getProperty("org.jpedal.fxtransition");
        if (string2 != null) {
            string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1).toLowerCase();
            this.transitionType = FXViewerTransitions.TransitionType.valueOf(string2);
        }
        if ((string = System.getProperty("org.jpedal.page")) != null) {
            this.currentPage = Integer.parseInt(string);
        }
        this.stage = stage;
        this.scene = this.setupViewer(800, 600);
        List list = this.getParameters().getUnnamed();
        stage.setScene(this.scene);
        stage.show();
        if (list.size() == 1) {
            String string3 = (String)list.get(0);
            this.file = new File(string3);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    BaseViewerFX.this.loadPDF(BaseViewerFX.this.file);
                    if (System.getProperty("org.jpedal.page") != null) {
                        System.setProperty("org.jpedal.page", "");
                    }
                }
            });
        }
        this.addListeners();
    }

    public Scene setupViewer(int n, int n2) {
        BorderPane borderPane = new BorderPane();
        this.top = new VBox();
        borderPane.setTop((Node)this.top);
        this.top.getChildren().add((Object)this.setupToolBar());
        this.bottom = new HBox();
        this.bottom.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
        borderPane.setBottom((Node)this.bottom);
        this.center = new ScrollPane();
        this.center.setPannable(true);
        this.center.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.center.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.group = new Group();
        this.group.getChildren().add((Object)this.pdf);
        this.center.setContent((Node)this.group);
        borderPane.setCenter((Node)this.center);
        this.center.viewportBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> observableValue, Bounds bounds, Bounds bounds2) {
                BaseViewerFX.this.adjustPagePosition(bounds2);
            }
        });
        this.fileLoc = new Text("No PDF Selected");
        this.fileLoc.setId("file_location");
        this.bottom.getChildren().add((Object)this.fileLoc);
        this.scene = new Scene((Parent)borderPane, (double)(n * 1), (double)(n2 * 1));
        return this.scene;
    }

    public void addListeners() {
        this.scene.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                BaseViewerFX.this.fitToX(BaseViewerFX.this.zoomMode);
            }
        });
        this.scene.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                BaseViewerFX.this.fitToX(BaseViewerFX.this.zoomMode);
            }
        });
        this.scene.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent dragEvent) {
                Dragboard dragboard = dragEvent.getDragboard();
                if (dragboard.hasFiles()) {
                    dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                } else {
                    dragEvent.consume();
                }
            }
        });
        this.scene.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent dragEvent) {
                Dragboard dragboard = dragEvent.getDragboard();
                boolean bl = false;
                if (dragboard.hasFiles()) {
                    bl = true;
                    BaseViewerFX.this.file = (File)dragboard.getFiles().get(0);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BaseViewerFX.this.loadPDF(BaseViewerFX.this.file);
                        }
                    });
                }
                dragEvent.setDropCompleted(bl);
                dragEvent.consume();
            }
        });
    }

    private ToolBar setupToolBar() {
        ToolBar toolBar = new ToolBar();
        Button button = new Button("Open");
        Button button2 = new Button("Back");
        ComboBox comboBox = new ComboBox();
        Label label = new Label();
        Button button3 = new Button("Forward");
        Button button4 = new Button("Zoom in");
        Button button5 = new Button("Zoom out");
        Button button6 = new Button("Fit to Width");
        Button button7 = new Button("Fit to Height");
        Button button8 = new Button("Fit to Page");
        ComboBox comboBox2 = new ComboBox();
        button.setId("open");
        button2.setId("back");
        label.setId("pgCount");
        comboBox.setId("pages");
        button3.setId("forward");
        button4.setId("zoomIn");
        button5.setId("zoomOut");
        button6.setId("fitWidth");
        button7.setId("fitHeight");
        button8.setId("fitPage");
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                File file;
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Open PDF file");
                if (BaseViewerFX.this.file != null && (file = BaseViewerFX.this.file.getParentFile()).exists()) {
                    fileChooser.setInitialDirectory(file);
                }
                file = new FileChooser.ExtensionFilter("PDF files (*.pdf)", new String[]{"*.pdf"});
                fileChooser.getExtensionFilters().add((Object)file);
                BaseViewerFX.this.file = fileChooser.showOpenDialog(null);
                if (BaseViewerFX.this.file != null) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BaseViewerFX.this.loadPDF(BaseViewerFX.this.file);
                        }
                    });
                }
            }
        });
        comboBox.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                if (number2.intValue() != -1 && number2.intValue() + 1 != BaseViewerFX.this.currentPage) {
                    int n = number2.intValue() + 1;
                    BaseViewerFX.this.goToPage(n);
                }
            }
        });
        button2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (BaseViewerFX.this.currentPage > 1) {
                    BaseViewerFX.this.goToPage(BaseViewerFX.this.currentPage - 1);
                }
            }
        });
        button3.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (BaseViewerFX.this.currentPage < BaseViewerFX.this.pdf.getPageCount()) {
                    BaseViewerFX.this.goToPage(BaseViewerFX.this.currentPage + 1);
                }
            }
        });
        button4.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                BaseViewerFX.this.zoomMode = FitToPage.NONE;
                if (BaseViewerFX.this.currentScaling < BaseViewerFX.this.scalings.length - 1) {
                    BaseViewerFX.this.currentScaling = BaseViewerFX.findClosestIndex(BaseViewerFX.this.scale, BaseViewerFX.this.scalings);
                    if (BaseViewerFX.this.scale >= BaseViewerFX.this.scalings[BaseViewerFX.findClosestIndex(BaseViewerFX.this.scale, BaseViewerFX.this.scalings)]) {
                        BaseViewerFX.this.currentScaling++;
                    }
                    BaseViewerFX.this.scale = BaseViewerFX.this.scalings[BaseViewerFX.this.currentScaling];
                }
                BaseViewerFX.this.pdf.setPageParameters(BaseViewerFX.this.scale, BaseViewerFX.this.currentPage);
                BaseViewerFX.this.adjustPagePosition(BaseViewerFX.this.center.getViewportBounds());
            }
        });
        button5.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                BaseViewerFX.this.zoomMode = FitToPage.NONE;
                if (BaseViewerFX.this.currentScaling > 0) {
                    BaseViewerFX.this.currentScaling = BaseViewerFX.findClosestIndex(BaseViewerFX.this.scale, BaseViewerFX.this.scalings);
                    if (BaseViewerFX.this.scale <= BaseViewerFX.this.scalings[BaseViewerFX.findClosestIndex(BaseViewerFX.this.scale, BaseViewerFX.this.scalings)]) {
                        BaseViewerFX.this.currentScaling--;
                    }
                    BaseViewerFX.this.scale = BaseViewerFX.this.scalings[BaseViewerFX.this.currentScaling];
                }
                BaseViewerFX.this.pdf.setPageParameters(BaseViewerFX.this.scale, BaseViewerFX.this.currentPage);
                BaseViewerFX.this.adjustPagePosition(BaseViewerFX.this.center.getViewportBounds());
            }
        });
        button6.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                BaseViewerFX.this.zoomMode = FitToPage.WIDTH;
                BaseViewerFX.this.fitToX(FitToPage.WIDTH);
            }
        });
        button7.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                BaseViewerFX.this.zoomMode = FitToPage.HEIGHT;
                BaseViewerFX.this.fitToX(FitToPage.HEIGHT);
            }
        });
        button8.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                BaseViewerFX.this.zoomMode = FitToPage.AUTO;
                BaseViewerFX.this.fitToX(FitToPage.AUTO);
            }
        });
        Region region = new Region();
        Region region2 = new Region();
        HBox.setHgrow((Node)region, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)region2, (Priority)Priority.ALWAYS);
        ObservableList observableList = FXCollections.observableArrayList();
        for (FXViewerTransitions.TransitionType transitionType : FXViewerTransitions.TransitionType.values()) {
            observableList.add((Object)transitionType.name());
        }
        if (!observableList.isEmpty()) {
            comboBox2 = new ComboBox(observableList);
            comboBox2.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                    BaseViewerFX.this.transitionType = FXViewerTransitions.TransitionType.valueOf(string2);
                }
            });
            comboBox2.setValue(observableList.get(this.transitionType.ordinal()));
        }
        toolBar.getItems().addAll((Object[])new Node[]{button, region, button2, comboBox, label, button3, button4, button5, region2, comboBox2});
        return toolBar;
    }

    public void loadPDF(File file) {
        if (file == null) {
            return;
        }
        this.scale = 1.0f;
        this.PDFfile = file.getAbsolutePath();
        this.fileLoc.setText(this.PDFfile);
        this.openFile(file, null, false);
    }

    public void loadPDF(String string) {
        if (string == null) {
            return;
        }
        this.scale = 1.0f;
        this.PDFfile = string;
        this.fileLoc.setText(this.PDFfile);
        if (string.startsWith("http")) {
            this.openFile(null, string, true);
        } else {
            this.openFile(new File(string), null, false);
        }
    }

    private void openFile(File file, String string, boolean bl) {
        try {
            if (bl) {
                this.pdf.openPdfFileFromURL(string, false);
            } else {
                this.pdf.openPdfFile(file.getAbsolutePath());
            }
            if (this.customPluginHandle != null) {
                if (bl) {
                    this.customPluginHandle.setFileName(string);
                } else {
                    this.customPluginHandle.setFileName(file.getAbsolutePath());
                }
            }
            if (System.getProperty("org.jpedal.page") != null && !System.getProperty("org.jpedal.page").isEmpty()) {
                this.currentPage = this.currentPage < 1 ? 1 : this.currentPage;
                this.currentPage = this.currentPage > this.pdf.getPageCount() ? this.pdf.getPageCount() : this.currentPage;
            } else {
                this.currentPage = 1;
            }
            if (this.pdf.isEncrypted()) {
                int n = 0;
                this.closePasswordPrompt = false;
                while (!this.pdf.isFileViewable() && !this.closePasswordPrompt) {
                    if (System.getProperty("org.jpedal.password") != null) {
                        this.password = System.getProperty("org.jpedal.password");
                    } else if (!this.closePasswordPrompt) {
                        this.showPasswordPrompt(n);
                    }
                    if (this.password != null) {
                        if (bl) {
                            this.pdf.openPdfFileFromURL(string, false, this.password);
                        } else {
                            this.pdf.openPdfFile(file.getAbsolutePath());
                        }
                    }
                    ++n;
                }
            }
            ((Label)this.top.lookup("#pgCount")).setText("/" + this.pdf.getPageCount());
            ComboBox comboBox = (ComboBox)this.top.lookup("#pages");
            comboBox.getItems().clear();
            for (int i = 1; i <= this.pdf.getPageCount(); ++i) {
                comboBox.getItems().add((Object)String.valueOf(i));
            }
            this.goToPage(this.currentPage);
        }
        catch (PdfException pdfException) {
            pdfException.printStackTrace();
        }
    }

    private void showPasswordPrompt(int n) {
        Text text = new Text("Password Request");
        TextField textField = new TextField("Please Enter Password");
        if (n >= 1) {
            text.setText("Incorrect Password");
            textField.setText("Please Try Again");
        }
        FXInputDialog fXInputDialog = new FXInputDialog(this.stage, text.getText()){

            @Override
            protected void positiveClose() {
                super.positiveClose();
                BaseViewerFX.this.closePasswordPrompt = true;
            }
        };
        this.password = fXInputDialog.showInputDialog();
    }

    private void fitToX(FitToPage fitToPage) {
        if (fitToPage == FitToPage.NONE) {
            return;
        }
        float f = this.pdf.getPdfPageData().getCropBoxWidth2D(this.currentPage);
        float f2 = this.pdf.getPdfPageData().getCropBoxHeight2D(this.currentPage);
        int n = this.pdf.getPdfPageData().getRotation(this.currentPage);
        if (fitToPage == FitToPage.AUTO && f < f2) {
            if (this.pdf.getPDFWidth() < this.pdf.getPDFHeight()) {
                this.fitToX(FitToPage.HEIGHT);
            } else {
                this.fitToX(FitToPage.WIDTH);
            }
        }
        if (fitToPage == FitToPage.WIDTH) {
            float f3 = (float)this.scene.getWidth();
            this.scale = n == 90 || n == 270 ? (f3 - 25.0f - 25.0f) / f2 : (f3 - 25.0f - 25.0f) / f;
        } else if (fitToPage == FitToPage.HEIGHT) {
            float f4 = (float)(this.scene.getHeight() - this.top.getBoundsInLocal().getHeight() - this.bottom.getHeight());
            this.scale = n == 90 || n == 270 ? (f4 - 25.0f - 25.0f) / f : (f4 - 25.0f - 25.0f) / f2;
        }
        this.pdf.setPageParameters(this.scale, this.currentPage);
    }

    private static int findClosestIndex(float f, float[] fArray) {
        float f2 = Float.MAX_VALUE;
        int n = 0;
        for (int i = 0; i < fArray.length - 1; ++i) {
            float f3 = Math.abs(fArray[i] - f);
            if (!(f3 < f2)) continue;
            f2 = f3;
            n = i;
        }
        return n;
    }

    private void decodePage() {
        try {
            PdfPageData pdfPageData = this.pdf.getPdfPageData();
            int n = pdfPageData.getRotation(this.currentPage);
            if (n == 0 || n == 180) {
                this.pdf.setPageParameters(this.scale, this.currentPage);
            }
            this.pdf.decodePage(this.currentPage);
            this.pdf.waitForDecodingToFinish();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.fitToX(FitToPage.AUTO);
        this.updateNavButtons();
        this.setBorder();
        this.adjustPagePosition(this.center.getViewportBounds());
    }

    private void updateNavButtons() {
        if (this.currentPage > 1) {
            this.top.lookup("#back").setDisable(false);
        } else {
            this.top.lookup("#back").setDisable(true);
        }
        if (this.currentPage < this.pdf.getPageCount()) {
            this.top.lookup("#forward").setDisable(false);
        } else {
            this.top.lookup("#forward").setDisable(true);
        }
        ((ComboBox)this.top.lookup("#pages")).getSelectionModel().select(this.currentPage - 1);
    }

    private void goToPage(int n) {
        FXViewerTransitions.TransitionDirection transitionDirection = this.transitionType != FXViewerTransitions.TransitionType.Fade || this.transitionType != FXViewerTransitions.TransitionType.None ? (n > this.currentPage ? FXViewerTransitions.TransitionDirection.LEFT : FXViewerTransitions.TransitionDirection.RIGHT) : FXViewerTransitions.TransitionDirection.NONE;
        switch (this.transitionType) {
            case Fade: {
                this.startTransition(n, transitionDirection);
                break;
            }
            case Scale: {
                this.startTransition(n, transitionDirection);
                break;
            }
            case Rotate: {
                this.startTransition(n, transitionDirection);
                break;
            }
            case CardStack: {
                this.startTransition(n, transitionDirection);
                break;
            }
            default: {
                this.currentPage = n;
                this.decodePage();
            }
        }
    }

    private void startTransition(final int n, final FXViewerTransitions.TransitionDirection transitionDirection) {
        Transition transition = FXViewerTransitions.exitTransition(this.pdf, this.transitionType, transitionDirection);
        if (transition != null) {
            transition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    BaseViewerFX.this.currentPage = n;
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BaseViewerFX.this.decodePage();
                        }
                    });
                    FXViewerTransitions.TransitionDirection transitionDirection2 = transitionDirection;
                    if (transitionDirection != FXViewerTransitions.TransitionDirection.NONE) {
                        transitionDirection2 = transitionDirection == FXViewerTransitions.TransitionDirection.LEFT ? FXViewerTransitions.TransitionDirection.RIGHT : FXViewerTransitions.TransitionDirection.LEFT;
                    }
                    Transition transition = FXViewerTransitions.entryTransition(BaseViewerFX.this.pdf, BaseViewerFX.this.transitionType, transitionDirection2);
                    transition.play();
                }
            });
            transition.play();
        }
    }

    public String getPDFfilename() {
        return this.PDFfile;
    }

    private void adjustPagePosition(Bounds bounds) {
        double d = bounds.getWidth() / 2.0 - this.group.getBoundsInLocal().getWidth() / 2.0;
        if (d < 0.0) {
            d = 0.0;
        }
        this.group.setTranslateX(d);
    }

    private void setBorder() {
        int n = this.pdf.getPdfPageData().getRotation(this.currentPage);
        double d = n == 90 || n == 270 ? 40.0 : 0.0;
        double d2 = n == 90 || n == 270 ? 0.0 : 40.0;
        DropShadow dropShadow = new DropShadow(0.0, d, d2, Color.TRANSPARENT);
        this.pdf.setEffect((Effect)dropShadow);
    }

    public void addExternalHandler(PluginHandler pluginHandler) {
        this.customPluginHandle = pluginHandler;
    }

    public static enum FitToPage {
        AUTO,
        WIDTH,
        HEIGHT,
        NONE;

    }
}

