/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.handlers;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jpedal.external.ImageHandler;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PdfObject;

public class ExampleImageDecodeHandler
implements ImageHandler {
    @Override
    public boolean alwaysIgnoreGenericHandler() {
        return true;
    }

    @Override
    public boolean imageHasBeenScaled() {
        return true;
    }

    @Override
    public boolean drawImageOnscreen(BufferedImage bufferedImage, int n, AffineTransform affineTransform, String string, Graphics2D graphics2D, boolean bl, ObjectStore objectStore, boolean bl2) {
        return false;
    }

    @Override
    public BufferedImage processImageData(GraphicsState graphicsState, PdfObject pdfObject) {
        int n = (int)graphicsState.CTM[0][0];
        int n2 = (int)graphicsState.CTM[1][1];
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(0.0, -n2);
        affineTransform.scale(1.0, -1.0);
        graphics2D.setTransform(affineTransform);
        int n3 = n / "Image removed".length();
        Font font = new Font("serif", 0, n3);
        Rectangle2D rectangle2D = font.getStringBounds("Image removed", 0, "Image removed".length(), graphics2D.getFontRenderContext());
        graphics2D.setFont(font);
        graphics2D.drawString("Image removed", (int)(((double)n - rectangle2D.getWidth()) / 2.0), -n2 - n2 / 2);
        return bufferedImage;
    }
}

