/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.handlers;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ImageHelper;
import org.jpedal.utils.LogWriter;

public class StandardImageIO
implements ImageHelper {
    public StandardImageIO() {
        ImageIO.setUseCache(false);
    }

    @Override
    public void write(BufferedImage bufferedImage, String string, String string2) throws IOException {
        ImageIO.write((RenderedImage)bufferedImage, string, new File(string2));
    }

    @Override
    public BufferedImage read(String string) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new File(string));
        }
        catch (IOException iOException) {
            LogWriter.writeLog("Exception: " + iOException.getMessage());
        }
        catch (Error error) {
            LogWriter.writeLog("Error: " + error.getMessage());
            throw new RuntimeException("Error " + error + " loading " + string + " with ImageIO");
        }
        return bufferedImage;
    }

    @Override
    public synchronized BufferedImage read(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ImageIO.setUseCache(false);
        return ImageIO.read(byteArrayInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Raster readRasterFromJPeg(byte[] byArray) throws IOException {
        Raster raster = null;
        ImageReader imageReader = null;
        ImageInputStream imageInputStream = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ImageReader imageReader2;
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
            while (iterator.hasNext() && !(imageReader = (imageReader2 = iterator.next())).canReadRaster()) {
            }
            ImageIO.setUseCache(false);
            imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
            imageReader.setInput(imageInputStream, true);
            raster = imageReader.readRaster(0, null);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to find jars on classpath " + exception);
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
            if (imageInputStream != null) {
                imageInputStream.flush();
                imageInputStream.close();
            }
            if (imageReader != null) {
                imageReader.dispose();
            }
        }
        return raster;
    }

    @Override
    public BufferedImage JPEG2000ToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4) throws PdfException {
        return null;
    }
}

