/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import java.util.List;
import javafx.animation.FadeTransition;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import org.jpedal.examples.viewer.OpenViewerFX;
import org.jpedal.parser.DecoderOptions;

public class FXStartup
extends Application {
    private ProgressBar loadProgress;
    private Label progressText;
    OpenViewerFX viewer;
    private Pane splashLayout;
    private final Stage splashStage = new Stage();
    private static final int SPLASH_WIDTH = 600;
    private static final int SPLASH_HEIGHT = 200;

    public static void main(String[] stringArray) {
        DecoderOptions.javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        OpenViewerFX.checkUserJavaVersion();
        FXStartup.launch((String[])stringArray);
    }

    public void init() {
        String string = "/org/jpedal/examples/viewer/res/OSFXSplash.png";
        String string2 = "-fx-accent: purple;";
        ImageView imageView = new ImageView(((Object)((Object)this)).getClass().getResource(string).toExternalForm());
        this.loadProgress = new ProgressBar();
        this.loadProgress.setPrefWidth(600.0);
        this.progressText = new Label("All modules are loaded.");
        this.loadProgress.setStyle(string2);
        this.splashLayout = new VBox();
        this.splashLayout.getChildren().addAll((Object[])new Node[]{imageView, this.loadProgress, this.progressText});
        this.progressText.setAlignment(Pos.CENTER);
        this.splashLayout.setEffect((Effect)new DropShadow());
    }

    public void start(final Stage stage) {
        boolean bl = false;
        if (bl) {
            System.out.println("Starting the SplashScreen");
            Task task = new Task(){

                protected ObservableList<String> call() throws InterruptedException {
                    ObservableList observableList = FXCollections.observableArrayList();
                    ObservableList observableList2 = FXCollections.observableArrayList((Object[])new String[]{"Network Module", "User Module", "User Interface", "User Controls"});
                    this.updateMessage("Loading. . .");
                    for (int i = 0; i < observableList2.size(); ++i) {
                        Thread.sleep(900L);
                        this.updateProgress(i + 1, observableList2.size());
                        String string = (String)observableList2.get(i);
                        observableList.add((Object)string);
                        this.updateMessage("Loading . . .  " + string);
                    }
                    Thread.sleep(500L);
                    this.updateMessage("All Modules are loaded.");
                    return observableList;
                }
            };
            this.showSplash(task);
            task.setOnSucceeded(new EventHandler(){

                public void handle(Event event) {
                    FXStartup.this.startNew(stage);
                }
            });
            new Thread((Runnable)task).start();
        } else {
            this.startNew(stage);
        }
    }

    public void startNew(Stage stage) {
        List list = this.getParameters().getUnnamed();
        this.viewer = new OpenViewerFX(stage, list.toArray(new String[list.size()]));
        this.viewer.setupViewer();
    }

    private void showSplash(Task task) {
        this.progressText.textProperty().bind((ObservableValue)task.messageProperty());
        this.loadProgress.progressProperty().bind((ObservableValue)task.progressProperty());
        task.stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observableValue, Worker.State state, Worker.State state2) {
                if (state2 == Worker.State.SUCCEEDED) {
                    FXStartup.this.loadProgress.progressProperty().unbind();
                    FXStartup.this.loadProgress.setProgress(1.0);
                    FXStartup.this.splashStage.toFront();
                    FadeTransition fadeTransition = new FadeTransition(Duration.seconds((double)1.2), (Node)FXStartup.this.splashLayout);
                    fadeTransition.setFromValue(1.0);
                    fadeTransition.setToValue(0.0);
                    fadeTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                        public void handle(ActionEvent actionEvent) {
                            FXStartup.this.splashStage.hide();
                        }
                    });
                    fadeTransition.play();
                }
            }
        });
        Scene scene = new Scene((Parent)this.splashLayout);
        this.splashStage.initStyle(StageStyle.UNDECORATED);
        Rectangle2D rectangle2D = Screen.getPrimary().getBounds();
        this.splashStage.setScene(scene);
        this.splashStage.setX(rectangle2D.getMinX() + rectangle2D.getWidth() / 2.0 - 300.0);
        this.splashStage.setY(rectangle2D.getMinY() + rectangle2D.getHeight() / 2.0 - 100.0);
        this.splashStage.show();
    }

    public OpenViewerFX getViewer() {
        return this.viewer;
    }
}

