/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import java.util.Stack;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.MenuItem;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.RecentDocuments;
import org.jpedal.examples.viewer.RecentDocumentsFactory;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JavaFXRecentDocuments
implements RecentDocumentsFactory {
    final int noOfRecentDocs;
    private final Stack previousFiles = new Stack();
    private final Stack nextFiles = new Stack();
    public final MenuItem[] recentDocuments;

    public JavaFXRecentDocuments(int n) {
        this.noOfRecentDocs = n;
        this.recentDocuments = new MenuItem[n];
    }

    @Override
    public String getPreviousDocument() {
        String string = null;
        if (this.previousFiles.size() > 1) {
            this.nextFiles.push(this.previousFiles.pop());
            string = (String)this.previousFiles.pop();
        }
        return string;
    }

    @Override
    public String getNextDocument() {
        String string = null;
        if (!this.nextFiles.isEmpty()) {
            string = (String)this.nextFiles.pop();
        }
        return string;
    }

    @Override
    public void addToFileList(String string) {
        this.previousFiles.push(string);
    }

    @Override
    public void enableRecentDocuments(boolean bl) {
        if (this.recentDocuments == null) {
            return;
        }
        for (int i = 0; i < this.recentDocuments.length; ++i) {
            if (this.recentDocuments[i] == null || this.recentDocuments[i].getText().equals(i + 1 + ": ")) continue;
            this.recentDocuments[i].setVisible(bl);
            this.recentDocuments[i].setDisable(!bl);
        }
    }

    @Override
    public void updateRecentDocuments(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            String string = RecentDocuments.getShortenedFileName(stringArray[i]);
            if (this.recentDocuments[i] == null) {
                this.recentDocuments[i] = new MenuItem();
            }
            this.recentDocuments[i].setText(i + 1 + ": " + string);
            if (this.recentDocuments[i].getText().equals(i + 1 + ": ")) {
                this.recentDocuments[i].setVisible(false);
            } else {
                this.recentDocuments[i].setVisible(true);
            }
            this.recentDocuments[i].setId(stringArray[i]);
        }
    }

    @Override
    public void clearRecentDocuments(PropertiesFile propertiesFile) {
        NodeList nodeList = propertiesFile.getDoc().getElementsByTagName("recentfiles");
        if (nodeList != null && nodeList.getLength() > 0) {
            NodeList nodeList2 = ((Element)nodeList.item(0)).getElementsByTagName("*");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                nodeList.item(0).removeChild(node);
            }
        }
        for (int i = 0; i < this.noOfRecentDocs; ++i) {
            this.recentDocuments[i].setText(i + 1 + ": ");
            this.recentDocuments[i].setVisible(false);
        }
    }

    @Override
    public void createMenuItems(String string, int n, final GUIFactory gUIFactory, Values values, PdfDecoderInt pdfDecoderInt, PropertiesFile propertiesFile, GUIThumbnailPanel gUIThumbnailPanel, GUISearchWindow gUISearchWindow) {
        String string2 = RecentDocuments.getShortenedFileName(string);
        this.recentDocuments[n] = new MenuItem(n + 1 + ": " + string2);
        if (this.recentDocuments[n].getText().equals(n + 1 + ": ")) {
            this.recentDocuments[n].setVisible(false);
        }
        this.recentDocuments[n].setId(string);
        this.recentDocuments[n].setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (Values.isProcessing()) {
                    gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                } else {
                    System.out.println("SaveForm in JavaFXCommands recentDocumentsOption is not yet implemented for FX");
                    MenuItem menuItem = (MenuItem)actionEvent.getSource();
                    String string = menuItem.getId();
                    if (!string.isEmpty()) {
                        if (!Viewer.closeCalled) {
                            gUIFactory.open(string);
                        } else {
                            throw new RuntimeException("No resource to open document, call to close() disposes viewer resources");
                        }
                    }
                }
            }
        });
        gUIFactory.getMenuItems().addToMenu(this.recentDocuments[n], 317);
    }
}

