/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.jpedal.PdfDecoderFX;
import org.jpedal.examples.viewer.JavaFXCommands;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.ViewerInt;
import org.jpedal.examples.viewer.gui.JavaFxGUI;
import org.jpedal.examples.viewer.gui.javafx.JavaFXSearchWindow;
import org.jpedal.examples.viewer.gui.javafx.JavaFXThumbnailPanel;
import org.jpedal.examples.viewer.objects.ClientExternalHandler;
import org.jpedal.objects.acroforms.actions.JavaFXDefaultActionHandler;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class OpenViewerFX
extends Viewer
implements ViewerInt {
    protected Stage stage;
    private String[] args;

    public OpenViewerFX(Stage stage, String[] stringArray) {
        this.stage = stage;
        this.args = stringArray;
        this.init();
    }

    public OpenViewerFX(Parent parent, String string) {
        DecoderOptions.showErrorMessages = true;
        if (string != null && !string.isEmpty()) {
            try {
                this.properties.loadProperties(string);
            }
            catch (Exception exception) {
                System.err.println("Specified Preferrences file not found at " + string + ". If this file is within a jar ensure filename has jar: at the begining.\n\nLoading default properties. " + exception);
                this.properties.loadProperties();
            }
        } else {
            this.properties.loadProperties();
        }
        this.init();
        this.setRootContainer(parent);
    }

    @Override
    public void setupViewer() {
        super.setupViewer();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                OpenViewerFX.this.handleArguments(OpenViewerFX.this.args);
                if (OpenViewerFX.this.stage != null) {
                    OpenViewerFX.this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                        public void handle(WindowEvent windowEvent) {
                            OpenViewerFX.this.currentCommands.executeCommand(7, null);
                        }
                    });
                }
            }
        });
    }

    @Override
    void init() {
        try {
            Messages.setBundle(ResourceBundle.getBundle("org.jpedal.international.messages"));
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " loading resource bundle.\n" + "Also check you have a file in org.jpedal.international.messages to support Locale=" + Locale.getDefault());
        }
        this.decode_pdf = new PdfDecoderFX();
        this.thumbnails = new JavaFXThumbnailPanel(this.decode_pdf);
        this.currentGUI = new JavaFxGUI(this.stage, this.decode_pdf, this.commonValues, this.thumbnails, this.properties);
        this.decode_pdf.addExternalHandler(new JavaFXDefaultActionHandler(this.currentGUI), 5);
        this.decode_pdf.addExternalHandler(new ClientExternalHandler(), 39);
        this.searchFrame = new JavaFXSearchWindow(this.currentGUI);
        this.currentCommands = new JavaFXCommands(this.commonValues, this.currentGUI, this.decode_pdf, this.thumbnails, this.properties, this.searchFrame, this.currentPrinter);
        DecoderOptions.showErrorMessages = true;
        String string = System.getProperty("org.jpedal.Viewer.Prefs");
        if (string != null) {
            this.properties.loadProperties(string);
        } else {
            this.properties.loadProperties();
        }
    }

    @Override
    public void handleArguments(final String[] stringArray) {
        if (Platform.isFxApplicationThread()) {
            if (stringArray != null && stringArray.length > 0) {
                this.openDefaultFile(stringArray[0]);
            } else if (this.properties.getValue("openLastDocument").toLowerCase().equals("true") && this.properties.getRecentDocuments() != null && this.properties.getRecentDocuments().length > 1) {
                int n = Integer.parseInt(this.properties.getValue("lastDocumentPage"));
                if (n < 0) {
                    n = 1;
                }
                this.openDefaultFileAtPage(this.properties.getRecentDocuments()[0], n);
            }
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (stringArray.length > 0) {
                        OpenViewerFX.this.openDefaultFile(stringArray[0]);
                    } else if (OpenViewerFX.this.properties.getValue("openLastDocument").toLowerCase().equals("true") && OpenViewerFX.this.properties.getRecentDocuments() != null && OpenViewerFX.this.properties.getRecentDocuments().length > 1) {
                        int n = Integer.parseInt(OpenViewerFX.this.properties.getValue("lastDocumentPage"));
                        if (n < 0) {
                            n = 1;
                        }
                        OpenViewerFX.this.openDefaultFileAtPage(OpenViewerFX.this.properties.getRecentDocuments()[0], n);
                    }
                }
            };
            Platform.runLater((Runnable)runnable);
        }
    }

    public void close() {
        Viewer.closeCalled = true;
        this.currentCommands.executeCommand(7, null);
    }

    public OpenViewerFX(String[] stringArray) {
        this(null, stringArray);
    }

    public BorderPane getRoot() {
        return ((JavaFxGUI)this.currentGUI).getRoot();
    }

    protected static void checkUserJavaVersion() {
        if (Float.parseFloat(System.getProperty("java.specification.version")) < 1.8f) {
            throw new RuntimeException("To run the JPedal FX Viewer, you must have Java8 or above installed");
        }
    }

    static {
        OpenViewerFX.checkUserJavaVersion();
        isFX = true;
    }
}

