/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.JMenuItem;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.RecentDocumentsFactory;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.SaveForm;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RecentDocuments
implements RecentDocumentsFactory {
    public final int noOfRecentDocs;
    private final Stack previousFiles = new Stack();
    private final Stack nextFiles = new Stack();
    public final JMenuItem[] recentDocuments;

    public RecentDocuments(int n) {
        this.noOfRecentDocs = n;
        this.recentDocuments = new JMenuItem[n];
    }

    static String getShortenedFileName(String string) {
        if (string.length() <= 30) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\/");
        int n = stringTokenizer.countTokens();
        if (n == 1) {
            return string.substring(0, 30);
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        String string2 = string.substring(stringArray[0].length(), string.length() - stringArray[n - 1].length());
        StringBuilder stringBuilder = new StringBuilder(string2);
        for (int i = n - 2; i > 0; --i) {
            int n2 = stringBuilder.lastIndexOf(stringArray[i]);
            int n3 = n2 + stringArray[i].length();
            stringBuilder.replace(n2, n3, "...");
            if (stringBuilder.length() <= 30) break;
        }
        return stringArray[0] + stringBuilder + stringArray[n - 1];
    }

    @Override
    public String getPreviousDocument() {
        String string = null;
        if (this.previousFiles.size() > 1) {
            this.nextFiles.push(this.previousFiles.pop());
            string = (String)this.previousFiles.pop();
        }
        return string;
    }

    @Override
    public String getNextDocument() {
        String string = null;
        if (!this.nextFiles.isEmpty()) {
            string = (String)this.nextFiles.pop();
        }
        return string;
    }

    @Override
    public void addToFileList(String string) {
        this.previousFiles.push(string);
    }

    @Override
    public void enableRecentDocuments(boolean bl) {
        if (this.recentDocuments == null) {
            return;
        }
        for (int i = 0; i < this.recentDocuments.length; ++i) {
            if (this.recentDocuments[i] == null || this.recentDocuments[i].getText().equals(i + 1 + ": ")) continue;
            this.recentDocuments[i].setVisible(bl);
            this.recentDocuments[i].setEnabled(bl);
        }
    }

    @Override
    public void updateRecentDocuments(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            String string = RecentDocuments.getShortenedFileName(stringArray[i]);
            if (this.recentDocuments[i] == null) {
                this.recentDocuments[i] = new JMenuItem();
            }
            this.recentDocuments[i].setText(i + 1 + ": " + string);
            if (this.recentDocuments[i].getText().equals(i + 1 + ": ")) {
                this.recentDocuments[i].setVisible(false);
            } else {
                this.recentDocuments[i].setVisible(true);
            }
            this.recentDocuments[i].setName(stringArray[i]);
        }
    }

    @Override
    public void clearRecentDocuments(PropertiesFile propertiesFile) {
        NodeList nodeList = propertiesFile.getDoc().getElementsByTagName("recentfiles");
        if (nodeList != null && nodeList.getLength() > 0) {
            NodeList nodeList2 = ((Element)nodeList.item(0)).getElementsByTagName("*");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                nodeList.item(0).removeChild(node);
            }
        }
        for (int i = 0; i < this.noOfRecentDocs; ++i) {
            this.recentDocuments[i].setText(i + 1 + ": ");
            this.recentDocuments[i].setVisible(false);
        }
    }

    @Override
    public void createMenuItems(String string, int n, final GUIFactory gUIFactory, final Values values, final PdfDecoderInt pdfDecoderInt, PropertiesFile propertiesFile, GUIThumbnailPanel gUIThumbnailPanel, GUISearchWindow gUISearchWindow) {
        String string2 = RecentDocuments.getShortenedFileName(string);
        this.recentDocuments[n] = new JMenuItem(n + 1 + ": " + string2);
        if (this.recentDocuments[n].getText().equals(n + 1 + ": ")) {
            this.recentDocuments[n].setVisible(false);
        }
        this.recentDocuments[n].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Values.isProcessing()) {
                    gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                } else {
                    SaveForm.handleUnsaveForms(gUIFactory, values, pdfDecoderInt);
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    String string = jMenuItem.getName();
                    if (!string.isEmpty()) {
                        gUIFactory.open(string);
                    }
                }
            }
        });
        this.recentDocuments[n].setName(string);
        gUIFactory.getMenuItems().addToMenu(this.recentDocuments[n], 317);
    }
}

