/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import java.awt.Container;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.ViewerInt;
import org.jpedal.examples.viewer.commands.OpenFile;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.utils.PrinterInt;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.raw.OutlineObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class Viewer
implements ViewerInt {
    public static final String PREFERENCES_DEFAULT = "jar:/org/jpedal/examples/viewer/res/preferences/Default.xml";
    public static final String PREFERENCES_NO_GUI = "jar:/org/jpedal/examples/viewer/res/preferences/NoGUI.xml";
    public static final String PREFERENCES_NO_SIDE_BAR = "jar:/org/jpedal/examples/viewer/res/preferences/NoSideTabOrTopButtons.xml";
    public static final String PREFERENCES_OPEN_AND_NAV_ONLY = "jar:/org/jpedal/examples/viewer/res/preferences/OpenAndNavOnly.xml";
    public static final String PREFERENCES_BEAN = "jar:/org/jpedal/examples/viewer/res/preferences/Bean.xml";
    protected Values commonValues = new Values();
    PrinterInt currentPrinter;
    PdfDecoderInt decode_pdf;
    GUIThumbnailPanel thumbnails;
    PropertiesFile properties = new PropertiesFile();
    protected GUIFactory currentGUI;
    GUISearchWindow searchFrame;
    protected Commands currentCommands;
    private boolean isSetup;
    public static boolean exitOnClose = true;
    public static boolean closeCalled;
    static boolean isFX;

    @Override
    public void openDefaultFile(String string) {
        String string2;
        String string3 = System.getProperty("org.jpedal.hires");
        if (DecoderOptions.hires || string3 != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((string2 = System.getProperty("org.jpedal.memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.resetToDefault();
        }
        this.commonValues.maxViewY = 0;
        if (string != null) {
            File file = new File(string);
            boolean bl = false;
            if (string.startsWith("http:") || string.startsWith("jar:") || string.startsWith("file:")) {
                LogWriter.writeLog("Opening http connection");
                bl = true;
            }
            if (!bl && !file.exists()) {
                this.currentGUI.showMessageDialog(string + '\n' + Messages.getMessage("PdfViewerdoesNotExist.message"));
            } else if (!bl && file.isDirectory()) {
                this.currentGUI.showMessageDialog(string + '\n' + Messages.getMessage("PdfViewerFileIsDirectory.message"));
            } else {
                this.commonValues.setFileSize(file.length() >> 10);
                this.commonValues.setSelectedFile(string);
                this.currentGUI.setViewerTitle(null);
                String string4 = System.getProperty("org.jpedal.page");
                String string5 = System.getProperty("org.jpedal.bookmark");
                if (string4 != null && !bl) {
                    try {
                        int n = Integer.parseInt(string4);
                        if (n < 1) {
                            n = -1;
                            System.err.println(string4 + " must be 1 or larger. Opening on page 1");
                            LogWriter.writeLog(string4 + " must be 1 or larger. Opening on page 1");
                        }
                        if (n != -1) {
                            this.openFile(file, n);
                        }
                    }
                    catch (Exception exception) {
                        System.err.println(string4 + "is not a valid number for a page number. Opening on page 1 " + exception);
                        LogWriter.writeLog(string4 + "is not a valid number for a page number. Opening on page 1");
                    }
                } else if (string5 != null) {
                    this.openFile(file, string5);
                } else {
                    this.currentGUI.openFile(string);
                }
            }
        }
    }

    @Override
    public void openDefaultFileAtPage(String string, int n) {
        String string2;
        String string3 = System.getProperty("org.jpedal.hires");
        if (DecoderOptions.hires || string3 != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((string2 = System.getProperty("org.jpedal.memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.resetToDefault();
        }
        this.commonValues.maxViewY = 0;
        if (string != null) {
            File file = new File(string);
            boolean bl = false;
            if (string.startsWith("http:") || string.startsWith("jar:")) {
                LogWriter.writeLog("Opening http connection");
                bl = true;
            }
            if (!bl && !file.exists()) {
                this.currentGUI.showMessageDialog(string + '\n' + Messages.getMessage("PdfViewerdoesNotExist.message"));
            } else if (!bl && file.isDirectory()) {
                this.currentGUI.showMessageDialog(string + '\n' + Messages.getMessage("PdfViewerFileIsDirectory.message"));
            } else {
                this.commonValues.setSelectedFile(string);
                this.commonValues.setFileSize(file.length() >> 10);
                this.currentGUI.setViewerTitle(null);
                this.openFile(file, n);
            }
        }
    }

    public PdfDecoderInt getPdfDecoder() {
        return this.decode_pdf;
    }

    void init() {
    }

    public Viewer() {
        if (isFX) {
            return;
        }
        this.init();
        DecoderOptions.showErrorMessages = true;
        String string = System.getProperty("org.jpedal.Viewer.Prefs");
        if (string != null) {
            this.properties.loadProperties(string);
        } else {
            this.properties.loadProperties();
        }
    }

    public Viewer(int n) {
        this.init();
        DecoderOptions.showErrorMessages = true;
        String string = System.getProperty("org.jpedal.Viewer.Prefs");
        if (string != null) {
            this.properties.loadProperties(string);
        } else {
            this.properties.loadProperties();
        }
        this.commonValues.setModeOfOperation(n);
    }

    public Viewer(String string) {
        this.init();
        DecoderOptions.showErrorMessages = true;
        try {
            this.properties.loadProperties(string);
        }
        catch (Exception exception) {
            System.err.println("Specified Preferrences file not found at " + string + ". If this file is within a jar ensure filename has jar: at the begining.\n\nLoading default properties. " + exception);
            this.properties.loadProperties();
        }
    }

    public Viewer(Object object, String string) {
        this.init();
        DecoderOptions.showErrorMessages = true;
        if (string != null && !string.isEmpty()) {
            try {
                this.properties.loadProperties(string);
            }
            catch (Exception exception) {
                System.err.println("Specified Preferrences file not found at " + string + ". If this file is within a jar ensure filename has jar: at the begining.\n\nLoading default properties. " + exception);
                this.properties.loadProperties();
            }
        } else {
            this.properties.loadProperties();
        }
        this.setRootContainer(object);
    }

    @Override
    public void setRootContainer(Object object) {
        this.currentGUI.setRootContainer(object);
    }

    @Override
    public void loadProperties(String string) {
        this.properties.loadProperties(string);
    }

    public void loadProperties(InputStream inputStream) {
        this.properties.loadProperties(inputStream);
    }

    @Override
    public void setupViewer() {
        boolean bl;
        Object object;
        String string;
        String string2 = System.getProperty("org.jpedal.suppressViewerPopups");
        boolean bl2 = false;
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            bl2 = true;
        }
        if ((string = this.properties.getValue("searchWindowType")) != null && !string.isEmpty()) {
            int n = Integer.parseInt(string);
            this.searchFrame.setViewStyle(n);
        } else {
            this.searchFrame.setViewStyle(2);
        }
        this.searchFrame.setUpdateListDuringSearch(this.properties.getValue("updateResultsDuringSearch").equals("true"));
        this.currentGUI.setSearchFrame(this.searchFrame);
        String string3 = System.getProperty("org.jpedal.thumbnail");
        if (string3 != null) {
            if (string3.equals("true")) {
                this.thumbnails.setThumbnailsEnabled(true);
            } else if (string3.equals("false")) {
                this.thumbnails.setThumbnailsEnabled(false);
            }
        } else {
            this.thumbnails.setThumbnailsEnabled(true);
        }
        String string4 = System.getProperty("org.jpedal.bundleLocation");
        if (string4 != null) {
            ClassLoader classLoader = Messages.class.getClassLoader();
            String string5 = string4.replaceAll("\\.", "/") + '_' + Locale.getDefault().getLanguage() + ".properties";
            try {
                object = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(string5)));
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {
                Locale.setDefault(new Locale("en", "EN"));
                this.currentGUI.showMessageDialog("No locale file " + string5 + " has been defined for this Locale - using English as Default" + "\n Format is path, using '.' as break ie org.jpedal.international.messages");
            }
            this.init(ResourceBundle.getBundle(string4));
        } else {
            this.init(null);
        }
        this.currentGUI.init(this.currentCommands, this.currentPrinter);
        if (this.searchFrame.getViewStyle() == 1) {
            this.currentGUI.searchInTab(this.searchFrame);
        }
        if (!isFX) {
            this.decode_pdf.getDynamicRenderer().setMessageFrame((Container)this.currentGUI.getFrame());
        }
        object = this.properties.getValue("showfirsttimepopup");
        boolean bl3 = bl = !bl2 && !((String)object).isEmpty() && ((String)object).equals("true");
        if (bl) {
            this.currentGUI.showFirstTimePopup();
            this.properties.setValue("showfirsttimepopup", "false");
        }
        object = this.properties.getValue("displaytipsonstartup");
        if (!bl2 && !((String)object).isEmpty() && ((String)object).equals("true")) {
            this.currentCommands.executeCommand(20, null);
        }
        this.isSetup = true;
    }

    protected void init(ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            try {
                Messages.setBundle(ResourceBundle.getBundle("org.jpedal.international.messages"));
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " loading resource bundle.\n" + "Also check you have a file in org.jpedal.international.messages to support Locale=" + Locale.getDefault());
            }
        } else {
            try {
                Messages.setBundle(resourceBundle);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception with bundle " + resourceBundle);
                exception.printStackTrace();
            }
        }
        this.decode_pdf.addExternalHandler(this.currentGUI, 4);
        DecoderOptions.embedWidthData = true;
        this.decode_pdf.setExtractionMode(0, 1.0f);
        FontMappings.setFontReplacements();
    }

    public static void main(String[] stringArray) {
        if (isFX) {
            System.out.println("Please run ViewerFx using java -cp jpedal.jar org.jpedal.examples.viewer.FXStartup");
            System.exit(1);
        }
        Viewer viewer = new Viewer();
        viewer.setupViewer();
        viewer.handleArguments(stringArray);
    }

    @Override
    public void handleArguments(final String[] stringArray) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (stringArray.length > 0) {
                this.openDefaultFile(stringArray[0]);
            } else if (this.properties.getValue("openLastDocument").equalsIgnoreCase("true") && this.properties.getRecentDocuments() != null && this.properties.getRecentDocuments().length > 1) {
                int n = Integer.parseInt(this.properties.getValue("lastDocumentPage"));
                if (n < 0) {
                    n = 1;
                }
                this.openDefaultFileAtPage(this.properties.getRecentDocuments()[0], n);
            }
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (stringArray.length > 0) {
                        Viewer.this.openDefaultFile(stringArray[0]);
                    } else if (Viewer.this.properties.getValue("openLastDocument").toLowerCase().equals("true") && Viewer.this.properties.getRecentDocuments() != null && Viewer.this.properties.getRecentDocuments().length > 1) {
                        int n = Integer.parseInt(Viewer.this.properties.getValue("lastDocumentPage"));
                        if (n < 0) {
                            n = 1;
                        }
                        Viewer.this.openDefaultFileAtPage(Viewer.this.properties.getRecentDocuments()[0], n);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void openFile(File file, String string) {
        try {
            Object object;
            boolean bl = OpenFile.openUpFile(file.getCanonicalPath(), this.commonValues, this.searchFrame, this.currentGUI, this.decode_pdf, this.properties, this.thumbnails);
            String string2 = null;
            int n = -1;
            if (this.decode_pdf.getOutlineAsXML() != null) {
                object = this.decode_pdf.getOutlineAsXML().getFirstChild();
                if (object != null) {
                    string2 = this.currentGUI.getBookmark(string);
                }
                if (string2 != null) {
                    n = Integer.parseInt(string2);
                }
            }
            if (string2 == null && (string2 = this.decode_pdf.getIO().convertNameToRef(string)) != null) {
                object = new OutlineObject(string2);
                this.decode_pdf.getIO().readObject((PdfObject)object);
                if (bl) {
                    OpenFile.processPage(this.commonValues, this.decode_pdf, this.currentGUI, this.thumbnails);
                }
                this.decode_pdf.getFormRenderer().getActionHandler().gotoDest((PdfObject)object, 3, 339034948);
            }
            if (string2 == null) {
                throw new PdfException("Unknown bookmark " + string);
            }
            if (n > -1) {
                this.commonValues.setCurrentPage(n);
                if (bl) {
                    OpenFile.processPage(this.commonValues, this.decode_pdf, this.currentGUI, this.thumbnails);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " processing file");
            Values.setProcessing(false);
        }
    }

    private void openFile(File file, int n) {
        try {
            boolean bl = OpenFile.openUpFile(file.getCanonicalPath(), this.commonValues, this.searchFrame, this.currentGUI, this.decode_pdf, this.properties, this.thumbnails);
            this.commonValues.setCurrentPage(n);
            if (bl) {
                OpenFile.processPage(this.commonValues, this.decode_pdf, this.currentGUI, this.thumbnails);
            }
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " processing file");
            Values.setProcessing(false);
        }
    }

    @Override
    public Object executeCommand(int n, Object[] objectArray) {
        if (!this.isSetup) {
            throw new RuntimeException("You must call viewer.setupViewer(); before you call any commands");
        }
        return this.currentCommands.executeCommand(n, objectArray);
    }

    public static boolean isProcessing() {
        return Values.isProcessing();
    }

    @Override
    public void addExternalHandler(Object object, int n) {
        this.decode_pdf.addExternalHandler(object, n);
    }

    @Override
    public void dispose() {
        this.commonValues = null;
        this.currentPrinter = null;
        if (this.thumbnails != null) {
            this.thumbnails.dispose();
        }
        this.thumbnails = null;
        if (this.properties != null) {
            this.properties.dispose();
        }
        this.properties = null;
        if (this.currentGUI != null) {
            this.currentGUI.dispose();
        }
        this.currentGUI = null;
        this.searchFrame = null;
        this.currentCommands = null;
        if (this.decode_pdf != null) {
            this.decode_pdf.dispose();
        }
        this.decode_pdf = null;
        Messages.dispose();
    }

    public static boolean isFX() {
        return isFX;
    }
}

